/*
 * Decompiled with CFR 0.152.
 */
package junit.framework;

import junit.framework.AssertionFailedError;
import junit.framework.ComparisonFailure;

public class Assert {
    protected Assert() {
    }

    public static final void assertTrue(String string, boolean bl) {
        if (!bl) {
            Assert.fail(string);
        }
    }

    public static final void assertTrue(boolean bl) {
        Assert.assertTrue(null, bl);
    }

    public static final void assertFalse(String string, boolean bl) {
        Assert.assertTrue(string, !bl);
    }

    public static final void assertFalse(boolean bl) {
        Assert.assertFalse(null, bl);
    }

    public static final void fail(String string) {
        throw new AssertionFailedError(string);
    }

    public static final void fail() {
        Assert.fail(null);
    }

    public static final void assertEquals(String string, Object object, Object object2) {
        if (object == null && object2 == null) {
            return;
        }
        if (object != null && object.equals(object2)) {
            return;
        }
        Assert.failNotEquals(string, object, object2);
    }

    public static final void assertEquals(Object object, Object object2) {
        Assert.assertEquals(null, object, object2);
    }

    public static final void assertEquals(String string, String string2, String string3) {
        if (string2 == null && string3 == null) {
            return;
        }
        if (string2 != null && string2.equals(string3)) {
            return;
        }
        throw new ComparisonFailure(string, string2, string3);
    }

    public static final void assertEquals(String string, String string2) {
        Assert.assertEquals(null, string, string2);
    }

    public static final void assertEquals(String string, double d2, double d3, double d4) {
        if (Double.isInfinite(d2)) {
            if (d2 != d3) {
                Assert.failNotEquals(string, new Double(d2), new Double(d3));
            }
        } else if (!(Math.abs(d2 - d3) <= d4)) {
            Assert.failNotEquals(string, new Double(d2), new Double(d3));
        }
    }

    public static final void assertEquals(double d2, double d3, double d4) {
        Assert.assertEquals(null, d2, d3, d4);
    }

    public static final void assertEquals(String string, float f2, float f3, float f4) {
        if (Float.isInfinite(f2)) {
            if (f2 != f3) {
                Assert.failNotEquals(string, new Float(f2), new Float(f3));
            }
        } else if (!(Math.abs(f2 - f3) <= f4)) {
            Assert.failNotEquals(string, new Float(f2), new Float(f3));
        }
    }

    public static final void assertEquals(float f2, float f3, float f4) {
        Assert.assertEquals(null, f2, f3, f4);
    }

    public static final void assertEquals(String string, long l2, long l3) {
        Assert.assertEquals(string, new Long(l2), new Long(l3));
    }

    public static final void assertEquals(long l2, long l3) {
        Assert.assertEquals(null, l2, l3);
    }

    public static final void assertEquals(String string, boolean bl, boolean bl2) {
        Assert.assertEquals(string, new Boolean(bl), new Boolean(bl2));
    }

    public static final void assertEquals(boolean bl, boolean bl2) {
        Assert.assertEquals(null, bl, bl2);
    }

    public static final void assertEquals(String string, byte by, byte by2) {
        Assert.assertEquals(string, new Byte(by), new Byte(by2));
    }

    public static final void assertEquals(byte by, byte by2) {
        Assert.assertEquals(null, by, by2);
    }

    public static final void assertEquals(String string, char c2, char c3) {
        Assert.assertEquals(string, new Character(c2), new Character(c3));
    }

    public static final void assertEquals(char c2, char c3) {
        Assert.assertEquals(null, c2, c3);
    }

    public static final void assertEquals(String string, short s, short s2) {
        Assert.assertEquals(string, new Short(s), new Short(s2));
    }

    public static final void assertEquals(short s, short s2) {
        Assert.assertEquals(null, s, s2);
    }

    public static final void assertEquals(String string, int n, int n2) {
        Assert.assertEquals(string, new Integer(n), new Integer(n2));
    }

    public static final void assertEquals(int n, int n2) {
        Assert.assertEquals(null, n, n2);
    }

    public static final void assertNotNull(Object object) {
        Assert.assertNotNull(null, object);
    }

    public static final void assertNotNull(String string, Object object) {
        Assert.assertTrue(string, object != null);
    }

    public static final void assertNull(Object object) {
        Assert.assertNull(null, object);
    }

    public static final void assertNull(String string, Object object) {
        Assert.assertTrue(string, object == null);
    }

    public static final void assertSame(String string, Object object, Object object2) {
        if (object == object2) {
            return;
        }
        Assert.failNotSame(string, object, object2);
    }

    public static final void assertSame(Object object, Object object2) {
        Assert.assertSame(null, object, object2);
    }

    public static final void assertNotSame(String string, Object object, Object object2) {
        if (object == object2) {
            Assert.failSame(string);
        }
    }

    public static final void assertNotSame(Object object, Object object2) {
        Assert.assertNotSame(null, object, object2);
    }

    private static void failSame(String string) {
        String string2 = "";
        if (string != null) {
            string2 = String.valueOf(string) + " ";
        }
        Assert.fail(String.valueOf(string2) + "expected not same");
    }

    private static void failNotSame(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = String.valueOf(string) + " ";
        }
        Assert.fail(String.valueOf(string2) + "expected same:<" + object + "> was not:<" + object2 + ">");
    }

    private static void failNotEquals(String string, Object object, Object object2) {
        Assert.fail(Assert.format(string, object, object2));
    }

    static final String format(String string, Object object, Object object2) {
        String string2 = "";
        if (string != null) {
            string2 = String.valueOf(string) + " ";
        }
        return String.valueOf(string2) + "expected:<" + object + "> but was:<" + object2 + ">";
    }
}

