/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.operator;

import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.ColorCube;
import javax.media.jai.KernelJAI;
import javax.media.jai.OperationDescriptorImpl;
import javax.media.jai.operator.JaiI18N;

public class OrderedDitherDescriptor
extends OperationDescriptorImpl {
    private static final String[][] resources = new String[][]{{"GlobalName", "OrderedDither"}, {"LocalName", "OrderedDither"}, {"Vendor", "com.sun.media.jai"}, {"Description", JaiI18N.getString("OrderedDitherDescriptor0")}, {"DocURL", "http://java.sun.com/products/java-media/jai/forDevelopers/jai-apidocs/javax/media/jai/operator/OrderedDitherDescriptor.html"}, {"Version", JaiI18N.getString("DescriptorVersion")}, {"arg0Desc", JaiI18N.getString("OrderedDitherDescriptor1")}, {"arg1Desc", JaiI18N.getString("OrderedDitherDescriptor2")}};
    private static final String[] paramNames = new String[]{"colorMap", "ditherMask"};
    private static final Class[] paramClasses = new Class[]{class$javax$media$jai$ColorCube != null ? class$javax$media$jai$ColorCube : (class$javax$media$jai$ColorCube = OrderedDitherDescriptor.class$("javax.media.jai.ColorCube")), array$Ljavax$media$jai$KernelJAI != null ? array$Ljavax$media$jai$KernelJAI : (array$Ljavax$media$jai$KernelJAI = OrderedDitherDescriptor.class$("[Ljavax.media.jai.KernelJAI;"))};
    private static final Object[] paramDefaults = new Object[]{ColorCube.BYTE_496, KernelJAI.DITHER_MASK_443};
    static Class class$javax$media$jai$ColorCube;
    static Class array$Ljavax$media$jai$KernelJAI;

    public OrderedDitherDescriptor() {
        super(resources, 1, paramClasses, paramNames, paramDefaults);
    }

    static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static boolean isValidColorMap(RenderedImage renderedImage, ColorCube colorCube, StringBuffer stringBuffer) {
        SampleModel sampleModel = renderedImage.getSampleModel();
        if (colorCube.getDataType() != sampleModel.getTransferType()) {
            stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor3"));
            return false;
        }
        if (colorCube.getNumBands() != sampleModel.getNumBands()) {
            stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor4"));
            return false;
        }
        return true;
    }

    private static boolean isValidDitherMask(RenderedImage renderedImage, KernelJAI[] kernelJAIArray, StringBuffer stringBuffer) {
        if (kernelJAIArray.length != renderedImage.getSampleModel().getNumBands()) {
            stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor5"));
            return false;
        }
        int n = kernelJAIArray[0].getWidth();
        int n2 = kernelJAIArray[0].getHeight();
        int n3 = 0;
        while (n3 < kernelJAIArray.length) {
            if (kernelJAIArray[n3].getWidth() != n || kernelJAIArray[n3].getHeight() != n2) {
                stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor6"));
                return false;
            }
            float[] fArray = kernelJAIArray[n3].getKernelData();
            int n4 = 0;
            while (n4 < fArray.length) {
                if (fArray[n4] < 0.0f || (double)fArray[n4] > 1.0) {
                    stringBuffer.append(JaiI18N.getString("OrderedDitherDescriptor7"));
                    return false;
                }
                ++n4;
            }
            ++n3;
        }
        return true;
    }

    public final boolean validateArguments(ParameterBlock parameterBlock, StringBuffer stringBuffer) {
        if (!super.validateArguments(parameterBlock, stringBuffer)) {
            return false;
        }
        RenderedImage renderedImage = parameterBlock.getRenderedSource(0);
        ColorCube colorCube = (ColorCube)parameterBlock.getObjectParameter(0);
        KernelJAI[] kernelJAIArray = (KernelJAI[])parameterBlock.getObjectParameter(1);
        if (!OrderedDitherDescriptor.isValidColorMap(renderedImage, colorCube, stringBuffer)) {
            return false;
        }
        return OrderedDitherDescriptor.isValidDitherMask(renderedImage, kernelJAIArray, stringBuffer);
    }
}

