/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.iterator;

import com.sun.media.jai.iterator.RandomIterFallback;
import com.sun.media.jai.iterator.WrapperRI;
import com.sun.media.jai.iterator.WrapperWRI;
import com.sun.media.jai.iterator.WritableRandomIterFallback;
import java.awt.Rectangle;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.awt.image.WritableRenderedImage;
import javax.media.jai.iterator.RandomIter;
import javax.media.jai.iterator.WritableRandomIter;

public class RandomIterFactory {
    private RandomIterFactory() {
    }

    public static final RandomIter create(Raster raster, Rectangle rectangle) {
        WrapperRI wrapperRI = new WrapperRI(raster);
        return RandomIterFactory.create(wrapperRI, rectangle);
    }

    public static final RandomIter create(RenderedImage renderedImage, Rectangle rectangle) {
        SampleModel sampleModel;
        if (rectangle == null) {
            rectangle = new Rectangle(renderedImage.getMinX(), renderedImage.getMinY(), renderedImage.getWidth(), renderedImage.getHeight());
        }
        if ((sampleModel = renderedImage.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sampleModel.getDataType()) {
                default: 
            }
        }
        return new RandomIterFallback(renderedImage, rectangle);
    }

    public static final WritableRandomIter createWritable(WritableRaster writableRaster, Rectangle rectangle) {
        WrapperWRI wrapperWRI = new WrapperWRI(writableRaster);
        return RandomIterFactory.createWritable(wrapperWRI, rectangle);
    }

    public static final WritableRandomIter createWritable(WritableRenderedImage writableRenderedImage, Rectangle rectangle) {
        SampleModel sampleModel;
        if (rectangle == null) {
            rectangle = new Rectangle(writableRenderedImage.getMinX(), writableRenderedImage.getMinY(), writableRenderedImage.getWidth(), writableRenderedImage.getHeight());
        }
        if ((sampleModel = writableRenderedImage.getSampleModel()) instanceof ComponentSampleModel) {
            switch (sampleModel.getDataType()) {
                default: 
            }
        }
        return new WritableRandomIterFallback(writableRenderedImage, rectangle);
    }
}

