/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import javax.media.jai.JaiI18N;
import javax.media.jai.Warp;

public final class WarpGrid
extends Warp {
    private int xStart;
    private int yStart;
    private int xEnd;
    private int yEnd;
    private int xStep;
    private int yStep;
    private int xNumCells;
    private int yNumCells;
    private float[] xWarpPos;
    private float[] yWarpPos;

    public WarpGrid(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        if (fArray.length != 2 * (n3 + 1) * (n6 + 1)) {
            throw new IllegalArgumentException(JaiI18N.getString("WarpGrid0"));
        }
        this.initialize(n, n2, n3, n4, n5, n6, fArray);
    }

    public WarpGrid(Warp warp, int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = 2 * (n3 + 1) * (n6 + 1);
        float[] fArray = new float[n7];
        fArray = warp.warpSparseRect(n, n4, n3 * n2 + 1, n6 * n5 + 1, n2, n5, fArray);
        this.initialize(n, n2, n3, n4, n5, n6, fArray);
    }

    public final int getXNumCells() {
        return this.xNumCells;
    }

    public final int getXStart() {
        return this.xStart;
    }

    public final int getXStep() {
        return this.xStep;
    }

    public final float[] getXWarpPos() {
        return this.xWarpPos;
    }

    public final int getYNumCells() {
        return this.yNumCells;
    }

    public final int getYStart() {
        return this.yStart;
    }

    public final int getYStep() {
        return this.yStep;
    }

    public final float[] getYWarpPos() {
        return this.yWarpPos;
    }

    private void initialize(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        this.xStart = n;
        this.yStart = n4;
        this.xEnd = n + n2 * n3;
        this.yEnd = n4 + n5 * n6;
        this.xStep = n2;
        this.yStep = n5;
        this.xNumCells = n3;
        this.yNumCells = n6;
        int n7 = n3 + 1;
        int n8 = n6 + 1;
        int n9 = n8 * n7;
        this.xWarpPos = new float[n9];
        this.yWarpPos = new float[n9];
        int n10 = 0;
        int n11 = 0;
        while (n11 < n9) {
            this.xWarpPos[n11] = fArray[n10++];
            this.yWarpPos[n11] = fArray[n10++];
            ++n11;
        }
    }

    public final Rectangle mapDestRect(Rectangle rectangle) {
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = n3 * 2;
        float[] fArray = new float[n5];
        this.warpSparseRect(n, n2, n3, 1, 1, 1, fArray);
        float f2 = fArray[0];
        float f3 = fArray[0];
        float f4 = fArray[1];
        float f5 = fArray[1];
        int n6 = 2;
        while (n6 < n5) {
            f2 = Math.min(f2, fArray[n6]);
            f3 = Math.max(f3, fArray[n6]);
            f4 = Math.min(f4, fArray[n6 + 1]);
            f5 = Math.max(f5, fArray[n6 + 1]);
            n6 += 2;
        }
        this.warpSparseRect(n, n2 + n4 - 1, n3, 1, 1, 1, fArray);
        int n7 = 0;
        while (n7 < n5) {
            f2 = Math.min(f2, fArray[n7]);
            f3 = Math.max(f3, fArray[n7]);
            f4 = Math.min(f4, fArray[n7 + 1]);
            f5 = Math.max(f5, fArray[n7 + 1]);
            n7 += 2;
        }
        n5 = (n4 - 2) * 2;
        fArray = new float[n5];
        this.warpSparseRect(n, n2 + 1, 1, n4 - 2, 1, 1, fArray);
        int n8 = 0;
        while (n8 < n5) {
            f2 = Math.min(f2, fArray[n8]);
            f3 = Math.max(f3, fArray[n8]);
            f4 = Math.min(f4, fArray[n8 + 1]);
            f5 = Math.max(f5, fArray[n8 + 1]);
            n8 += 2;
        }
        this.warpSparseRect(n + n3 - 1, n2 + 1, 1, n4 - 2, 1, 1, fArray);
        int n9 = 0;
        while (n9 < n5) {
            f2 = Math.min(f2, fArray[n9]);
            f3 = Math.max(f3, fArray[n9]);
            f4 = Math.min(f4, fArray[n9 + 1]);
            f5 = Math.max(f5, fArray[n9 + 1]);
            n9 += 2;
        }
        n = (int)Math.floor(f2);
        n2 = (int)Math.floor(f4);
        n3 = (int)Math.ceil(f3 - (float)n) + 1;
        n4 = (int)Math.ceil(f5 - (float)n2) + 1;
        return new Rectangle(n, n2, n3, n4);
    }

    private float[] noWarpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, float[] fArray) {
        int n9 = n3;
        while (n9 <= n4) {
            int n10 = n7;
            n7 += n8;
            int n11 = n;
            while (n11 <= n2) {
                fArray[n10++] = n11;
                fArray[n10++] = n9;
                n11 += n5;
            }
            n9 += n6;
        }
        return fArray;
    }

    public final float[] warpSparseRect(int n, int n2, int n3, int n4, int n5, int n6, float[] fArray) {
        int n7;
        int n8 = 2 * ((n3 + n5 - 1) / n5);
        if (fArray == null) {
            fArray = new float[n8 * ((n4 + n6 - 1) / n6)];
        }
        int n9 = n;
        int n10 = n + n3 - 1;
        int n11 = n2;
        int n12 = n2 + n4 - 1;
        if (n11 >= this.yEnd || n12 < this.yStart || n9 >= this.xEnd || n10 < this.xStart) {
            return this.noWarpSparseRect(n9, n10, n11, n12, n5, n6, 0, n8, fArray);
        }
        if (n11 < this.yStart) {
            n7 = (this.yStart - n11 + n6 - 1) / n6;
            this.noWarpSparseRect(n9, n10, n11, this.yStart - 1, n5, n6, 0, n8, fArray);
            n11 += n7 * n6;
        }
        if (n12 >= this.yEnd) {
            n7 = (this.yEnd - n2 + n6 - 1) / n6;
            this.noWarpSparseRect(n9, n10, n2 + n7 * n6, n12, n5, n6, n7 * n8, n8, fArray);
            n12 = n2 + (n7 - 1) * n6;
        }
        if (n9 < this.xStart) {
            n7 = (this.xStart - n9 + n5 - 1) / n5;
            this.noWarpSparseRect(n9, this.xStart - 1, n11, n12, n5, n6, (n11 - n2) / n6 * n8, n8, fArray);
            n9 += n7 * n5;
        }
        if (n10 >= this.xEnd) {
            n7 = (this.xEnd - n + n5 - 1) / n5;
            this.noWarpSparseRect(n + n7 * n5, n10, n11, n12, n5, n6, (n11 - n2) / n6 * n8 + n7 * 2, n8, fArray);
            n10 = n + (n7 - 1) * n5;
        }
        int[] nArray = new int[this.xNumCells];
        int n13 = n9;
        while (n13 <= n10) {
            int n14 = (n13 - this.xStart) / this.xStep;
            nArray[n14] = nArray[n14] + 1;
            n13 += n5;
        }
        int n15 = (n11 - n2) / n6 * n8 + (n9 - n) / n5 * 2;
        int n16 = this.xNumCells + 1;
        float f2 = (float)n5 / (float)this.xStep;
        int n17 = n11;
        while (n17 <= n12) {
            int n18 = n15;
            n15 += n8;
            int n19 = (n17 - this.yStart) / this.yStep;
            int n20 = this.yStart + n19 * this.yStep;
            float f3 = ((float)n17 + 0.5f - (float)n20) / (float)this.yStep;
            float f4 = (1.0f - f3) * f2;
            float f5 = f3 * f2;
            int n21 = n9;
            while (n21 <= n10) {
                int n22 = (n21 - this.xStart) / this.xStep;
                int n23 = this.xStart + n22 * this.xStep;
                float f6 = ((float)n21 + 0.5f - (float)n23) / (float)this.xStep;
                int n24 = n19 * n16 + n22;
                float f7 = this.xWarpPos[n24];
                float f8 = this.yWarpPos[n24];
                float f9 = this.xWarpPos[++n24];
                float f10 = this.yWarpPos[n24];
                float f11 = this.xWarpPos[n24 += this.xNumCells];
                float f12 = this.yWarpPos[n24];
                float f13 = this.xWarpPos[++n24];
                float f14 = this.yWarpPos[n24];
                float f15 = f7 + (f9 - f7) * f6;
                float f16 = f8 + (f10 - f8) * f6;
                float f17 = f11 + (f13 - f11) * f6;
                float f18 = f12 + (f14 - f12) * f6;
                float f19 = f15 + (f17 - f15) * f3;
                float f20 = f16 + (f18 - f16) * f3;
                float f21 = (f9 - f7) * f4 + (f13 - f11) * f5;
                float f22 = (f10 - f8) * f4 + (f14 - f12) * f5;
                int n25 = nArray[n22];
                int n26 = 0;
                while (n26 < n25) {
                    fArray[n18++] = f19 - 0.5f;
                    fArray[n18++] = f20 - 0.5f;
                    f19 += f21;
                    f20 += f22;
                    n21 += n5;
                    ++n26;
                }
            }
            n17 += n6;
        }
        return fArray;
    }
}

