/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.ImageLayout;
import javax.media.jai.JaiI18N;
import javax.media.jai.OpImage;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterFactory;
import javax.media.jai.TileCache;

public abstract class UntiledOpImage
extends OpImage {
    private Point[] tileDependencies = null;

    public UntiledOpImage(RenderedImage renderedImage, TileCache tileCache, ImageLayout imageLayout) {
        super(renderedImage, null, tileCache, UntiledOpImage.layoutHelper(imageLayout, renderedImage), true);
    }

    protected abstract void computeImage(Raster var1, WritableRaster var2, Rectangle var3);

    public final Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.getTileRect(n, n2);
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        PlanarImage planarImage = this.getSource(0);
        Rectangle rectangle3 = this.mapDestRect(rectangle2, 0);
        Raster raster = planarImage.getData(rectangle3);
        this.computeImage(raster, writableRaster, rectangle2);
        return writableRaster;
    }

    public final synchronized Point[] getTileDependencies(int n, int n2, int n3) {
        if (this.tileDependencies == null) {
            int n4 = this.source0.getMinTileX();
            int n5 = this.source0.getMinTileY();
            int n6 = n4 + this.source0.getNumXTiles() - 1;
            int n7 = n5 + this.source0.getNumYTiles() - 1;
            this.tileDependencies = new Point[(n6 - n4 + 1) * (n7 - n5 + 1)];
            int n8 = 0;
            int n9 = n5;
            while (n9 <= n7) {
                int n10 = n4;
                while (n10 <= n6) {
                    this.tileDependencies[n8++] = new Point(n10, n9);
                    ++n10;
                }
                ++n9;
            }
        }
        return this.tileDependencies;
    }

    private static ImageLayout layoutHelper(ImageLayout imageLayout, RenderedImage renderedImage) {
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout(renderedImage) : (ImageLayout)imageLayout.clone();
        imageLayout2.setTileGridXOffset(imageLayout2.getMinX(renderedImage));
        imageLayout2.setTileGridYOffset(imageLayout2.getMinY(renderedImage));
        imageLayout2.setTileWidth(imageLayout2.getWidth(renderedImage));
        imageLayout2.setTileHeight(imageLayout2.getHeight(renderedImage));
        return imageLayout2;
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("GenericMapXXXRect"));
        }
        return this.source0.getBounds();
    }

    public final Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("GenericMapXXXRect"));
        }
        return this.getBounds();
    }
}

