/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import com.sun.media.jai.util.Rational;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.IntegerSequence;
import javax.media.jai.Interpolation;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JaiI18N;
import javax.media.jai.TileCache;
import javax.media.jai.WarpOpImage;

public abstract class ScaleOpImage
extends WarpOpImage {
    protected float scaleX;
    protected float scaleY;
    protected float transX;
    protected float transY;
    protected float invScaleX;
    protected float invScaleY;
    protected BorderExtender extender;
    protected Rational scaleXRational;
    protected Rational scaleYRational;
    protected long scaleXRationalNum;
    protected long scaleXRationalDenom;
    protected long scaleYRationalNum;
    protected long scaleYRationalDenom;
    protected Rational invScaleXRational;
    protected Rational invScaleYRational;
    protected long invScaleXRationalNum;
    protected long invScaleXRationalDenom;
    protected long invScaleYRationalNum;
    protected long invScaleYRationalDenom;
    protected Rational transXRational;
    protected Rational transYRational;
    protected long transXRationalNum;
    protected long transXRationalDenom;
    protected long transYRationalNum;
    protected long transYRationalDenom;
    protected static float rationalTolerance = 1.0E-6f;
    private int lpad;
    private int rpad;
    private int tpad;
    private int bpad;

    public ScaleOpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, float f2, float f3, float f4, float f5, Interpolation interpolation, boolean bl) {
        super(renderedImage, borderExtender, tileCache, ScaleOpImage.layoutHelper(renderedImage, f2, f3, f4, f5, imageLayout), null, interpolation, bl);
        this.scaleX = f2;
        this.scaleY = f3;
        this.transX = f4;
        this.transY = f5;
        this.scaleXRational = Rational.approximate(f2, rationalTolerance);
        this.scaleYRational = Rational.approximate(f3, rationalTolerance);
        this.scaleXRationalNum = this.scaleXRational.num;
        this.scaleXRationalDenom = this.scaleXRational.denom;
        this.scaleYRationalNum = this.scaleYRational.num;
        this.scaleYRationalDenom = this.scaleYRational.denom;
        this.transXRational = Rational.approximate(f4, rationalTolerance);
        this.transYRational = Rational.approximate(f5, rationalTolerance);
        this.transXRationalNum = this.transXRational.num;
        this.transXRationalDenom = this.transXRational.denom;
        this.transYRationalNum = this.transYRational.num;
        this.transYRationalDenom = this.transYRational.denom;
        this.invScaleXRational = new Rational(this.scaleXRational);
        this.invScaleXRational.invert();
        this.invScaleYRational = new Rational(this.scaleYRational);
        this.invScaleYRational.invert();
        this.invScaleXRationalNum = this.invScaleXRational.num;
        this.invScaleXRationalDenom = this.invScaleXRational.denom;
        this.invScaleYRationalNum = this.invScaleYRational.num;
        this.invScaleYRationalDenom = this.invScaleYRational.denom;
        this.extender = borderExtender;
        this.lpad = interpolation.getLeftPadding();
        this.rpad = interpolation.getRightPadding();
        this.tpad = interpolation.getTopPadding();
        this.bpad = interpolation.getBottomPadding();
        if (borderExtender == null) {
            int n = renderedImage.getMinX();
            int n2 = renderedImage.getMinY();
            int n3 = renderedImage.getWidth();
            int n4 = renderedImage.getHeight();
            long l2 = n;
            long l3 = 1L;
            long l4 = n2;
            long l5 = 1L;
            long l6 = n3;
            long l7 = 1L;
            long l8 = n4;
            long l9 = 1L;
            if (!(interpolation instanceof InterpolationNearest)) {
                l2 = l2 * 2L + l3;
                l3 *= 2L;
                l4 = l4 * 2L + l5;
                l5 *= 2L;
                --l6;
                --l8;
            }
            l2 += l3 * (long)this.lpad;
            l4 += l5 * (long)this.tpad;
            l6 -= l7 * (long)(this.lpad + this.rpad);
            l8 -= l9 * (long)(this.tpad + this.bpad);
            l2 *= this.scaleXRationalNum;
            l2 = l2 * this.transXRationalDenom + this.transXRationalNum * (l3 *= this.scaleXRationalDenom);
            l4 *= this.scaleYRationalNum;
            l4 = l4 * this.transYRationalDenom + this.transYRationalNum * (l5 *= this.scaleYRationalDenom);
            long l10 = l2 * (l7 *= this.scaleXRationalDenom) + (l6 *= this.scaleXRationalNum) * (l3 *= this.transXRationalDenom) - l3 * l7;
            long l11 = l3 * l7;
            long l12 = l4 * (l9 *= this.scaleYRationalDenom) + (l8 *= this.scaleYRationalNum) * (l5 *= this.transYRationalDenom) - l5 * l9;
            long l13 = l5 * l9;
            int n5 = Rational.ceil(l2, l3);
            int n6 = Rational.ceil(l4, l5);
            int n7 = Rational.floor(l10, l11);
            int n8 = Rational.floor(l12, l13);
            this.writableBounds = new Rectangle(n5, n6, n7 - n5 + 1, n8 - n6 + 1);
        } else {
            this.writableBounds = this.getBounds();
        }
    }

    public final Raster computeTile(int n, int n2) {
        if (!this.cobbleSources) {
            return super.computeTile(n, n2);
        }
        int n3 = this.tileXToX(n);
        int n4 = this.tileYToY(n2);
        WritableRaster writableRaster = Raster.createWritableRaster(this.sampleModel, new Point(n3, n4));
        Rectangle rectangle = new Rectangle(n3, n4, this.tileWidth, this.tileHeight);
        Rectangle rectangle2 = rectangle.intersection(this.writableBounds);
        if (rectangle2.width <= 0 || rectangle2.height <= 0) {
            return writableRaster;
        }
        Rectangle rectangle3 = this.mapDestRect(rectangle2, 0);
        Raster[] rasterArray = new Raster[1];
        IntegerSequence integerSequence = new IntegerSequence();
        IntegerSequence integerSequence2 = new IntegerSequence();
        this.source0.getSplits(integerSequence, integerSequence2, rectangle3);
        if (integerSequence.getNumElements() == 1 && integerSequence2.getNumElements() == 1) {
            rasterArray[0] = this.extender == null ? this.source0.getData(rectangle3) : this.source0.getExtendedData(rectangle3, this.extender);
            this.computeRect(rasterArray, writableRaster, rectangle2);
        } else {
            int n5 = this.source0.getTileWidth();
            int n6 = this.source0.getTileHeight();
            integerSequence2.startEnumeration();
            while (integerSequence2.hasMoreElements()) {
                int n7 = integerSequence2.nextElement();
                integerSequence.startEnumeration();
                while (integerSequence.hasMoreElements()) {
                    Rectangle rectangle4;
                    Rectangle rectangle5;
                    int n8 = integerSequence.nextElement();
                    Rectangle rectangle6 = new Rectangle(n8, n7, n5, n6);
                    Rectangle rectangle7 = rectangle3.intersection(rectangle6);
                    if (!(this.interp instanceof InterpolationNearest)) {
                        if (rectangle7.width <= this.interp.getWidth()) {
                            rectangle5 = new Rectangle();
                            rectangle5.x = rectangle7.x;
                            rectangle5.y = rectangle7.y - this.tpad - 1;
                            rectangle5.width = 2 * (this.lpad + this.rpad + 1);
                            rectangle5.height = rectangle7.height + this.bpad + this.tpad + 2;
                            rectangle5 = rectangle5.intersection(this.source0.getBounds());
                            rectangle4 = this.mapSourceRect(rectangle5, 0);
                            rectangle4 = rectangle4.intersection(rectangle2);
                            if (rectangle4.width > 0 && rectangle4.height > 0) {
                                rasterArray[0] = this.extender == null ? this.source0.getData(rectangle5) : this.source0.getExtendedData(rectangle5, this.extender);
                                this.computeRect(rasterArray, writableRaster, rectangle4);
                            }
                        }
                        if (rectangle7.height <= this.interp.getHeight()) {
                            rectangle5 = new Rectangle();
                            rectangle5.x = rectangle7.x - this.lpad - 1;
                            rectangle5.y = rectangle7.y;
                            rectangle5.width = rectangle7.width + this.lpad + this.rpad + 2;
                            rectangle5.height = 2 * (this.tpad + this.bpad + 1);
                            rectangle5 = rectangle5.intersection(this.source0.getBounds());
                            rectangle4 = this.mapSourceRect(rectangle5, 0);
                            rectangle4 = rectangle4.intersection(rectangle2);
                            if (rectangle4.width > 0 && rectangle4.height > 0) {
                                rasterArray[0] = this.extender == null ? this.source0.getData(rectangle5) : this.source0.getExtendedData(rectangle5, this.extender);
                                this.computeRect(rasterArray, writableRaster, rectangle4);
                            }
                        }
                    }
                    if (rectangle7.width <= 0 || rectangle7.height <= 0) continue;
                    rectangle5 = this.mapSourceRect(rectangle7, 0);
                    rectangle5 = rectangle5.intersection(rectangle2);
                    if (rectangle5.width > 0 && rectangle5.height > 0) {
                        rasterArray[0] = this.extender == null ? this.source0.getData(rectangle7) : this.source0.getExtendedData(rectangle7, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle5);
                    }
                    if (this.interp instanceof InterpolationNearest) continue;
                    rectangle4 = new Rectangle();
                    rectangle4.x = rectangle7.x + rectangle7.width - 1 - this.rpad - this.lpad;
                    rectangle4.y = rectangle7.y;
                    rectangle4.width = 2 * (this.lpad + this.rpad + 1);
                    rectangle4.height = rectangle7.height;
                    Rectangle rectangle8 = this.mapSourceRect(rectangle4, 0);
                    rectangle8 = rectangle8.intersection(rectangle2);
                    if (rectangle8.width > 0 && rectangle8.height > 0) {
                        rasterArray[0] = this.extender == null ? this.source0.getData(rectangle4) : this.source0.getExtendedData(rectangle4, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle8);
                    }
                    Rectangle rectangle9 = new Rectangle();
                    rectangle9.x = rectangle7.x;
                    rectangle9.y = rectangle7.y + rectangle7.height - 1 - this.bpad - this.tpad;
                    rectangle9.width = rectangle7.width;
                    rectangle9.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle rectangle10 = this.mapSourceRect(rectangle9, 0);
                    rectangle10 = rectangle10.intersection(rectangle2);
                    if (rectangle10.width > 0 && rectangle10.height > 0) {
                        rasterArray[0] = this.extender == null ? this.source0.getData(rectangle9) : this.source0.getExtendedData(rectangle9, this.extender);
                        this.computeRect(rasterArray, writableRaster, rectangle10);
                    }
                    Rectangle rectangle11 = new Rectangle();
                    rectangle11.x = rectangle7.x + rectangle7.width - 1 - this.rpad - this.lpad;
                    rectangle11.y = rectangle7.y + rectangle7.height - 1 - this.bpad - this.tpad;
                    rectangle11.width = 2 * (this.rpad + this.lpad + 1);
                    rectangle11.height = 2 * (this.tpad + this.bpad + 1);
                    Rectangle rectangle12 = this.mapSourceRect(rectangle11, 0);
                    rectangle12 = rectangle12.intersection(rectangle2);
                    if (rectangle12.width <= 0 || rectangle12.height <= 0) continue;
                    rasterArray[0] = this.extender == null ? this.source0.getData(rectangle11) : this.source0.getExtendedData(rectangle11, this.extender);
                    this.computeRect(rasterArray, writableRaster, rectangle12);
                }
            }
        }
        return writableRaster;
    }

    private static ImageLayout layoutHelper(RenderedImage renderedImage, float f2, float f3, float f4, float f5, ImageLayout imageLayout) {
        Rational rational = Rational.approximate(f2, rationalTolerance);
        Rational rational2 = Rational.approximate(f3, rationalTolerance);
        long l2 = rational.num;
        long l3 = rational.denom;
        long l4 = rational2.num;
        long l5 = rational2.denom;
        Rational rational3 = Rational.approximate(f4, rationalTolerance);
        Rational rational4 = Rational.approximate(f5, rationalTolerance);
        long l6 = rational3.num;
        long l7 = rational3.denom;
        long l8 = rational4.num;
        long l9 = rational4.denom;
        ImageLayout imageLayout2 = imageLayout == null ? new ImageLayout() : (ImageLayout)imageLayout.clone();
        int n = renderedImage.getMinX();
        int n2 = renderedImage.getMinY();
        int n3 = renderedImage.getWidth();
        int n4 = renderedImage.getHeight();
        long l10 = (long)n * l2;
        long l11 = l3;
        long l12 = (long)n2 * l4;
        long l13 = l5;
        long l14 = (long)n3 * l2;
        long l15 = l3;
        long l16 = (long)n4 * l4;
        long l17 = l5;
        l10 = l10 * l7 + l6 * l11;
        l12 = l12 * l9 + l8 * l13;
        l13 *= l9;
        long l18 = Math.abs(l10 % (l11 *= l7));
        long l19 = (l11 + 1L) / 2L;
        int n5 = (int)(l10 / l11);
        if (l18 >= l19) {
            n5 = l10 > 0L ? ++n5 : --n5;
        }
        l18 = Math.abs(l12 % l13);
        l19 = (l13 + 1L) / 2L;
        int n6 = (int)(l12 / l13);
        if (l18 >= l19) {
            n6 = l12 > 0L ? ++n6 : --n6;
        }
        imageLayout2.setMinX(n5);
        imageLayout2.setMinY(n6);
        imageLayout2.setWidth((int)(l14 / l15));
        imageLayout2.setHeight((int)(l16 / l17));
        return imageLayout2;
    }

    public final Rectangle mapDestRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("ScaleOpImage0"));
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        long l2 = n2;
        long l3 = 1L;
        long l4 = n3;
        long l5 = 1L;
        long l6 = n4;
        long l7 = 1L;
        long l8 = n5;
        long l9 = 1L;
        long l10 = l2 * l7 + l6 * l3;
        long l11 = l3 * l7;
        long l12 = l4 * l9 + l8 * l5;
        long l13 = l5 * l9;
        l2 = l2 * this.transXRationalDenom - this.transXRationalNum * l3;
        l3 *= this.transXRationalDenom;
        l4 = l4 * this.transYRationalDenom - this.transYRationalNum * l5;
        l5 *= this.transYRationalDenom;
        l10 = l10 * this.transXRationalDenom - this.transXRationalNum * l11;
        l11 *= this.transXRationalDenom;
        l12 = l12 * this.transYRationalDenom - this.transYRationalNum * l13;
        l13 *= this.transYRationalDenom;
        l2 *= this.invScaleXRationalNum;
        l3 *= this.invScaleXRationalDenom;
        l4 *= this.invScaleYRationalNum;
        l5 *= this.invScaleYRationalDenom;
        l6 *= this.invScaleXRationalNum;
        l7 *= this.invScaleXRationalDenom;
        l8 *= this.invScaleYRationalNum;
        l9 *= this.invScaleYRationalDenom;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        if (this.interp instanceof InterpolationNearest) {
            n6 = Rational.floor(l2, l3);
            n7 = Rational.floor(l4, l5);
            n8 = Rational.ceil(l10 *= this.invScaleXRationalNum, l11 *= this.invScaleXRationalDenom);
            n9 = Rational.ceil(l12 *= this.invScaleYRationalNum, l13 *= this.invScaleYRationalDenom);
        } else {
            l2 = l2 * 2L - l3;
            n6 = Rational.floor(l2, l3 *= 2L);
            l4 = l4 * 2L - l5;
            n7 = Rational.floor(l4, l5 *= 2L);
            l10 = l2 * l7 + l6 * l3;
            l11 = l3 * l7;
            l12 = l4 * l9 + l8 * l5;
            l13 = l5 * l9;
            n8 = Rational.ceil(l10, l11);
            n9 = Rational.ceil(l12, l13);
            n6 -= this.lpad;
            n7 -= this.tpad;
            n8 += this.rpad;
            n9 += this.bpad;
        }
        return new Rectangle(n6, n7, n8 - n6, n9 - n7);
    }

    public final Rectangle mapSourceRect(Rectangle rectangle, int n) {
        if (n < 0 || n >= this.getNumSources()) {
            throw new IllegalArgumentException(JaiI18N.getString("ScaleOpImage0"));
        }
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        long l2 = n2;
        long l3 = 1L;
        long l4 = n3;
        long l5 = 1L;
        long l6 = n4;
        long l7 = 1L;
        long l8 = n5;
        long l9 = 1L;
        if (!(this.interp instanceof InterpolationNearest)) {
            l2 = l2 * 2L + l3;
            l3 *= 2L;
            l4 = l4 * 2L + l5;
            l5 *= 2L;
            --l6;
            --l8;
        }
        long l10 = (l2 += l3 * (long)this.lpad) * l7 + (l6 -= l7 * (long)(this.lpad + this.rpad)) * l3;
        long l11 = l3 * l7;
        long l12 = (l4 += l5 * (long)this.tpad) * l9 + (l8 -= l9 * (long)(this.tpad + this.bpad)) * l5;
        long l13 = l5 * l9;
        l2 *= this.scaleXRationalNum;
        l2 = l2 * this.transXRationalDenom + this.transXRationalNum * (l3 *= this.scaleXRationalDenom);
        l2 = 2L * l2 - (l3 *= this.transXRationalDenom);
        l3 *= 2L;
        l4 *= this.scaleYRationalNum;
        l4 = l4 * this.transYRationalDenom + this.transYRationalNum * (l5 *= this.scaleYRationalDenom);
        l4 = 2L * l4 - (l5 *= this.transYRationalDenom);
        l5 *= 2L;
        l10 *= this.scaleXRationalNum;
        l10 = l10 * this.transXRationalDenom + this.transXRationalNum * (l11 *= this.scaleXRationalDenom);
        l10 = 2L * l10 - (l11 *= this.transXRationalDenom);
        l11 *= 2L;
        l12 *= this.scaleYRationalNum;
        l12 = l12 * this.transYRationalDenom + this.transYRationalNum * (l13 *= this.scaleYRationalDenom);
        l12 = 2L * l12 - (l13 *= this.transYRationalDenom);
        int n6 = Rational.ceil(l2, l3);
        int n7 = Rational.ceil(l4, l5);
        int n8 = Rational.floor(l10, l11);
        int n9 = Rational.floor(l12, l13 *= 2L);
        if (this.interp instanceof InterpolationNearest) {
            if (l10 % l11 == 0L) {
                --n8;
            }
            if (l12 % l13 == 0L) {
                --n9;
            }
        }
        return new Rectangle(n6, n7, n8 - n6 + 1, n9 - n7 + 1);
    }
}

