/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.lang.reflect.Method;
import java.text.AttributedCharacterIterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Vector;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.TiledImage;

public class RenderableGraphics
extends Graphics2D
implements RenderableImage {
    private static final Class GRAPHICS2D_CLASS = class$java$awt$Graphics2D != null ? class$java$awt$Graphics2D : (class$java$awt$Graphics2D = RenderableGraphics.class$("java.awt.Graphics2D"));
    private Rectangle2D dimensions;
    private LinkedList opArgList;
    private Point origin;
    private Shape clip;
    private Color color;
    private Font font;
    private Color background;
    private Composite composite;
    private Paint paint;
    private Stroke stroke;
    private RenderingHints renderingHints = new RenderingHints(null);
    private AffineTransform transform;
    static Class class$java$awt$Graphics2D;
    static Class class$java$awt$Color;
    static Class class$java$awt$Font;
    static Class class$java$awt$Shape;
    static Class class$java$lang$String;
    static Class class$java$awt$Image;
    static Class class$java$awt$image$ImageObserver;
    static Class class$java$util$Map;
    static Class class$java$awt$geom$AffineTransform;
    static Class class$java$awt$image$RenderedImage;
    static Class class$java$awt$image$renderable$RenderableImage;
    static Class class$java$awt$image$BufferedImage;
    static Class class$java$awt$image$BufferedImageOp;
    static Class class$java$text$AttributedCharacterIterator;
    static Class class$java$awt$font$GlyphVector;
    static Class class$java$awt$Composite;
    static Class class$java$awt$Paint;
    static Class class$java$awt$Stroke;
    static Class class$java$awt$RenderingHints$Key;
    static Class class$java$lang$Object;

    public RenderableGraphics(Rectangle2D rectangle2D) {
        this(rectangle2D, new LinkedList(), new Point(0, 0), null);
    }

    private RenderableGraphics(Rectangle2D rectangle2D, LinkedList linkedList, Point point, Graphics2D graphics2D) {
        if (rectangle2D.isEmpty()) {
            throw new RuntimeException(JaiI18N.getString("RenderableGraphics0"));
        }
        this.dimensions = rectangle2D;
        this.opArgList = linkedList;
        Graphics2D graphics2D2 = graphics2D;
        if (graphics2D2 == null) {
            graphics2D2 = this.getBogusGraphics2D();
        }
        this.origin = (Point)point.clone();
        this.setClip(graphics2D2.getClip());
        this.setColor(graphics2D2.getColor());
        this.setFont(graphics2D2.getFont());
        this.setBackground(graphics2D2.getBackground());
        this.setComposite(graphics2D2.getComposite());
        this.setRenderingHints((Map)graphics2D2.getRenderingHints());
        this.setStroke(graphics2D2.getStroke());
        this.setTransform(graphics2D2.getTransform());
        if (graphics2D == null) {
            graphics2D2.dispose();
        }
    }

    public final void addRenderingHints(Map map) {
        this.renderingHints.putAll((Map<?, ?>)map);
        this.queueOpArg("addRenderingHints", new Class[]{class$java$util$Map != null ? class$java$util$Map : (class$java$util$Map = RenderableGraphics.class$("java.util.Map"))}, new Object[]{map});
    }

    private static final Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public final void clearRect(int n, int n2, int n3, int n4) {
        this.queueOpArg("clearRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public final void clip(Shape shape) {
        if (this.clip == null) {
            this.clip = shape;
        } else {
            Area area = this.clip instanceof Area ? (Area)this.clip : new Area(this.clip);
            area.intersect(shape instanceof Area ? (Area)shape : new Area(shape));
            this.clip = area;
        }
        this.queueOpArg("clip", new Class[]{class$java$awt$Shape != null ? class$java$awt$Shape : (class$java$awt$Shape = RenderableGraphics.class$("java.awt.Shape"))}, new Object[]{shape});
    }

    public final void clipRect(int n, int n2, int n3, int n4) {
        this.clip(new Rectangle(n, n2, n3, n4));
    }

    public final void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.queueOpArg("copyArea", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public final Graphics create() {
        return new RenderableGraphics(this.dimensions, this.opArgList, this.origin, this);
    }

    public final RenderedImage createDefaultRendering() {
        return this.createRendering(new RenderContext(new AffineTransform()));
    }

    public final RenderedImage createRendering(RenderContext renderContext) {
        AffineTransform affineTransform = renderContext.getTransform();
        if (affineTransform == null) {
            affineTransform = new AffineTransform();
        }
        RenderingHints renderingHints = renderContext.getRenderingHints();
        Shape shape = renderContext.getAreaOfInterest();
        if (shape == null) {
            shape = this.dimensions.getBounds();
        }
        Shape shape2 = affineTransform.createTransformedShape(shape);
        TiledImage tiledImage = this.createTiledImage(renderingHints, shape2.getBounds());
        Graphics2D graphics2D = tiledImage.createGraphics();
        if (!affineTransform.isIdentity()) {
            AffineTransform affineTransform2 = this.getTransform();
            affineTransform2.concatenate(affineTransform);
            graphics2D.setTransform(affineTransform2);
        }
        if (renderingHints != null) {
            graphics2D.addRenderingHints(renderingHints);
        }
        graphics2D.setClip(shape);
        this.evaluateOpList(graphics2D);
        graphics2D.dispose();
        return tiledImage;
    }

    public final RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        if (n <= 0 && n2 <= 0) {
            throw new IllegalArgumentException(JaiI18N.getString("RenderableGraphics1"));
        }
        if (n <= 0) {
            n = (int)Math.round((double)n2 * this.dimensions.getWidth() / this.dimensions.getHeight());
        } else if (n2 <= 0) {
            n2 = (int)Math.round((double)n * this.dimensions.getHeight() / this.dimensions.getWidth());
        }
        double d2 = (double)n / this.dimensions.getWidth();
        double d3 = (double)n2 / this.dimensions.getHeight();
        AffineTransform affineTransform = new AffineTransform();
        affineTransform.setToScale(d2, d3);
        return this.createRendering(new RenderContext(affineTransform, renderingHints));
    }

    private TiledImage createTiledImage(RenderingHints renderingHints, Rectangle rectangle) {
        Object object;
        int n = rectangle.width;
        int n2 = rectangle.height;
        SampleModel sampleModel = null;
        ColorModel colorModel = null;
        RenderingHints renderingHints2 = null;
        if (renderingHints != null && (object = (ImageLayout)renderingHints.get(JAI.KEY_IMAGE_LAYOUT)) != null) {
            renderingHints2 = new RenderingHints(null);
            ImageLayout imageLayout = new ImageLayout();
            if (((ImageLayout)object).isValid(256)) {
                sampleModel = ((ImageLayout)object).getSampleModel(null);
                if (sampleModel.getWidth() != n || sampleModel.getHeight() != n2) {
                    sampleModel = sampleModel.createCompatibleSampleModel(n, n2);
                }
                if (imageLayout != null) {
                    imageLayout.setSampleModel(sampleModel);
                }
            }
            if (((ImageLayout)object).isValid(512)) {
                colorModel = ((ImageLayout)object).getColorModel(null);
                if (imageLayout != null) {
                    imageLayout.setColorModel(colorModel);
                }
            }
            if (((ImageLayout)object).isValid(64)) {
                n = ((ImageLayout)object).getTileWidth(null);
                if (imageLayout != null) {
                    imageLayout.setTileWidth(n);
                }
            } else if (sampleModel != null) {
                n = sampleModel.getWidth();
            }
            if (((ImageLayout)object).isValid(128)) {
                n2 = ((ImageLayout)object).getTileHeight(null);
                if (imageLayout != null) {
                    imageLayout.setTileHeight(n2);
                }
            } else if (sampleModel != null) {
                n2 = sampleModel.getHeight();
            }
            renderingHints2.put(JAI.KEY_IMAGE_LAYOUT, imageLayout);
        }
        if (sampleModel != null && (sampleModel.getWidth() != n || sampleModel.getHeight() != n2)) {
            sampleModel = sampleModel.createCompatibleSampleModel(n, n2);
        }
        if (!(colorModel == null || sampleModel != null && colorModel.isCompatibleSampleModel(sampleModel))) {
            sampleModel = colorModel.createCompatibleSampleModel(n, n2);
        } else if (colorModel == null && sampleModel != null && (colorModel = PlanarImage.createColorModel(sampleModel)) == null && ColorModel.getRGBdefault().isCompatibleSampleModel(sampleModel)) {
            colorModel = ColorModel.getRGBdefault();
        }
        object = null;
        if (sampleModel != null) {
            object = new TiledImage(rectangle.x, rectangle.y, rectangle.width, rectangle.height, rectangle.x, rectangle.y, sampleModel, colorModel);
        } else {
            int[] nArray = new int[3];
            nArray[1] = 1;
            nArray[2] = 2;
            object = TiledImage.createInterleaved(rectangle.x, rectangle.y, rectangle.width, rectangle.height, 3, 0, n, n2, nArray);
        }
        if (renderingHints2 != null) {
            ((PlanarImage)object).setProperty("HINTS_OBSERVED", renderingHints2);
        }
        return object;
    }

    public final void dispose() {
        this.queueOpArg("dispose", null, null);
    }

    public final void draw(Shape shape) {
        this.queueOpArg("draw", new Class[]{class$java$awt$Shape != null ? class$java$awt$Shape : (class$java$awt$Shape = RenderableGraphics.class$("java.awt.Shape"))}, new Object[]{shape});
    }

    public final void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.queueOpArg("draw3DRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Boolean(bl)});
    }

    public final void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.queueOpArg("drawArc", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public final void drawGlyphVector(GlyphVector glyphVector, float f2, float f3) {
        this.queueOpArg("drawGlyphVector", new Class[]{class$java$awt$font$GlyphVector != null ? class$java$awt$font$GlyphVector : (class$java$awt$font$GlyphVector = RenderableGraphics.class$("java.awt.font.GlyphVector")), Float.TYPE, Float.TYPE}, new Object[]{glyphVector, new Float(f2), new Float(f3)});
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        this.queueOpArg("drawImage", new Class[]{class$java$awt$Image != null ? class$java$awt$Image : (class$java$awt$Image = RenderableGraphics.class$("java.awt.Image")), Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = RenderableGraphics.class$("java.awt.Color")), class$java$awt$image$ImageObserver != null ? class$java$awt$image$ImageObserver : (class$java$awt$image$ImageObserver = RenderableGraphics.class$("java.awt.image.ImageObserver"))}, new Object[]{image, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), color, imageObserver});
        return true;
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        this.queueOpArg("drawImage", new Class[]{class$java$awt$Image != null ? class$java$awt$Image : (class$java$awt$Image = RenderableGraphics.class$("java.awt.Image")), Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$awt$image$ImageObserver != null ? class$java$awt$image$ImageObserver : (class$java$awt$image$ImageObserver = RenderableGraphics.class$("java.awt.image.ImageObserver"))}, new Object[]{image, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6), new Integer(n7), new Integer(n8), imageObserver});
        return true;
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        this.queueOpArg("drawImage", new Class[]{class$java$awt$Image != null ? class$java$awt$Image : (class$java$awt$Image = RenderableGraphics.class$("java.awt.Image")), Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = RenderableGraphics.class$("java.awt.Color")), class$java$awt$image$ImageObserver != null ? class$java$awt$image$ImageObserver : (class$java$awt$image$ImageObserver = RenderableGraphics.class$("java.awt.image.ImageObserver"))}, new Object[]{image, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), color, imageObserver});
        return true;
    }

    public final boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        this.queueOpArg("drawImage", new Class[]{class$java$awt$Image != null ? class$java$awt$Image : (class$java$awt$Image = RenderableGraphics.class$("java.awt.Image")), Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, class$java$awt$image$ImageObserver != null ? class$java$awt$image$ImageObserver : (class$java$awt$image$ImageObserver = RenderableGraphics.class$("java.awt.image.ImageObserver"))}, new Object[]{image, new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), imageObserver});
        return true;
    }

    public final boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        this.queueOpArg("drawImage", new Class[]{class$java$awt$Image != null ? class$java$awt$Image : (class$java$awt$Image = RenderableGraphics.class$("java.awt.Image")), Integer.TYPE, Integer.TYPE, class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = RenderableGraphics.class$("java.awt.Color")), class$java$awt$image$ImageObserver != null ? class$java$awt$image$ImageObserver : (class$java$awt$image$ImageObserver = RenderableGraphics.class$("java.awt.image.ImageObserver"))}, new Object[]{image, new Integer(n), new Integer(n2), color, imageObserver});
        return true;
    }

    public final boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        this.queueOpArg("drawImage", new Class[]{class$java$awt$Image != null ? class$java$awt$Image : (class$java$awt$Image = RenderableGraphics.class$("java.awt.Image")), Integer.TYPE, Integer.TYPE, class$java$awt$image$ImageObserver != null ? class$java$awt$image$ImageObserver : (class$java$awt$image$ImageObserver = RenderableGraphics.class$("java.awt.image.ImageObserver"))}, new Object[]{image, new Integer(n), new Integer(n2), imageObserver});
        return true;
    }

    public final boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        this.queueOpArg("drawImage", new Class[]{class$java$awt$Image != null ? class$java$awt$Image : (class$java$awt$Image = RenderableGraphics.class$("java.awt.Image")), class$java$awt$geom$AffineTransform != null ? class$java$awt$geom$AffineTransform : (class$java$awt$geom$AffineTransform = RenderableGraphics.class$("java.awt.geom.AffineTransform")), class$java$awt$image$ImageObserver != null ? class$java$awt$image$ImageObserver : (class$java$awt$image$ImageObserver = RenderableGraphics.class$("java.awt.image.ImageObserver"))}, new Object[]{image, affineTransform, imageObserver});
        return true;
    }

    public final void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.queueOpArg("drawImage", new Class[]{class$java$awt$image$BufferedImage != null ? class$java$awt$image$BufferedImage : (class$java$awt$image$BufferedImage = RenderableGraphics.class$("java.awt.image.BufferedImage")), class$java$awt$image$BufferedImageOp != null ? class$java$awt$image$BufferedImageOp : (class$java$awt$image$BufferedImageOp = RenderableGraphics.class$("java.awt.image.BufferedImageOp")), Integer.TYPE, Integer.TYPE}, new Object[]{bufferedImage, bufferedImageOp, new Integer(n), new Integer(n2)});
    }

    public final void drawLine(int n, int n2, int n3, int n4) {
        this.queueOpArg("drawLine", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public final void drawOval(int n, int n2, int n3, int n4) {
        this.queueOpArg("drawOval", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public final void drawPolygon(int[] nArray, int[] nArray2, int n) {
        Class<?> clazz = nArray.getClass();
        this.queueOpArg("drawPolygon", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n)});
    }

    public final void drawPolyline(int[] nArray, int[] nArray2, int n) {
        Class<?> clazz = nArray.getClass();
        this.queueOpArg("drawPolyline", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n)});
    }

    public final void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.queueOpArg("drawRenderableImage", new Class[]{class$java$awt$image$renderable$RenderableImage != null ? class$java$awt$image$renderable$RenderableImage : (class$java$awt$image$renderable$RenderableImage = RenderableGraphics.class$("java.awt.image.renderable.RenderableImage")), class$java$awt$geom$AffineTransform != null ? class$java$awt$geom$AffineTransform : (class$java$awt$geom$AffineTransform = RenderableGraphics.class$("java.awt.geom.AffineTransform"))}, new Object[]{renderableImage, affineTransform});
    }

    public final void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.queueOpArg("drawRenderedImage", new Class[]{class$java$awt$image$RenderedImage != null ? class$java$awt$image$RenderedImage : (class$java$awt$image$RenderedImage = RenderableGraphics.class$("java.awt.image.RenderedImage")), class$java$awt$geom$AffineTransform != null ? class$java$awt$geom$AffineTransform : (class$java$awt$geom$AffineTransform = RenderableGraphics.class$("java.awt.geom.AffineTransform"))}, new Object[]{renderedImage, affineTransform});
    }

    public final void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.queueOpArg("drawRoundRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public final void drawString(String string, float f2, float f3) {
        this.queueOpArg("drawString", new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RenderableGraphics.class$("java.lang.String")), Float.TYPE, Float.TYPE}, new Object[]{string, new Float(f2), new Float(f3)});
    }

    public final void drawString(String string, int n, int n2) {
        this.queueOpArg("drawString", new Class[]{class$java$lang$String != null ? class$java$lang$String : (class$java$lang$String = RenderableGraphics.class$("java.lang.String")), Integer.TYPE, Integer.TYPE}, new Object[]{string, new Integer(n), new Integer(n2)});
    }

    public final void drawString(AttributedCharacterIterator attributedCharacterIterator, float f2, float f3) {
        this.queueOpArg("drawString", new Class[]{class$java$text$AttributedCharacterIterator != null ? class$java$text$AttributedCharacterIterator : (class$java$text$AttributedCharacterIterator = RenderableGraphics.class$("java.text.AttributedCharacterIterator")), Float.TYPE, Float.TYPE}, new Object[]{attributedCharacterIterator, new Float(f2), new Float(f3)});
    }

    public final void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.queueOpArg("drawString", new Class[]{class$java$text$AttributedCharacterIterator != null ? class$java$text$AttributedCharacterIterator : (class$java$text$AttributedCharacterIterator = RenderableGraphics.class$("java.text.AttributedCharacterIterator")), Integer.TYPE, Integer.TYPE}, new Object[]{attributedCharacterIterator, new Integer(n), new Integer(n2)});
    }

    private void evaluateOpList(Graphics2D graphics2D) {
        if (this.opArgList == null) {
            return;
        }
        ListIterator listIterator = this.opArgList.listIterator(0);
        while (listIterator.hasNext()) {
            Method method = (Method)listIterator.next();
            Object[] objectArray = (Object[])listIterator.next();
            try {
                method.invoke((Object)graphics2D, objectArray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                throw new RuntimeException(exception.getMessage());
            }
        }
    }

    public final void fill(Shape shape) {
        this.queueOpArg("fill", new Class[]{class$java$awt$Shape != null ? class$java$awt$Shape : (class$java$awt$Shape = RenderableGraphics.class$("java.awt.Shape"))}, new Object[]{shape});
    }

    public final void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.queueOpArg("fill3DRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Boolean(bl)});
    }

    public final void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.queueOpArg("fillArc", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public final void fillOval(int n, int n2, int n3, int n4) {
        this.queueOpArg("fillOval", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public final void fillPolygon(int[] nArray, int[] nArray2, int n) {
        Class<?> clazz = nArray.getClass();
        this.queueOpArg("fillPolygon", new Class[]{clazz, clazz, Integer.TYPE}, new Object[]{nArray, nArray2, new Integer(n)});
    }

    public final void fillRect(int n, int n2, int n3, int n4) {
        this.queueOpArg("fillRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public final void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.queueOpArg("fillRoundRect", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4), new Integer(n5), new Integer(n6)});
    }

    public final Color getBackground() {
        return this.background;
    }

    private Graphics2D getBogusGraphics2D() {
        TiledImage tiledImage = this.createTiledImage(this.renderingHints, this.dimensions.getBounds());
        return tiledImage.createGraphics();
    }

    public final Shape getClip() {
        return this.clip;
    }

    public final Rectangle getClipBounds() {
        return this.clip.getBounds();
    }

    public final Color getColor() {
        return this.color;
    }

    public final Composite getComposite() {
        return this.composite;
    }

    public final GraphicsConfiguration getDeviceConfiguration() {
        Graphics2D graphics2D = this.getBogusGraphics2D();
        GraphicsConfiguration graphicsConfiguration = graphics2D.getDeviceConfiguration();
        graphics2D.dispose();
        return graphicsConfiguration;
    }

    public final Font getFont() {
        return this.font;
    }

    public final FontMetrics getFontMetrics(Font font) {
        Graphics2D graphics2D = this.getBogusGraphics2D();
        FontMetrics fontMetrics = graphics2D.getFontMetrics(font);
        graphics2D.dispose();
        return fontMetrics;
    }

    public final FontRenderContext getFontRenderContext() {
        Graphics2D graphics2D = this.getBogusGraphics2D();
        FontRenderContext fontRenderContext = graphics2D.getFontRenderContext();
        graphics2D.dispose();
        return fontRenderContext;
    }

    public final float getHeight() {
        return (float)this.dimensions.getHeight();
    }

    public final float getMinX() {
        return (float)this.dimensions.getMinX();
    }

    public final float getMinY() {
        return (float)this.dimensions.getMinY();
    }

    public final Paint getPaint() {
        return this.paint;
    }

    public final Object getProperty(String string) {
        return Image.UndefinedProperty;
    }

    public final String[] getPropertyNames() {
        return null;
    }

    public final Object getRenderingHint(RenderingHints.Key key) {
        return this.renderingHints.get(key);
    }

    public final RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public final Vector getSources() {
        return null;
    }

    public final Stroke getStroke() {
        return this.stroke;
    }

    public final AffineTransform getTransform() {
        return this.transform;
    }

    public final float getWidth() {
        return (float)this.dimensions.getWidth();
    }

    public final boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        Graphics2D graphics2D = this.getBogusGraphics2D();
        boolean bl2 = graphics2D.hit(rectangle, shape, bl);
        graphics2D.dispose();
        return bl2;
    }

    public final boolean isDynamic() {
        return false;
    }

    private void queueOpArg(String string, Class[] classArray, Object[] objectArray) {
        Method method = null;
        try {
            method = GRAPHICS2D_CLASS.getMethod(string, classArray);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        this.opArgList.addLast(method);
        this.opArgList.addLast(objectArray);
    }

    public final void rotate(double d2) {
        this.transform.rotate(d2);
        this.queueOpArg("rotate", new Class[]{Double.TYPE}, new Object[]{new Double(d2)});
    }

    public final void rotate(double d2, double d3, double d4) {
        this.transform.rotate(d2, d3, d4);
        this.queueOpArg("rotate", new Class[]{Double.TYPE, Double.TYPE, Double.TYPE}, new Object[]{new Double(d2), new Double(d3), new Double(d4)});
    }

    public final void scale(double d2, double d3) {
        this.transform.scale(d2, d3);
        this.queueOpArg("scale", new Class[]{Double.TYPE, Double.TYPE}, new Object[]{new Double(d2), new Double(d3)});
    }

    public final void setBackground(Color color) {
        this.background = color;
        this.queueOpArg("setBackground", new Class[]{class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = RenderableGraphics.class$("java.awt.Color"))}, new Object[]{color});
    }

    public final void setClip(int n, int n2, int n3, int n4) {
        this.clip = new Rectangle(n, n2, n3, n4);
        this.queueOpArg("setClip", new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4)});
    }

    public final void setClip(Shape shape) {
        this.clip = shape;
        this.queueOpArg("setClip", new Class[]{class$java$awt$Shape != null ? class$java$awt$Shape : (class$java$awt$Shape = RenderableGraphics.class$("java.awt.Shape"))}, new Object[]{shape});
    }

    public final void setColor(Color color) {
        this.color = color;
        this.queueOpArg("setColor", new Class[]{class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = RenderableGraphics.class$("java.awt.Color"))}, new Object[]{color});
    }

    public final void setComposite(Composite composite) {
        this.composite = composite;
        this.queueOpArg("setComposite", new Class[]{class$java$awt$Composite != null ? class$java$awt$Composite : (class$java$awt$Composite = RenderableGraphics.class$("java.awt.Composite"))}, new Object[]{composite});
    }

    public final void setFont(Font font) {
        this.font = font;
        this.queueOpArg("setFont", new Class[]{class$java$awt$Font != null ? class$java$awt$Font : (class$java$awt$Font = RenderableGraphics.class$("java.awt.Font"))}, new Object[]{font});
    }

    public final void setPaint(Paint paint) {
        this.paint = paint;
        this.queueOpArg("setPaint", new Class[]{class$java$awt$Paint != null ? class$java$awt$Paint : (class$java$awt$Paint = RenderableGraphics.class$("java.awt.Paint"))}, new Object[]{paint});
    }

    public final void setPaintMode() {
        this.queueOpArg("setPaintMode", null, null);
    }

    public final void setRenderingHint(RenderingHints.Key key, Object object) {
        this.renderingHints.put(key, object);
        this.queueOpArg("setRenderingHint", new Class[]{class$java$awt$RenderingHints$Key != null ? class$java$awt$RenderingHints$Key : (class$java$awt$RenderingHints$Key = RenderableGraphics.class$("java.awt.RenderingHints$Key")), class$java$lang$Object != null ? class$java$lang$Object : (class$java$lang$Object = RenderableGraphics.class$("java.lang.Object"))}, new Object[]{key, object});
    }

    public final void setRenderingHints(Map map) {
        this.renderingHints.putAll((Map<?, ?>)map);
        this.queueOpArg("setRenderingHints", new Class[]{class$java$util$Map != null ? class$java$util$Map : (class$java$util$Map = RenderableGraphics.class$("java.util.Map"))}, new Object[]{map});
    }

    public final void setStroke(Stroke stroke) {
        this.stroke = stroke;
        this.queueOpArg("setStroke", new Class[]{class$java$awt$Stroke != null ? class$java$awt$Stroke : (class$java$awt$Stroke = RenderableGraphics.class$("java.awt.Stroke"))}, new Object[]{stroke});
    }

    public final void setTransform(AffineTransform affineTransform) {
        this.transform = affineTransform;
        this.queueOpArg("setTransform", new Class[]{class$java$awt$geom$AffineTransform != null ? class$java$awt$geom$AffineTransform : (class$java$awt$geom$AffineTransform = RenderableGraphics.class$("java.awt.geom.AffineTransform"))}, new Object[]{affineTransform});
    }

    public final void setXORMode(Color color) {
        this.queueOpArg("setXORMode", new Class[]{class$java$awt$Color != null ? class$java$awt$Color : (class$java$awt$Color = RenderableGraphics.class$("java.awt.Color"))}, new Object[]{color});
    }

    public final void shear(double d2, double d3) {
        this.transform.shear(d2, d3);
        this.queueOpArg("shear", new Class[]{Double.TYPE, Double.TYPE}, new Object[]{new Double(d2), new Double(d3)});
    }

    public final void transform(AffineTransform affineTransform) {
        this.transform.concatenate(affineTransform);
        this.queueOpArg("transform", new Class[]{class$java$awt$geom$AffineTransform != null ? class$java$awt$geom$AffineTransform : (class$java$awt$geom$AffineTransform = RenderableGraphics.class$("java.awt.geom.AffineTransform"))}, new Object[]{affineTransform});
    }

    public final void translate(double d2, double d3) {
        this.transform.translate(d2, d3);
        this.queueOpArg("translate", new Class[]{Double.TYPE, Double.TYPE}, new Object[]{new Double(d2), new Double(d3)});
    }

    public final void translate(int n, int n2) {
        this.origin = new Point(n, n2);
        this.transform.translate(n, n2);
        this.queueOpArg("translate", new Class[]{Integer.TYPE, Integer.TYPE}, new Object[]{new Integer(n), new Integer(n2)});
    }
}

