/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.io.Serializable;
import javax.media.jai.JaiI18N;

public final class PerspectiveTransform
implements Cloneable,
Serializable {
    private static final double PERSPECTIVE_DIVIDE_EPSILON = 1.0E-10;
    double m00;
    double m01;
    double m02;
    double m10;
    double m11;
    double m12;
    double m20;
    double m21;
    double m22;

    public PerspectiveTransform() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m21 = 0.0;
        this.m20 = 0.0;
        this.m12 = 0.0;
        this.m10 = 0.0;
        this.m02 = 0.0;
        this.m01 = 0.0;
    }

    public PerspectiveTransform(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10) {
        this.m00 = d2;
        this.m01 = d3;
        this.m02 = d4;
        this.m10 = d5;
        this.m11 = d6;
        this.m12 = d7;
        this.m20 = d8;
        this.m21 = d9;
        this.m22 = d10;
    }

    public PerspectiveTransform(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.m00 = f2;
        this.m01 = f3;
        this.m02 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m20 = f8;
        this.m21 = f9;
        this.m22 = f10;
    }

    public PerspectiveTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.getScaleX();
        this.m01 = affineTransform.getShearX();
        this.m02 = affineTransform.getTranslateX();
        this.m10 = affineTransform.getShearY();
        this.m11 = affineTransform.getScaleY();
        this.m12 = affineTransform.getTranslateY();
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public PerspectiveTransform(double[] dArray) {
        this.m00 = dArray[0];
        this.m01 = dArray[1];
        this.m02 = dArray[2];
        this.m10 = dArray[3];
        this.m11 = dArray[4];
        this.m12 = dArray[5];
        this.m20 = dArray[6];
        this.m21 = dArray[7];
        this.m22 = dArray[8];
    }

    public PerspectiveTransform(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m10 = fArray[3];
        this.m11 = fArray[4];
        this.m12 = fArray[5];
        this.m20 = fArray[6];
        this.m21 = fArray[7];
        this.m22 = fArray[8];
    }

    public PerspectiveTransform(double[][] dArray) {
        this.m00 = dArray[0][0];
        this.m01 = dArray[0][1];
        this.m02 = dArray[0][2];
        this.m10 = dArray[1][0];
        this.m11 = dArray[1][1];
        this.m12 = dArray[1][2];
        this.m20 = dArray[2][0];
        this.m21 = dArray[2][1];
        this.m22 = dArray[2][2];
    }

    public PerspectiveTransform(float[][] fArray) {
        this.m00 = fArray[0][0];
        this.m01 = fArray[0][1];
        this.m02 = fArray[0][2];
        this.m10 = fArray[1][0];
        this.m11 = fArray[1][1];
        this.m12 = fArray[1][2];
        this.m20 = fArray[2][0];
        this.m21 = fArray[2][1];
        this.m22 = fArray[2][2];
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public void concatenate(AffineTransform affineTransform) {
        double d2 = affineTransform.getScaleX();
        double d3 = affineTransform.getShearX();
        double d4 = affineTransform.getTranslateX();
        double d5 = affineTransform.getShearY();
        double d6 = affineTransform.getScaleY();
        double d7 = affineTransform.getTranslateY();
        double d8 = this.m00 * d2 + this.m10 * d3 + this.m20 * d4;
        double d9 = this.m01 * d2 + this.m11 * d3 + this.m21 * d4;
        double d10 = this.m02 * d2 + this.m12 * d3 + this.m22 * d4;
        double d11 = this.m00 * d5 + this.m10 * d6 + this.m20 * d7;
        double d12 = this.m01 * d5 + this.m11 * d6 + this.m21 * d7;
        double d13 = this.m02 * d5 + this.m12 * d6 + this.m22 * d7;
        double d14 = this.m20;
        double d15 = this.m21;
        double d16 = this.m22;
        this.m00 = d8;
        this.m10 = d11;
        this.m20 = d14;
        this.m01 = d9;
        this.m11 = d12;
        this.m21 = d15;
        this.m02 = d10;
        this.m12 = d13;
        this.m22 = d16;
    }

    public void concatenate(PerspectiveTransform perspectiveTransform) {
        double d2 = this.m00 * perspectiveTransform.m00 + this.m10 * perspectiveTransform.m01 + this.m20 * perspectiveTransform.m02;
        double d3 = this.m00 * perspectiveTransform.m10 + this.m10 * perspectiveTransform.m11 + this.m20 * perspectiveTransform.m12;
        double d4 = this.m00 * perspectiveTransform.m20 + this.m10 * perspectiveTransform.m21 + this.m20 * perspectiveTransform.m22;
        double d5 = this.m01 * perspectiveTransform.m00 + this.m11 * perspectiveTransform.m01 + this.m21 * perspectiveTransform.m02;
        double d6 = this.m01 * perspectiveTransform.m10 + this.m11 * perspectiveTransform.m11 + this.m21 * perspectiveTransform.m12;
        double d7 = this.m01 * perspectiveTransform.m20 + this.m11 * perspectiveTransform.m21 + this.m21 * perspectiveTransform.m22;
        double d8 = this.m02 * perspectiveTransform.m00 + this.m12 * perspectiveTransform.m01 + this.m22 * perspectiveTransform.m02;
        double d9 = this.m02 * perspectiveTransform.m10 + this.m12 * perspectiveTransform.m11 + this.m22 * perspectiveTransform.m12;
        double d10 = this.m02 * perspectiveTransform.m20 + this.m12 * perspectiveTransform.m21 + this.m22 * perspectiveTransform.m22;
        this.m00 = d2;
        this.m10 = d3;
        this.m20 = d4;
        this.m01 = d5;
        this.m11 = d6;
        this.m21 = d7;
        this.m02 = d8;
        this.m12 = d9;
        this.m22 = d10;
    }

    public PerspectiveTransform createAdjoint() {
        PerspectiveTransform perspectiveTransform = (PerspectiveTransform)this.clone();
        perspectiveTransform.makeAdjoint();
        return perspectiveTransform;
    }

    public PerspectiveTransform createInverse() {
        PerspectiveTransform perspectiveTransform = (PerspectiveTransform)this.clone();
        perspectiveTransform.makeAdjoint();
        if (Math.abs(perspectiveTransform.m22) < 1.0E-10) {
            throw new NoninvertibleTransformException(JaiI18N.getString("PerspectiveTransform0"));
        }
        perspectiveTransform.normalize();
        return perspectiveTransform;
    }

    public boolean equals(Object object) {
        if (!(object instanceof PerspectiveTransform)) {
            return false;
        }
        PerspectiveTransform perspectiveTransform = (PerspectiveTransform)object;
        return this.m00 == perspectiveTransform.m00 && this.m10 == perspectiveTransform.m10 && this.m20 == perspectiveTransform.m20 && this.m01 == perspectiveTransform.m01 && this.m11 == perspectiveTransform.m11 && this.m21 == perspectiveTransform.m21 && this.m02 == perspectiveTransform.m02 && this.m12 == perspectiveTransform.m12 && this.m22 == perspectiveTransform.m22;
    }

    public double getDeterminant() {
        return this.m00 * (this.m11 * this.m22 - this.m12 * this.m21) - this.m01 * (this.m10 * this.m22 - this.m12 * this.m20) + this.m02 * (this.m10 * this.m21 - this.m11 * this.m20);
    }

    public double[] getMatrix(double[] dArray) {
        if (dArray == null) {
            dArray = new double[]{this.m00, this.m01, this.m02, this.m10, this.m11, this.m12, this.m20, this.m21, this.m22};
        }
        return dArray;
    }

    public double[][] getMatrix(double[][] dArray) {
        if (dArray == null) {
            dArray = new double[3][3];
        }
        dArray[0][0] = this.m00;
        dArray[0][1] = this.m01;
        dArray[0][2] = this.m02;
        dArray[1][0] = this.m10;
        dArray[1][1] = this.m11;
        dArray[1][2] = this.m12;
        dArray[2][0] = this.m20;
        dArray[2][1] = this.m21;
        dArray[2][2] = this.m22;
        return dArray;
    }

    public static PerspectiveTransform getQuadToQuad(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17) {
        PerspectiveTransform perspectiveTransform = PerspectiveTransform.getQuadToSquare(d2, d3, d4, d5, d6, d7, d8, d9);
        PerspectiveTransform perspectiveTransform2 = PerspectiveTransform.getSquareToQuad(d10, d11, d12, d13, d14, d15, d16, d17);
        perspectiveTransform.concatenate(perspectiveTransform2);
        return perspectiveTransform;
    }

    public static PerspectiveTransform getQuadToQuad(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17) {
        return PerspectiveTransform.getQuadToQuad((double)f2, (double)f3, (double)f4, (double)f5, (double)f6, (double)f7, (double)f8, (double)f9, (double)f10, (double)f11, (double)f12, (double)f13, (double)f14, (double)f15, (double)f16, (double)f17);
    }

    public static PerspectiveTransform getQuadToSquare(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        PerspectiveTransform.getSquareToQuad(d2, d3, d4, d5, d6, d7, d8, d9, perspectiveTransform);
        perspectiveTransform.makeAdjoint();
        return perspectiveTransform;
    }

    public static PerspectiveTransform getQuadToSquare(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return PerspectiveTransform.getQuadToSquare((double)f2, (double)f3, (double)f4, (double)f5, (double)f6, (double)f7, (double)f8, (double)f9);
    }

    public static PerspectiveTransform getSquareToQuad(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        PerspectiveTransform.getSquareToQuad(d2, d3, d4, d5, d6, d7, d8, d9, perspectiveTransform);
        return perspectiveTransform;
    }

    private static final void getSquareToQuad(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, PerspectiveTransform perspectiveTransform) {
        double d10 = d2 - d4 + d6 - d8;
        double d11 = d3 - d5 + d7 - d9;
        perspectiveTransform.m22 = 1.0;
        if (d10 == 0.0 && d11 == 0.0) {
            perspectiveTransform.m00 = d4 - d2;
            perspectiveTransform.m01 = d6 - d4;
            perspectiveTransform.m02 = d2;
            perspectiveTransform.m10 = d5 - d3;
            perspectiveTransform.m11 = d7 - d5;
            perspectiveTransform.m12 = d3;
            perspectiveTransform.m20 = 0.0;
            perspectiveTransform.m21 = 0.0;
        } else {
            double d12 = d4 - d6;
            double d13 = d5 - d7;
            double d14 = d8 - d6;
            double d15 = d9 - d7;
            double d16 = 1.0 / (d12 * d15 - d14 * d13);
            perspectiveTransform.m20 = (d10 * d15 - d14 * d11) * d16;
            perspectiveTransform.m21 = (d12 * d11 - d10 * d13) * d16;
            perspectiveTransform.m00 = d4 - d2 + perspectiveTransform.m20 * d4;
            perspectiveTransform.m01 = d8 - d2 + perspectiveTransform.m21 * d8;
            perspectiveTransform.m02 = d2;
            perspectiveTransform.m10 = d5 - d3 + perspectiveTransform.m20 * d5;
            perspectiveTransform.m11 = d9 - d3 + perspectiveTransform.m21 * d9;
            perspectiveTransform.m12 = d3;
        }
    }

    public static PerspectiveTransform getSquareToQuad(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9) {
        return PerspectiveTransform.getSquareToQuad((double)f2, (double)f3, (double)f4, (double)f5, (double)f6, (double)f7, (double)f8, (double)f9);
    }

    public Point2D inverseTransform(Point2D point2D, Point2D point2D2) {
        double d2;
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d3 = point2D.getX();
        double d4 = point2D.getY();
        double d5 = (this.m11 * this.m22 - this.m12 * this.m21) * d3 + (this.m02 * this.m21 - this.m01 * this.m22) * d4 + (this.m01 * this.m12 - this.m02 * this.m11);
        double d6 = (this.m12 * this.m20 - this.m10 * this.m22) * d3 + (this.m00 * this.m22 - this.m02 * this.m20) * d4 + (this.m02 * this.m10 - this.m00 * this.m12);
        double d7 = d2 = (this.m10 * this.m21 - this.m11 * this.m20) * d3 + (this.m01 * this.m20 - this.m00 * this.m21) * d4 + (this.m00 * this.m11 - this.m01 * this.m10);
        if (d2 < 0.0) {
            d7 = -d2;
        }
        if (d7 < 1.0E-10) {
            throw new NoninvertibleTransformException(JaiI18N.getString("PerspectiveTransform1"));
        }
        point2D2.setLocation(d5 / d2, d6 / d2);
        return point2D2;
    }

    public void inverseTransform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == null) {
            dArray2 = new double[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            double d2;
            double d3 = dArray[n++];
            double d4 = dArray[n++];
            double d5 = (this.m11 * this.m22 - this.m12 * this.m21) * d3 + (this.m02 * this.m21 - this.m01 * this.m22) * d4 + (this.m01 * this.m12 - this.m02 * this.m11);
            double d6 = (this.m12 * this.m20 - this.m10 * this.m22) * d3 + (this.m00 * this.m22 - this.m02 * this.m20) * d4 + (this.m02 * this.m10 - this.m00 * this.m12);
            double d7 = d2 = (this.m10 * this.m21 - this.m11 * this.m20) * d3 + (this.m01 * this.m20 - this.m00 * this.m21) * d4 + (this.m00 * this.m11 - this.m01 * this.m10);
            if (d2 < 0.0) {
                d7 = -d2;
            }
            if (d7 < 1.0E-10) {
                throw new NoninvertibleTransformException(JaiI18N.getString("PerspectiveTransform1"));
            }
            dArray2[n2++] = d5 / d2;
            dArray2[n2++] = d6 / d2;
        }
    }

    public boolean isIdentity() {
        return this.m00 == 1.0 && this.m01 == 0.0 && this.m02 == 0.0 && this.m10 == 0.0 && this.m11 == 1.0 && this.m12 == 0.0 && this.m20 == 0.0 && this.m21 == 0.0 && this.m22 == 1.0;
    }

    private final void makeAdjoint() {
        double d2 = this.m11 * this.m22 - this.m12 * this.m21;
        double d3 = this.m12 * this.m20 - this.m10 * this.m22;
        double d4 = this.m10 * this.m21 - this.m11 * this.m20;
        double d5 = this.m02 * this.m21 - this.m01 * this.m22;
        double d6 = this.m00 * this.m22 - this.m02 * this.m20;
        double d7 = this.m01 * this.m20 - this.m00 * this.m21;
        double d8 = this.m01 * this.m12 - this.m02 * this.m11;
        double d9 = this.m02 * this.m10 - this.m00 * this.m12;
        double d10 = this.m00 * this.m11 - this.m01 * this.m10;
        this.m00 = d2;
        this.m01 = d5;
        this.m02 = d8;
        this.m10 = d3;
        this.m11 = d6;
        this.m12 = d9;
        this.m20 = d4;
        this.m21 = d7;
        this.m22 = d10;
    }

    private final void normalize() {
        double d2 = 1.0 / this.m22;
        this.m00 *= d2;
        this.m01 *= d2;
        this.m02 *= d2;
        this.m10 *= d2;
        this.m11 *= d2;
        this.m12 *= d2;
        this.m20 *= d2;
        this.m21 *= d2;
        this.m22 = 1.0;
    }

    public void preConcatenate(AffineTransform affineTransform) {
        double d2 = affineTransform.getScaleX();
        double d3 = affineTransform.getShearX();
        double d4 = affineTransform.getTranslateX();
        double d5 = affineTransform.getShearY();
        double d6 = affineTransform.getScaleY();
        double d7 = affineTransform.getTranslateY();
        double d8 = d2 * this.m00 + d5 * this.m01;
        double d9 = d3 * this.m00 + d6 * this.m01;
        double d10 = d4 * this.m00 + d7 * this.m01 + this.m02;
        double d11 = d2 * this.m10 + d5 * this.m11;
        double d12 = d3 * this.m10 + d6 * this.m11;
        double d13 = d4 * this.m10 + d7 * this.m11 + this.m12;
        double d14 = d2 * this.m20 + d5 * this.m21;
        double d15 = d3 * this.m20 + d6 * this.m21;
        double d16 = d4 * this.m20 + d7 * this.m21 + this.m22;
        this.m00 = d8;
        this.m10 = d11;
        this.m20 = d14;
        this.m01 = d9;
        this.m11 = d12;
        this.m21 = d15;
        this.m02 = d10;
        this.m12 = d13;
        this.m22 = d16;
    }

    public void preConcatenate(PerspectiveTransform perspectiveTransform) {
        double d2 = perspectiveTransform.m00 * this.m00 + perspectiveTransform.m10 * this.m01 + perspectiveTransform.m20 * this.m02;
        double d3 = perspectiveTransform.m00 * this.m10 + perspectiveTransform.m10 * this.m11 + perspectiveTransform.m20 * this.m12;
        double d4 = perspectiveTransform.m00 * this.m20 + perspectiveTransform.m10 * this.m21 + perspectiveTransform.m20 * this.m22;
        double d5 = perspectiveTransform.m01 * this.m00 + perspectiveTransform.m11 * this.m01 + perspectiveTransform.m21 * this.m02;
        double d6 = perspectiveTransform.m01 * this.m10 + perspectiveTransform.m11 * this.m11 + perspectiveTransform.m21 * this.m12;
        double d7 = perspectiveTransform.m01 * this.m20 + perspectiveTransform.m11 * this.m21 + perspectiveTransform.m21 * this.m22;
        double d8 = perspectiveTransform.m02 * this.m00 + perspectiveTransform.m12 * this.m01 + perspectiveTransform.m22 * this.m02;
        double d9 = perspectiveTransform.m02 * this.m10 + perspectiveTransform.m12 * this.m11 + perspectiveTransform.m22 * this.m12;
        double d10 = perspectiveTransform.m02 * this.m20 + perspectiveTransform.m12 * this.m21 + perspectiveTransform.m22 * this.m22;
        this.m00 = d2;
        this.m10 = d3;
        this.m20 = d4;
        this.m01 = d5;
        this.m11 = d6;
        this.m21 = d7;
        this.m02 = d8;
        this.m12 = d9;
        this.m22 = d10;
    }

    public void rotate(double d2) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToRotation(d2);
        this.concatenate(perspectiveTransform);
    }

    public void rotate(double d2, double d3, double d4) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToRotation(d2, d3, d4);
        this.concatenate(perspectiveTransform);
    }

    public void scale(double d2, double d3) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToScale(d2, d3);
        this.concatenate(perspectiveTransform);
    }

    public void setToIdentity() {
        this.m22 = 1.0;
        this.m11 = 1.0;
        this.m00 = 1.0;
        this.m21 = 0.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m01 = 0.0;
    }

    public void setToRotation(double d2) {
        this.m00 = Math.cos(d2);
        this.m01 = -Math.sin(d2);
        this.m02 = 0.0;
        this.m10 = -this.m01;
        this.m11 = this.m00;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setToRotation(double d2, double d3, double d4) {
        this.setToRotation(d2);
        double d5 = this.m10;
        double d6 = 1.0 - this.m00;
        this.m02 = d3 * d6 + d4 * d5;
        this.m12 = d4 * d6 - d3 * d5;
    }

    public void setToScale(double d2, double d3) {
        this.m00 = d2;
        this.m01 = 0.0;
        this.m02 = 0.0;
        this.m10 = 0.0;
        this.m11 = d3;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setToShear(double d2, double d3) {
        this.m00 = 1.0;
        this.m01 = d2;
        this.m02 = 0.0;
        this.m10 = d3;
        this.m11 = 1.0;
        this.m12 = 0.0;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setToTranslation(double d2, double d3) {
        this.m00 = 1.0;
        this.m01 = 0.0;
        this.m02 = d2;
        this.m10 = 0.0;
        this.m11 = 1.0;
        this.m12 = d3;
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setTransform(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10) {
        this.m00 = f2;
        this.m01 = f5;
        this.m02 = f8;
        this.m10 = f3;
        this.m11 = f6;
        this.m12 = f9;
        this.m20 = f4;
        this.m21 = f7;
        this.m22 = f10;
    }

    public void setTransform(AffineTransform affineTransform) {
        this.m00 = affineTransform.getScaleX();
        this.m01 = affineTransform.getShearX();
        this.m02 = affineTransform.getTranslateX();
        this.m10 = affineTransform.getShearY();
        this.m11 = affineTransform.getScaleY();
        this.m12 = affineTransform.getTranslateY();
        this.m20 = 0.0;
        this.m21 = 0.0;
        this.m22 = 1.0;
    }

    public void setTransform(PerspectiveTransform perspectiveTransform) {
        this.m00 = perspectiveTransform.m00;
        this.m01 = perspectiveTransform.m01;
        this.m02 = perspectiveTransform.m02;
        this.m10 = perspectiveTransform.m10;
        this.m11 = perspectiveTransform.m11;
        this.m12 = perspectiveTransform.m12;
        this.m20 = perspectiveTransform.m20;
        this.m21 = perspectiveTransform.m21;
        this.m22 = perspectiveTransform.m22;
    }

    public void shear(double d2, double d3) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToShear(d2, d3);
        this.concatenate(perspectiveTransform);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Perspective transform matrix\n");
        stringBuffer.append(this.m00);
        stringBuffer.append("\t");
        stringBuffer.append(this.m01);
        stringBuffer.append("\t");
        stringBuffer.append(this.m02);
        stringBuffer.append("\n");
        stringBuffer.append(this.m10);
        stringBuffer.append("\t");
        stringBuffer.append(this.m11);
        stringBuffer.append("\t");
        stringBuffer.append(this.m12);
        stringBuffer.append("\n");
        stringBuffer.append(this.m20);
        stringBuffer.append("\t");
        stringBuffer.append(this.m21);
        stringBuffer.append("\t");
        stringBuffer.append(this.m22);
        stringBuffer.append("\n");
        return new String(stringBuffer);
    }

    public Point2D transform(Point2D point2D, Point2D point2D2) {
        if (point2D2 == null) {
            point2D2 = point2D instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
        }
        double d2 = point2D.getX();
        double d3 = point2D.getY();
        double d4 = this.m20 * d2 + this.m21 * d3 + this.m22;
        point2D2.setLocation((this.m00 * d2 + this.m01 * d3 + this.m02) / d4, (this.m10 * d2 + this.m11 * d3 + this.m12) / d4);
        return point2D2;
    }

    public void transform(double[] dArray, int n, double[] dArray2, int n2, int n3) {
        if (dArray2 == null) {
            dArray2 = new double[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4;
            if ((d4 = this.m20 * (d3 = dArray[n++]) + this.m21 * (d2 = dArray[n++]) + this.m22) == 0.0) {
                dArray2[n2++] = d3;
                dArray2[n2++] = d2;
                continue;
            }
            dArray2[n2++] = (this.m00 * d3 + this.m01 * d2 + this.m02) / d4;
            dArray2[n2++] = (this.m10 * d3 + this.m11 * d2 + this.m12) / d4;
        }
    }

    public void transform(double[] dArray, int n, float[] fArray, int n2, int n3) {
        if (fArray == null) {
            fArray = new float[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4;
            if ((d4 = this.m20 * (d3 = dArray[n++]) + this.m21 * (d2 = dArray[n++]) + this.m22) == 0.0) {
                fArray[n2++] = (float)d3;
                fArray[n2++] = (float)d2;
                continue;
            }
            fArray[n2++] = (float)((this.m00 * d3 + this.m01 * d2 + this.m02) / d4);
            fArray[n2++] = (float)((this.m10 * d3 + this.m11 * d2 + this.m12) / d4);
        }
    }

    public void transform(float[] fArray, int n, double[] dArray, int n2, int n3) {
        if (dArray == null) {
            dArray = new double[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            float f2;
            float f3;
            double d2;
            if ((d2 = this.m20 * (double)(f3 = fArray[n++]) + this.m21 * (double)(f2 = fArray[n++]) + this.m22) == 0.0) {
                dArray[n2++] = f3;
                dArray[n2++] = f2;
                continue;
            }
            dArray[n2++] = (this.m00 * (double)f3 + this.m01 * (double)f2 + this.m02) / d2;
            dArray[n2++] = (this.m10 * (double)f3 + this.m11 * (double)f2 + this.m12) / d2;
        }
    }

    public void transform(float[] fArray, int n, float[] fArray2, int n2, int n3) {
        if (fArray2 == null) {
            fArray2 = new float[n3 * 2 + n2];
        }
        while (n3-- > 0) {
            float f2;
            float f3;
            double d2;
            if ((d2 = this.m20 * (double)(f3 = fArray[n++]) + this.m21 * (double)(f2 = fArray[n++]) + this.m22) == 0.0) {
                fArray2[n2++] = f3;
                fArray2[n2++] = f2;
                continue;
            }
            fArray2[n2++] = (float)((this.m00 * (double)f3 + this.m01 * (double)f2 + this.m02) / d2);
            fArray2[n2++] = (float)((this.m10 * (double)f3 + this.m11 * (double)f2 + this.m12) / d2);
        }
    }

    public void transform(Point2D[] point2DArray, int n, Point2D[] point2DArray2, int n2, int n3) {
        while (n3-- > 0) {
            double d2;
            double d3;
            double d4;
            Point2D point2D;
            Point2D point2D2 = point2DArray[n++];
            if ((point2D = point2DArray2[n2++]) == null) {
                point2D = point2D2 instanceof Point2D.Double ? new Point2D.Double() : new Point2D.Float();
                point2DArray2[n2 - 1] = point2D;
            }
            if ((d4 = this.m20 * (d3 = point2D2.getX()) + this.m21 * (d2 = point2D2.getY()) + this.m22) == 0.0) {
                point2D.setLocation(d3, d2);
                continue;
            }
            point2D.setLocation((this.m00 * d3 + this.m01 * d2 + this.m02) / d4, (this.m10 * d3 + this.m11 * d2 + this.m12) / d4);
        }
    }

    public void translate(double d2, double d3) {
        PerspectiveTransform perspectiveTransform = new PerspectiveTransform();
        perspectiveTransform.setToTranslation(d2, d3);
        this.concatenate(perspectiveTransform);
    }
}

