/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import java.util.Vector;
import javax.media.jai.BorderExtender;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.TileCache;
import javax.media.jai.TileScheduler;

public abstract class OpImage
extends PlanarImage {
    public static final int OP_COMPUTE_BOUND = 1;
    public static final int OP_IO_BOUND = 2;
    public static final int OP_NETWORK_BOUND = 3;
    protected BorderExtender[] extenders;
    protected boolean cobbleSources;
    private RasterFormatTag[] formatTags;
    protected transient TileCache cache = JAI.getDefaultInstance().getTileCache();

    public OpImage(RenderedImage renderedImage, RenderedImage renderedImage2, BorderExtender borderExtender, BorderExtender borderExtender2, TileCache tileCache, ImageLayout imageLayout, boolean bl) {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        PlanarImage planarImage2 = PlanarImage.wrapRenderedImage(renderedImage2);
        PlanarImage[] planarImageArray = new PlanarImage[]{planarImage, planarImage2};
        this.addSource(planarImage);
        this.addSource(planarImage2);
        if (tileCache != null) {
            this.cache = tileCache;
        }
        Object object = borderExtender == null && borderExtender2 == null ? null : new BorderExtender[]{borderExtender, borderExtender2};
        this.initialize((BorderExtender[])object, imageLayout, bl);
    }

    public OpImage(RenderedImage renderedImage, BorderExtender borderExtender, TileCache tileCache, ImageLayout imageLayout, boolean bl) {
        PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
        PlanarImage[] planarImageArray = new PlanarImage[]{planarImage};
        this.addSource(planarImage);
        if (tileCache != null) {
            this.cache = tileCache;
        }
        BorderExtender[] borderExtenderArray = borderExtender == null ? null : new BorderExtender[]{borderExtender};
        this.initialize(borderExtenderArray, imageLayout, bl);
    }

    public OpImage(Vector vector, BorderExtender[] borderExtenderArray, TileCache tileCache, ImageLayout imageLayout, boolean bl) {
        int n = 0;
        if (vector != null) {
            n = vector.size();
        }
        if (tileCache != null) {
            this.cache = tileCache;
        }
        RenderedImage[] renderedImageArray = new RenderedImage[n];
        int n2 = 0;
        while (n2 < n) {
            RenderedImage renderedImage = (RenderedImage)vector.elementAt(n2);
            PlanarImage planarImage = PlanarImage.wrapRenderedImage(renderedImage);
            renderedImageArray[n2] = planarImage;
            this.addSource(planarImage);
            ++n2;
        }
        this.initialize(borderExtenderArray, imageLayout, bl);
    }

    protected final synchronized void addTileToCache(int n, int n2, Raster raster) {
        if (this.cache != null) {
            this.cache.add(this, n, n2, raster);
        }
    }

    protected void computeRect(Raster[] rasterArray, WritableRaster writableRaster, Rectangle rectangle) {
        String string = this.getClass().getName();
        throw new RuntimeException(String.valueOf(string) + " " + JaiI18N.getString("OpImage0"));
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        String string = this.getClass().getName();
        throw new RuntimeException(String.valueOf(string) + " " + JaiI18N.getString("OpImage1"));
    }

    public Raster computeTile(int n, int n2) {
        Point point = new Point(this.tileXToX(n), this.tileYToY(n2));
        WritableRaster writableRaster = RasterFactory.createWritableRaster(this.sampleModel, point);
        Rectangle rectangle = this.getTileRect(n, n2);
        Rectangle rectangle2 = rectangle.intersection(this.getBounds());
        int n3 = this.getNumSources();
        if (this.cobbleSources) {
            Raster[] rasterArray = new Raster[n3];
            int n4 = 0;
            while (n4 < n3) {
                PlanarImage planarImage = this.getSource(n4);
                Rectangle rectangle3 = this.mapDestRect(rectangle2, n4);
                if (rectangle3 == null) {
                    rectangle3 = planarImage.getBounds();
                }
                rasterArray[n4] = planarImage.getData(rectangle3);
                ++n4;
            }
            this.computeRect(rasterArray, writableRaster, rectangle2);
        } else {
            PlanarImage[] planarImageArray = new PlanarImage[n3];
            int n5 = 0;
            while (n5 < n3) {
                planarImageArray[n5] = this.getSource(n5);
                ++n5;
            }
            this.computeRect(planarImageArray, writableRaster, rectangle2);
        }
        return writableRaster;
    }

    public boolean computesUniqueTiles() {
        return true;
    }

    protected void finalize() {
        if (this.cache != null) {
            this.cache.removeTiles(this);
        }
        super.finalize();
    }

    private static int getAppropriateDataType(SampleModel sampleModel) {
        int n;
        int n2 = n = sampleModel.getDataType();
        if (n == 1 || n == 3) {
            boolean bl = true;
            boolean bl2 = true;
            int[] nArray = sampleModel.getSampleSize();
            int n3 = 0;
            while (n3 < nArray.length) {
                if (nArray[n3] > 16) {
                    bl = false;
                    bl2 = false;
                    break;
                }
                if (nArray[n3] > 8) {
                    bl = false;
                }
                ++n3;
            }
            if (bl) {
                n2 = 0;
            } else if (bl2) {
                n2 = 1;
            }
        }
        return n2;
    }

    public static final int getExpandedNumBands(SampleModel sampleModel, ColorModel colorModel) {
        if (colorModel instanceof IndexColorModel) {
            return colorModel.getNumComponents();
        }
        return sampleModel.getNumBands();
    }

    protected synchronized RasterFormatTag[] getFormatTags() {
        if (this.formatTags == null) {
            RenderedImage[] renderedImageArray = new RenderedImage[this.getNumSources()];
            this.getSources().toArray(renderedImageArray);
            this.formatTags = RasterAccessor.findCompatibleTags(renderedImageArray, this);
        }
        return this.formatTags;
    }

    public int getOperationComputeType() {
        return 1;
    }

    public Raster getTile(int n, int n2) {
        Raster raster = null;
        if (n >= this.getMinTileX() && n <= this.getMaxTileX() && n2 >= this.getMinTileY() && n2 <= this.getMaxTileY() && (raster = this.getTileFromCache(n, n2)) == null) {
            try {
                raster = JAI.getDefaultInstance().getTileScheduler().scheduleTile(this, n, n2);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                this.cache.setMemoryCapacity(this.cache.getMemoryCapacity() * 3L / 4L);
                System.gc();
                raster = JAI.getDefaultInstance().getTileScheduler().scheduleTile(this, n, n2);
            }
            this.addTileToCache(n, n2, raster);
        }
        return raster;
    }

    public Point[] getTileDependencies(int n, int n2, int n3) {
        if (n3 < 0 || n3 >= this.getNumSources()) {
            return null;
        }
        Rectangle rectangle = this.getTileRect(n, n2);
        if (rectangle.isEmpty()) {
            return null;
        }
        PlanarImage planarImage = this.getSource(n3);
        Rectangle rectangle2 = this.mapDestRect(rectangle, n3);
        int n4 = planarImage.XToTileX(rectangle2.x);
        int n5 = planarImage.XToTileX(rectangle2.x + rectangle2.width - 1);
        int n6 = planarImage.YToTileY(rectangle2.y);
        int n7 = planarImage.YToTileY(rectangle2.y + rectangle2.height - 1);
        n4 = Math.max(n4, planarImage.getMinTileX());
        n5 = Math.min(n5, planarImage.getMaxTileX());
        n6 = Math.max(n6, planarImage.getMinTileY());
        n7 = Math.min(n7, planarImage.getMaxTileY());
        int n8 = n5 - n4 + 1;
        int n9 = n7 - n6 + 1;
        if (n8 <= 0 || n9 <= 0) {
            return null;
        }
        Point[] pointArray = new Point[n9 * n8];
        int n10 = 0;
        int n11 = n6;
        while (n11 <= n7) {
            int n12 = n4;
            while (n12 <= n5) {
                pointArray[n10++] = new Point(n12, n11);
                ++n12;
            }
            ++n11;
        }
        return pointArray;
    }

    protected final synchronized Raster getTileFromCache(int n, int n2) {
        return this.cache != null ? this.cache.getTile(this, n, n2) : null;
    }

    public Raster[] getTiles(Point[] pointArray) {
        Raster[] rasterArray;
        block8: {
            TileScheduler tileScheduler;
            int n;
            boolean[] blArray;
            int n2;
            block9: {
                int n3;
                n2 = pointArray.length;
                rasterArray = new Raster[n2];
                blArray = new boolean[n2];
                int n4 = this.getMinTileX();
                int n5 = this.getMaxTileX();
                int n6 = this.getMinTileY();
                int n7 = this.getMaxTileY();
                n = 0;
                int n8 = 0;
                while (n8 < n2) {
                    int n9 = pointArray[n8].x;
                    n3 = pointArray[n8].y;
                    if (n9 >= n4 && n9 <= n5 && n3 >= n6 && n3 <= n7) {
                        rasterArray[n8] = this.getTileFromCache(n9, n3);
                        if (rasterArray[n8] == null) {
                            blArray[n8] = true;
                            ++n;
                        }
                    }
                    ++n8;
                }
                if (n <= 0) break block8;
                tileScheduler = JAI.getDefaultInstance().getTileScheduler();
                if (n != n2) break block9;
                rasterArray = tileScheduler.scheduleTiles(this, pointArray);
                if (this.cache == null) break block8;
                n3 = 0;
                while (n3 < n2) {
                    this.cache.add(this, pointArray[n3].x, pointArray[n3].y, rasterArray[n3]);
                    ++n3;
                }
                break block8;
            }
            Point[] pointArray2 = new Point[n];
            n = 0;
            int n10 = 0;
            while (n10 < n2) {
                if (blArray[n10]) {
                    pointArray2[n++] = pointArray[n10];
                }
                ++n10;
            }
            Raster[] rasterArray2 = tileScheduler.scheduleTiles(this, pointArray2);
            n = 0;
            int n11 = 0;
            while (n11 < n2) {
                if (blArray[n11]) {
                    rasterArray[n11] = rasterArray2[n++];
                    this.addTileToCache(pointArray[n11].x, pointArray[n11].y, rasterArray[n11]);
                }
                ++n11;
            }
        }
        return rasterArray;
    }

    public final boolean hasExtender(int n) {
        return this.extenders != null && this.extenders[n] != null;
    }

    private void initialize(BorderExtender[] borderExtenderArray, ImageLayout imageLayout, boolean bl) {
        boolean bl2;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        this.extenders = borderExtenderArray;
        this.cobbleSources = bl;
        if (this.source0 == null) {
            this.initializeNoSource(imageLayout);
        } else if (imageLayout == null) {
            this.setImageParameters(this.source0);
        } else {
            this.setImageParameters(imageLayout, this.source0);
        }
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        if (imageLayout != null) {
            bl3 = imageLayout.isValid(1);
            bl4 = imageLayout.isValid(2);
            bl5 = imageLayout.isValid(4);
            bl6 = imageLayout.isValid(8);
        }
        if (!(bl3 && bl4 && bl5 && bl6)) {
            n5 = this.source0.getMinX();
            int n6 = n5 + this.source0.getWidth();
            int n7 = this.source0.getMinY();
            n4 = n7 + this.source0.getHeight();
            n3 = this.getNumSources();
            n2 = 1;
            while (n2 < n3) {
                PlanarImage planarImage = this.getSource(n2);
                int n8 = planarImage.getMinX();
                n = n8 + planarImage.getWidth();
                int n9 = planarImage.getMinY();
                int n10 = n9 + planarImage.getHeight();
                if (n5 < n8) {
                    n5 = n8;
                }
                if (n6 > n) {
                    n6 = n;
                }
                if (n7 < n9) {
                    n7 = n9;
                }
                if (n4 > n10) {
                    n4 = n10;
                }
                ++n2;
            }
            if (!bl3) {
                this.minX = n5;
            }
            if (!bl4) {
                this.minY = n7;
            }
            if (!bl5) {
                this.width = n6 - n5;
            }
            if (!bl6) {
                this.height = n4 - n7;
            }
        }
        if (this.width < 0 || this.height < 0) {
            throw new IllegalArgumentException(JaiI18N.getString("OpImage4"));
        }
        int n11 = n5 = imageLayout == null || !imageLayout.isValid(256) ? 0 : 1;
        if (n5 == 0) {
            SampleModel sampleModel = this.source0.getSampleModel();
            ColorModel colorModel = this.source0.getColorModel();
            n4 = OpImage.getAppropriateDataType(sampleModel);
            n3 = OpImage.getExpandedNumBands(sampleModel, colorModel);
            n2 = this.getNumSources();
            int n12 = 1;
            while (n12 < n2) {
                PlanarImage planarImage = this.getSource(n12);
                sampleModel = planarImage.getSampleModel();
                colorModel = planarImage.getColorModel();
                n = OpImage.getExpandedNumBands(sampleModel, colorModel);
                n4 = OpImage.mergeTypes(n4, sampleModel.getDataType());
                n3 = Math.min(n3, n);
                ++n12;
            }
            this.sampleModel = RasterFactory.createPixelInterleavedSampleModel(n4, this.tileWidth, this.tileHeight, n3);
        } else if (this.sampleModel != null && (this.sampleModel.getWidth() != this.tileWidth || this.sampleModel.getHeight() != this.tileHeight)) {
            this.sampleModel = this.sampleModel.createCompatibleSampleModel(this.tileWidth, this.tileHeight);
        }
        boolean bl7 = bl2 = imageLayout != null && imageLayout.isValid(512);
        if (!bl2 && this.sampleModel != null) {
            this.colorModel = PlanarImage.createColorModel(this.sampleModel);
        }
    }

    private void initializeNoSource(ImageLayout imageLayout) {
        if (imageLayout == null) {
            throw new IllegalArgumentException(JaiI18N.getString("OpImage2"));
        }
        if (!(imageLayout.isValid(1) && imageLayout.isValid(2) && imageLayout.isValid(4) && imageLayout.isValid(8) && imageLayout.isValid(256))) {
            throw new IllegalArgumentException(JaiI18N.getString("OpImage3"));
        }
        this.minX = imageLayout.getMinX(null);
        this.minY = imageLayout.getMinY(null);
        this.width = imageLayout.getWidth(null);
        this.height = imageLayout.getHeight(null);
        this.sampleModel = imageLayout.getSampleModel(null);
        this.tileGridXOffset = imageLayout.isValid(16) ? imageLayout.getTileGridXOffset(null) : this.minX;
        this.tileGridYOffset = imageLayout.isValid(32) ? imageLayout.getTileGridYOffset(null) : this.minY;
        this.tileWidth = imageLayout.isValid(64) ? imageLayout.getTileWidth(null) : 256;
        this.tileHeight = imageLayout.isValid(128) ? imageLayout.getTileHeight(null) : 256;
        if (imageLayout.isValid(512)) {
            this.colorModel = imageLayout.getColorModel(null);
        }
    }

    public abstract Rectangle mapDestRect(Rectangle var1, int var2);

    public abstract Rectangle mapSourceRect(Rectangle var1, int var2);

    private static int mergeTypes(int n, int n2) {
        if (n == n2) {
            return n;
        }
        if (n > n2) {
            int n3 = n;
            n = n2;
            n2 = n3;
        }
        if (n == 2 && n2 == 1) {
            return 3;
        }
        return n2;
    }

    public final void prefetchTiles(Point[] pointArray) {
        TileScheduler tileScheduler = JAI.getDefaultInstance().getTileScheduler();
        tileScheduler.prefetchTiles(this, pointArray);
    }

    public final synchronized void setTileCache(TileCache tileCache) {
        this.cache.removeTiles(this);
        this.cache = tileCache;
    }

    private static final Vector vectorize(RenderedImage renderedImage) {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(1);
        vector.addElement(renderedImage);
        return vector;
    }

    private static final Vector vectorize(RenderedImage renderedImage, RenderedImage renderedImage2) {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(2);
        vector.addElement(renderedImage);
        vector.addElement(renderedImage2);
        return vector;
    }

    static final Vector vectorize(RenderedImage renderedImage, RenderedImage renderedImage2, RenderedImage renderedImage3) {
        Vector<RenderedImage> vector = new Vector<RenderedImage>(3);
        vector.addElement(renderedImage);
        vector.addElement(renderedImage2);
        vector.addElement(renderedImage3);
        return vector;
    }
}

