/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.image.IndexColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.util.Hashtable;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.PointOpImage;
import javax.media.jai.TileCache;

public class NullOpImage
extends PointOpImage {
    protected int computeType;

    public NullOpImage(RenderedImage renderedImage, TileCache tileCache, int n, ImageLayout imageLayout) {
        super(PlanarImage.wrapRenderedImage(renderedImage).createSnapshot(), tileCache, NullOpImage.layoutHelper(renderedImage, imageLayout), false);
        this.computeType = n;
        if (renderedImage != null && renderedImage.getColorModel() instanceof IndexColorModel) {
            if (imageLayout != null) {
                this.sampleModel = imageLayout.getSampleModel(renderedImage);
                this.colorModel = imageLayout.getColorModel(renderedImage);
            } else {
                this.sampleModel = renderedImage.getSampleModel();
                this.colorModel = renderedImage.getColorModel();
            }
        }
    }

    public final Raster computeTile(int n, int n2) {
        return this.source0.getTile(n, n2);
    }

    public final boolean computesUniqueTiles() {
        return false;
    }

    public final int getOperationComputeType() {
        return this.computeType;
    }

    protected final synchronized Hashtable getProperties() {
        return this.source0.getProperties();
    }

    public final Object getProperty(String string) {
        return this.source0.getProperty(string);
    }

    public final String[] getPropertyNames() {
        return this.source0.getPropertyNames();
    }

    public final String[] getPropertyNames(String string) {
        return this.source0.getPropertyNames(string);
    }

    private static ImageLayout layoutHelper(RenderedImage renderedImage, ImageLayout imageLayout) {
        ImageLayout imageLayout2 = new ImageLayout(renderedImage);
        if (imageLayout != null) {
            imageLayout2.setTileGridXOffset(imageLayout.getTileGridXOffset(renderedImage));
            imageLayout2.setTileGridYOffset(imageLayout.getTileGridYOffset(renderedImage));
            imageLayout2.setTileWidth(imageLayout.getTileWidth(renderedImage));
            imageLayout2.setTileHeight(imageLayout.getTileHeight(renderedImage));
            imageLayout2.setSampleModel(imageLayout.getSampleModel(renderedImage));
            imageLayout2.setColorModel(imageLayout.getColorModel(renderedImage));
        }
        return imageLayout2;
    }

    protected final synchronized void setProperties(Hashtable hashtable) {
        this.source0.setProperties(hashtable);
    }

    public final void setProperty(String string, Object object) {
        this.source0.setProperty(string, object);
    }
}

