/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import javax.media.jai.Interpolation;

public final class InterpolationBilinear
extends Interpolation {
    private int one;
    private int round;
    private int shift;
    private int round2;
    private int shift2;
    static final int DEFAULT_SUBSAMPLE_BITS = 8;

    public InterpolationBilinear() {
        this(8);
    }

    public InterpolationBilinear(int n) {
        super(2, 2, 0, 1, 0, 1, n, n);
        this.shift = n;
        this.one = 1 << this.shift;
        this.round = 1 << this.shift - 1;
        this.shift2 = 2 * n;
        this.round2 = 1 << this.shift2 - 1;
    }

    public final double interpolate(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, float f2, float f3) {
        return this.interpolate(d7, d8, d11, d12, f2, f3);
    }

    public final double interpolate(double d2, double d3, double d4, double d5, float f2, float f3) {
        double d6 = (d3 - d2) * (double)f2 + d2;
        double d7 = (d5 - d4) * (double)f2 + d4;
        return (d7 - d6) * (double)f3 + d6;
    }

    public final float interpolate(float f2, float f3, float f4, float f5, float f6, float f7) {
        float f8 = (f3 - f2) * f6 + f2;
        float f9 = (f5 - f4) * f6 + f4;
        return (f9 - f8) * f7 + f8;
    }

    public final float interpolate(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19) {
        return this.interpolate(f7, f8, f11, f12, f18, f19);
    }

    public final int interpolate(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = (n2 - n) * n5 + (n << this.shift);
        int n8 = (n4 - n3) * n5 + (n3 << this.shift);
        return (n8 - n7) * n6 + (n7 << this.shift) + this.round2 >> this.shift2;
    }

    public final int interpolate(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18) {
        return this.interpolate(n6, n7, n10, n11, n17, n18);
    }

    public final double interpolate(double[][] dArray, float f2, float f3) {
        return this.interpolate(dArray[0][0], dArray[0][1], dArray[1][0], dArray[1][1], f2, f3);
    }

    public final float interpolate(float[][] fArray, float f2, float f3) {
        return this.interpolate(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], f2, f3);
    }

    public final int interpolate(int[][] nArray, int n, int n2) {
        return this.interpolate(nArray[0][0], nArray[0][1], nArray[1][0], nArray[1][1], n, n2);
    }

    public final double interpolateH(double d2, double d3, double d4, double d5, float f2) {
        return this.interpolateH(d3, d4, f2);
    }

    public final double interpolateH(double d2, double d3, float f2) {
        return (d3 - d2) * (double)f2 + d2;
    }

    public final float interpolateH(float f2, float f3, float f4) {
        return (f3 - f2) * f4 + f2;
    }

    public final float interpolateH(float f2, float f3, float f4, float f5, float f6) {
        return this.interpolateH(f3, f4, f6);
    }

    public final int interpolateH(int n, int n2, int n3) {
        return (n2 - n) * n3 + (n << this.shift) + this.round >> this.shift;
    }

    public final int interpolateH(int n, int n2, int n3, int n4, int n5) {
        return this.interpolateH(n2, n3, n5);
    }

    public final double interpolateH(double[] dArray, float f2) {
        return this.interpolateH(dArray[0], dArray[1], f2);
    }

    public final float interpolateH(float[] fArray, float f2) {
        return this.interpolateH(fArray[0], fArray[1], f2);
    }

    public final int interpolateH(int[] nArray, int n) {
        return this.interpolateH(nArray[0], nArray[1], n);
    }

    public final double interpolateV(double d2, double d3, double d4, double d5, float f2) {
        return this.interpolateV(d3, d4, f2);
    }

    public final double interpolateV(double d2, double d3, float f2) {
        return (d3 - d2) * (double)f2 + d2;
    }

    public final float interpolateV(float f2, float f3, float f4) {
        return (f3 - f2) * f4 + f2;
    }

    public final float interpolateV(float f2, float f3, float f4, float f5, float f6) {
        return this.interpolateV(f3, f4, f6);
    }

    public final int interpolateV(int n, int n2, int n3) {
        return (n2 - n) * n3 + (n << this.shift) + this.round >> this.shift;
    }

    public final int interpolateV(int n, int n2, int n3, int n4, int n5) {
        return this.interpolateV(n2, n3, n5);
    }

    public final double interpolateV(double[] dArray, float f2) {
        return this.interpolateV(dArray[0], dArray[1], f2);
    }

    public final float interpolateV(float[] fArray, float f2) {
        return this.interpolateV(fArray[0], fArray[1], f2);
    }

    public final int interpolateV(int[] nArray, int n) {
        return this.interpolateV(nArray[0], nArray[1], n);
    }
}

