/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.io.Serializable;
import javax.media.jai.InterpolationBicubic;
import javax.media.jai.InterpolationBicubic2;
import javax.media.jai.InterpolationBilinear;
import javax.media.jai.InterpolationNearest;
import javax.media.jai.JaiI18N;

public abstract class Interpolation
implements Serializable {
    public static final int INTERP_NEAREST = 0;
    public static final int INTERP_BILINEAR = 1;
    public static final int INTERP_BICUBIC = 2;
    public static final int INTERP_BICUBIC_2 = 3;
    private static final Interpolation nearestInstance = new InterpolationNearest();
    private static final Interpolation bilinearInstance = new InterpolationBilinear();
    private static final Interpolation bicubicInstance = new InterpolationBicubic(8);
    private static final Interpolation bicubic2Instance = new InterpolationBicubic2(8);
    protected int leftPadding;
    protected int rightPadding;
    protected int topPadding;
    protected int bottomPadding;
    protected int subsampleBitsH;
    protected int subsampleBitsV;
    protected int width;
    protected int height;

    public Interpolation() {
    }

    public Interpolation(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        this.width = n;
        this.height = n2;
        this.leftPadding = n3;
        this.rightPadding = n4;
        this.topPadding = n5;
        this.bottomPadding = n6;
        this.subsampleBitsH = n7;
        this.subsampleBitsV = n8;
    }

    public int getBottomPadding() {
        return this.bottomPadding;
    }

    public int getHeight() {
        return this.height;
    }

    public static Interpolation getInstance(int n) {
        Object var1_1 = null;
        switch (n) {
            case 0: {
                return nearestInstance;
            }
            case 1: {
                return bilinearInstance;
            }
            case 2: {
                return bicubicInstance;
            }
            case 3: {
                return bicubic2Instance;
            }
        }
        throw new IllegalArgumentException(JaiI18N.getString("Interpolation0"));
    }

    public int getLeftPadding() {
        return this.leftPadding;
    }

    public int getRightPadding() {
        return this.rightPadding;
    }

    public int getSubsampleBitsH() {
        return this.subsampleBitsH;
    }

    public int getSubsampleBitsV() {
        return this.subsampleBitsV;
    }

    public int getTopPadding() {
        return this.topPadding;
    }

    public int getWidth() {
        return this.width;
    }

    public double interpolate(double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, double d12, double d13, double d14, double d15, double d16, double d17, float f2, float f3) {
        double[][] dArray = new double[4][4];
        dArray[0][0] = d2;
        dArray[0][1] = d3;
        dArray[0][2] = d4;
        dArray[0][3] = d5;
        dArray[1][0] = d6;
        dArray[1][1] = d7;
        dArray[1][2] = d8;
        dArray[1][3] = d9;
        dArray[2][0] = d10;
        dArray[2][1] = d11;
        dArray[2][2] = d12;
        dArray[2][3] = d13;
        dArray[3][0] = d14;
        dArray[3][1] = d15;
        dArray[3][2] = d16;
        dArray[3][3] = d17;
        return this.interpolate(dArray, f2, f3);
    }

    public double interpolate(double d2, double d3, double d4, double d5, float f2, float f3) {
        double[][] dArray = new double[4][4];
        dArray[0][0] = d2;
        dArray[0][1] = d3;
        dArray[1][0] = d4;
        dArray[1][1] = d5;
        return this.interpolate(dArray, f2, f3);
    }

    public float interpolate(float f2, float f3, float f4, float f5, float f6, float f7) {
        float[][] fArray = new float[4][4];
        fArray[0][0] = f2;
        fArray[0][1] = f3;
        fArray[1][0] = f4;
        fArray[1][1] = f5;
        return this.interpolate(fArray, f6, f7);
    }

    public float interpolate(float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16, float f17, float f18, float f19) {
        float[][] fArray = new float[4][4];
        fArray[0][0] = f2;
        fArray[0][1] = f3;
        fArray[0][2] = f4;
        fArray[0][3] = f5;
        fArray[1][0] = f6;
        fArray[1][1] = f7;
        fArray[1][2] = f8;
        fArray[1][3] = f9;
        fArray[2][0] = f10;
        fArray[2][1] = f11;
        fArray[2][2] = f12;
        fArray[2][3] = f13;
        fArray[3][0] = f14;
        fArray[3][1] = f15;
        fArray[3][2] = f16;
        fArray[3][3] = f17;
        return this.interpolate(fArray, f18, f19);
    }

    public int interpolate(int n, int n2, int n3, int n4, int n5, int n6) {
        int[][] nArray = new int[4][4];
        nArray[0][0] = n;
        nArray[0][1] = n2;
        nArray[1][0] = n3;
        nArray[1][1] = n4;
        return this.interpolate(nArray, n5, n6);
    }

    public int interpolate(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9, int n10, int n11, int n12, int n13, int n14, int n15, int n16, int n17, int n18) {
        int[][] nArray = new int[4][4];
        nArray[0][0] = n;
        nArray[0][1] = n2;
        nArray[0][2] = n3;
        nArray[0][3] = n4;
        nArray[1][0] = n5;
        nArray[1][1] = n6;
        nArray[1][2] = n7;
        nArray[1][3] = n8;
        nArray[2][0] = n9;
        nArray[2][1] = n10;
        nArray[2][2] = n11;
        nArray[2][3] = n12;
        nArray[3][0] = n13;
        nArray[3][1] = n14;
        nArray[3][2] = n15;
        nArray[3][3] = n16;
        return this.interpolate(nArray, n17, n18);
    }

    public double interpolate(double[][] dArray, float f2, float f3) {
        int n = this.getHeight();
        double[] dArray2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            dArray2[n2] = this.interpolateH(dArray[n2], f2);
            ++n2;
        }
        return this.interpolateV(dArray2, f3);
    }

    public float interpolate(float[][] fArray, float f2, float f3) {
        int n = this.getHeight();
        float[] fArray2 = new float[n];
        int n2 = 0;
        while (n2 < n) {
            fArray2[n2] = this.interpolateH(fArray[n2], f2);
            ++n2;
        }
        return this.interpolateV(fArray2, f3);
    }

    public int interpolate(int[][] nArray, int n, int n2) {
        int n3 = this.getHeight();
        int[] nArray2 = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray2[n4] = this.interpolateH(nArray[n4], n);
            ++n4;
        }
        return this.interpolateV(nArray2, n2);
    }

    public double interpolateH(double d2, double d3, double d4, double d5, float f2) {
        double[] dArray = new double[]{d2, d3, d4, d5};
        return this.interpolateH(dArray, f2);
    }

    public double interpolateH(double d2, double d3, float f2) {
        double[] dArray = new double[]{d2, d3};
        return this.interpolateH(dArray, f2);
    }

    public float interpolateH(float f2, float f3, float f4) {
        float[] fArray = new float[]{f2, f3};
        return this.interpolateH(fArray, f4);
    }

    public float interpolateH(float f2, float f3, float f4, float f5, float f6) {
        float[] fArray = new float[]{f2, f3, f4, f5};
        return this.interpolateH(fArray, f6);
    }

    public int interpolateH(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2};
        return this.interpolateH(nArray, n3);
    }

    public int interpolateH(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[]{n, n2, n3, n4};
        return this.interpolateH(nArray, n5);
    }

    public abstract double interpolateH(double[] var1, float var2);

    public abstract float interpolateH(float[] var1, float var2);

    public abstract int interpolateH(int[] var1, int var2);

    public double interpolateV(double d2, double d3, double d4, double d5, float f2) {
        double[] dArray = new double[]{d2, d3, d4, d5};
        return this.interpolateV(dArray, f2);
    }

    public double interpolateV(double d2, double d3, float f2) {
        double[] dArray = new double[]{d2, d3};
        return this.interpolateV(dArray, f2);
    }

    public float interpolateV(float f2, float f3, float f4) {
        float[] fArray = new float[]{f2, f3};
        return this.interpolateV(fArray, f4);
    }

    public float interpolateV(float f2, float f3, float f4, float f5, float f6) {
        float[] fArray = new float[]{f2, f3, f4, f5};
        return this.interpolateV(fArray, f6);
    }

    public int interpolateV(int n, int n2, int n3) {
        int[] nArray = new int[]{n, n2};
        return this.interpolateV(nArray, n3);
    }

    public int interpolateV(int n, int n2, int n3, int n4, int n5) {
        int[] nArray = new int[]{n, n2, n3, n4};
        return this.interpolateV(nArray, n5);
    }

    public double interpolateV(double[] dArray, float f2) {
        return this.interpolateH(dArray, f2);
    }

    public float interpolateV(float[] fArray, float f2) {
        return this.interpolateH(fArray, f2);
    }

    public int interpolateV(int[] nArray, int n) {
        return this.interpolateH(nArray, n);
    }

    public boolean isSeparable() {
        return true;
    }
}

