/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.util.Collection;
import java.util.Iterator;
import javax.media.jai.CollectionImage;
import javax.media.jai.CoordinateImage;
import javax.media.jai.PlanarImage;

public abstract class ImageStack
extends CollectionImage {
    protected ImageStack() {
    }

    public ImageStack(Collection collection) {
        super(collection);
    }

    public final boolean add(Object object) {
        if (object != null && object instanceof CoordinateImage) {
            return super.add(object);
        }
        return false;
    }

    public final Object getCoordinate(PlanarImage planarImage) {
        if (planarImage != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CoordinateImage coordinateImage = (CoordinateImage)iterator.next();
                if (!coordinateImage.image.equals(planarImage)) continue;
                return coordinateImage.coordinate;
            }
        }
        return null;
    }

    public final PlanarImage getImage(Object object) {
        if (object != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CoordinateImage coordinateImage = (CoordinateImage)iterator.next();
                if (!coordinateImage.coordinate.equals(object)) continue;
                return coordinateImage.image;
            }
        }
        return null;
    }

    public final boolean remove(Object object) {
        if (object != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CoordinateImage coordinateImage = (CoordinateImage)iterator.next();
                if (!coordinateImage.coordinate.equals(object)) continue;
                return super.remove(coordinateImage);
            }
        }
        return false;
    }

    public final boolean remove(PlanarImage planarImage) {
        if (planarImage != null) {
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                CoordinateImage coordinateImage = (CoordinateImage)iterator.next();
                if (!coordinateImage.image.equals(planarImage)) continue;
                return super.remove(coordinateImage);
            }
        }
        return false;
    }
}

