/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.io.Serializable;
import java.util.LinkedList;
import java.util.ListIterator;
import javax.media.jai.JaiI18N;
import javax.media.jai.ROI;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFormatTag;

public class Histogram
implements Serializable {
    private int numBands;
    private int[] numBins;
    private double[] lowValue;
    private double[] highValue;
    private double[] binWidth;
    private int[][] bins;

    public Histogram(int[] nArray, double[] dArray, double[] dArray2) {
        if (dArray.length < nArray.length || dArray2.length < nArray.length) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram0"));
        }
        this.numBins = nArray;
        this.lowValue = dArray;
        this.highValue = dArray2;
        this.numBands = nArray.length;
        this.binWidth = new double[this.numBands];
        this.bins = new int[this.numBands][];
        int n = 0;
        while (n < this.numBands) {
            if (nArray[n] <= 0) {
                throw new IllegalArgumentException(JaiI18N.getString("Histogram1"));
            }
            if (dArray2[n] <= dArray[n]) {
                throw new IllegalArgumentException(JaiI18N.getString("Histogram2"));
            }
            this.binWidth[n] = (dArray2[n] - dArray[n]) / (double)nArray[n];
            this.bins[n] = new int[nArray[n]];
            ++n;
        }
    }

    public void clearHistogram() {
        int n = 0;
        while (n < this.numBands) {
            int n2 = 0;
            while (n2 < this.numBins[n]) {
                this.bins[n][n2] = 0;
                ++n2;
            }
            ++n;
        }
    }

    public void countPixels(Raster raster, ROI rOI, int n, int n2, int n3, int n4) {
        LinkedList linkedList;
        SampleModel sampleModel = raster.getSampleModel();
        if (sampleModel.getNumBands() != this.numBands) {
            throw new IllegalArgumentException(JaiI18N.getString("Histogram3"));
        }
        Rectangle rectangle = raster.getBounds();
        int n5 = RasterAccessor.findCompatibleTag(null, sampleModel);
        RasterFormatTag rasterFormatTag = new RasterFormatTag(sampleModel, n5);
        RasterAccessor rasterAccessor = new RasterAccessor(raster, rectangle, rasterFormatTag, null);
        if (rOI == null) {
            linkedList = new LinkedList();
            linkedList.addLast(rectangle);
        } else {
            linkedList = rOI.getAsRectangleList(raster.getMinX(), raster.getMinY(), raster.getWidth(), raster.getHeight());
            if (linkedList == null) {
                return;
            }
        }
        ListIterator listIterator = linkedList.listIterator(0);
        while (listIterator.hasNext()) {
            Rectangle rectangle2 = (Rectangle)listIterator.next();
            int n6 = rectangle2.x;
            int n7 = rectangle2.y;
            rectangle2.x = this.startPosition(n6, n, n3);
            rectangle2.y = this.startPosition(n7, n2, n4);
            rectangle2.width = n6 + rectangle2.width - rectangle2.x;
            rectangle2.height = n7 + rectangle2.height - rectangle2.y;
            if (rectangle2.width <= 0 || rectangle2.height <= 0) continue;
            switch (rasterAccessor.getDataType()) {
                case 0: {
                    this.countPixelsByte(rasterAccessor, rectangle2, n3, n4);
                    break;
                }
                case 1: {
                    this.countPixelsUShort(rasterAccessor, rectangle2, n3, n4);
                    break;
                }
                case 2: {
                    this.countPixelsShort(rasterAccessor, rectangle2, n3, n4);
                    break;
                }
                case 3: {
                    this.countPixelsInt(rasterAccessor, rectangle2, n3, n4);
                    break;
                }
                case 4: {
                    this.countPixelsFloat(rasterAccessor, rectangle2, n3, n4);
                    break;
                }
                case 5: {
                    this.countPixelsDouble(rasterAccessor, rectangle2, n3, n4);
                    break;
                }
            }
        }
    }

    private void countPixelsByte(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = (rectangle.y - rasterAccessor.getY()) * rasterAccessor.getScanlineStride() + (rectangle.x - rasterAccessor.getX()) * rasterAccessor.getPixelStride();
        byte[][] byArray = rasterAccessor.getByteDataArrays();
        int n6 = rasterAccessor.getScanlineStride() * n2;
        int n7 = rasterAccessor.getPixelStride() * n;
        int[] nArray = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < this.numBands) {
            byte[] byArray2 = byArray[n8];
            int n9 = nArray[n8] + n5;
            int[] nArray2 = this.bins[n8];
            float f2 = (float)this.lowValue[n8];
            float f3 = (float)this.highValue[n8];
            float f4 = 1.0f / (float)this.binWidth[n8];
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n9;
                n9 += n6;
                int n12 = 0;
                while (n12 < n3) {
                    int n13 = byArray2[n11] & 0xFF;
                    if ((float)n13 >= f2 && (float)n13 < f3) {
                        int n14;
                        int n15 = n14 = (int)(((float)n13 - f2) * f4);
                        nArray2[n15] = nArray2[n15] + 1;
                    }
                    n11 += n7;
                    n12 += n;
                }
                n10 += n2;
            }
            ++n8;
        }
    }

    private void countPixelsDouble(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = (rectangle.y - rasterAccessor.getY()) * rasterAccessor.getScanlineStride() + (rectangle.x - rasterAccessor.getX()) * rasterAccessor.getPixelStride();
        double[][] dArray = rasterAccessor.getDoubleDataArrays();
        int n6 = rasterAccessor.getScanlineStride() * n2;
        int n7 = rasterAccessor.getPixelStride() * n;
        int[] nArray = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < this.numBands) {
            double[] dArray2 = dArray[n8];
            int n9 = nArray[n8] + n5;
            int[] nArray2 = this.bins[n8];
            double d2 = this.lowValue[n8];
            double d3 = this.highValue[n8];
            double d4 = 1.0 / this.binWidth[n8];
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n9;
                n9 += n6;
                int n12 = 0;
                while (n12 < n3) {
                    double d5 = dArray2[n11];
                    if (d5 >= d2 && d5 < d3) {
                        int n13;
                        int n14 = n13 = (int)((d5 - d2) * d4);
                        nArray2[n14] = nArray2[n14] + 1;
                    }
                    n11 += n7;
                    n12 += n;
                }
                n10 += n2;
            }
            ++n8;
        }
    }

    private void countPixelsFloat(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = (rectangle.y - rasterAccessor.getY()) * rasterAccessor.getScanlineStride() + (rectangle.x - rasterAccessor.getX()) * rasterAccessor.getPixelStride();
        float[][] fArray = rasterAccessor.getFloatDataArrays();
        int n6 = rasterAccessor.getScanlineStride() * n2;
        int n7 = rasterAccessor.getPixelStride() * n;
        int[] nArray = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < this.numBands) {
            float[] fArray2 = fArray[n8];
            int n9 = nArray[n8] + n5;
            int[] nArray2 = this.bins[n8];
            float f2 = (float)this.lowValue[n8];
            float f3 = (float)this.highValue[n8];
            float f4 = 1.0f / (float)this.binWidth[n8];
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n9;
                n9 += n6;
                int n12 = 0;
                while (n12 < n3) {
                    float f5 = fArray2[n11];
                    if (f5 >= f2 && f5 < f3) {
                        int n13;
                        int n14 = n13 = (int)((f5 - f2) * f4);
                        nArray2[n14] = nArray2[n14] + 1;
                    }
                    n11 += n7;
                    n12 += n;
                }
                n10 += n2;
            }
            ++n8;
        }
    }

    private void countPixelsInt(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = (rectangle.y - rasterAccessor.getY()) * rasterAccessor.getScanlineStride() + (rectangle.x - rasterAccessor.getX()) * rasterAccessor.getPixelStride();
        int[][] nArray = rasterAccessor.getIntDataArrays();
        int n6 = rasterAccessor.getScanlineStride() * n2;
        int n7 = rasterAccessor.getPixelStride() * n;
        int[] nArray2 = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < this.numBands) {
            int[] nArray3 = nArray[n8];
            int n9 = nArray2[n8] + n5;
            int[] nArray4 = this.bins[n8];
            float f2 = (float)this.lowValue[n8];
            float f3 = (float)this.highValue[n8];
            float f4 = 1.0f / (float)this.binWidth[n8];
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n9;
                n9 += n6;
                int n12 = 0;
                while (n12 < n3) {
                    int n13 = nArray3[n11];
                    if ((float)n13 >= f2 && (float)n13 < f3) {
                        int n14;
                        int n15 = n14 = (int)(((float)n13 - f2) * f4);
                        nArray4[n15] = nArray4[n15] + 1;
                    }
                    n11 += n7;
                    n12 += n;
                }
                n10 += n2;
            }
            ++n8;
        }
    }

    private void countPixelsShort(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = (rectangle.y - rasterAccessor.getY()) * rasterAccessor.getScanlineStride() + (rectangle.x - rasterAccessor.getX()) * rasterAccessor.getPixelStride();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride() * n2;
        int n7 = rasterAccessor.getPixelStride() * n;
        int[] nArray = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < this.numBands) {
            short[] sArray2 = sArray[n8];
            int n9 = nArray[n8] + n5;
            int[] nArray2 = this.bins[n8];
            float f2 = (float)this.lowValue[n8];
            float f3 = (float)this.highValue[n8];
            float f4 = 1.0f / (float)this.binWidth[n8];
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n9;
                n9 += n6;
                int n12 = 0;
                while (n12 < n3) {
                    short s = sArray2[n11];
                    if ((float)s >= f2 && (float)s < f3) {
                        int n13;
                        int n14 = n13 = (int)(((float)s - f2) * f4);
                        nArray2[n14] = nArray2[n14] + 1;
                    }
                    n11 += n7;
                    n12 += n;
                }
                n10 += n2;
            }
            ++n8;
        }
    }

    private void countPixelsUShort(RasterAccessor rasterAccessor, Rectangle rectangle, int n, int n2) {
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        int n5 = (rectangle.y - rasterAccessor.getY()) * rasterAccessor.getScanlineStride() + (rectangle.x - rasterAccessor.getX()) * rasterAccessor.getPixelStride();
        short[][] sArray = rasterAccessor.getShortDataArrays();
        int n6 = rasterAccessor.getScanlineStride() * n2;
        int n7 = rasterAccessor.getPixelStride() * n;
        int[] nArray = rasterAccessor.getBandOffsets();
        int n8 = 0;
        while (n8 < this.numBands) {
            short[] sArray2 = sArray[n8];
            int n9 = nArray[n8] + n5;
            int[] nArray2 = this.bins[n8];
            float f2 = (float)this.lowValue[n8];
            float f3 = (float)this.highValue[n8];
            float f4 = 1.0f / (float)this.binWidth[n8];
            int n10 = 0;
            while (n10 < n4) {
                int n11 = n9;
                n9 += n6;
                int n12 = 0;
                while (n12 < n3) {
                    int n13 = sArray2[n11] & 0xFFFF;
                    if ((float)n13 >= f2 && (float)n13 < f3) {
                        int n14;
                        int n15 = n14 = (int)(((float)n13 - f2) * f4);
                        nArray2[n15] = nArray2[n15] + 1;
                    }
                    n11 += n7;
                    n12 += n;
                }
                n10 += n2;
            }
            ++n8;
        }
    }

    public double getBinLowValue(int n, int n2) {
        return this.lowValue[n] + (double)n2 * this.binWidth[n];
    }

    public int getBinSize(int n, int n2) {
        return this.bins[n][n2];
    }

    public int[][] getBins() {
        return this.bins;
    }

    public int[] getBins(int n) {
        return this.bins[n];
    }

    public double[] getHighValue() {
        return this.highValue;
    }

    public double getHighValue(int n) {
        return this.highValue[n];
    }

    public double[] getLowValue() {
        return this.lowValue;
    }

    public double getLowValue(int n) {
        return this.lowValue[n];
    }

    public int getNumBands() {
        return this.numBands;
    }

    public int[] getNumBins() {
        return this.numBins;
    }

    public int getNumBins(int n) {
        return this.numBins[n];
    }

    private int startPosition(int n, int n2, int n3) {
        int n4 = (n - n2) % n3;
        if (n4 == 0) {
            return n;
        }
        return n + (n3 - n4);
    }
}

