/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai;

import java.awt.Point;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.ComponentSampleModel;
import java.awt.image.Raster;
import java.awt.image.SampleModel;
import java.awt.image.WritableRaster;
import javax.media.jai.ComponentSampleModelJAI;
import javax.media.jai.JaiI18N;
import javax.media.jai.RasterFactory;

public class FloatDoubleColorModel
extends ComponentColorModel {
    ColorSpace colorSpace;
    int colorSpaceType;
    int numColorComponents;
    int numComponents;
    int transparency;
    boolean hasAlpha;
    boolean isAlphaPremultiplied;

    public FloatDoubleColorModel(ColorSpace colorSpace, boolean bl, boolean bl2, int n, int n2) {
        super(colorSpace, FloatDoubleColorModel.bitsHelper(n2, colorSpace, bl), bl, bl2, n, n2);
        if (n2 != 4 && n2 != 5) {
            throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel0"));
        }
        this.colorSpace = colorSpace;
        this.colorSpaceType = colorSpace.getType();
        this.numComponents = this.numColorComponents = colorSpace.getNumComponents();
        if (bl) {
            ++this.numComponents;
        }
        this.transparency = n;
        this.hasAlpha = bl;
        this.isAlphaPremultiplied = bl2;
    }

    private static int[] bitsHelper(int n, ColorSpace colorSpace, boolean bl) {
        int n2 = n == 4 ? 32 : 64;
        int n3 = colorSpace.getNumComponents();
        if (bl) {
            ++n3;
        }
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = n2;
            ++n4;
        }
        return nArray;
    }

    private int clamp(double d2) {
        return d2 >= 0.0 ? (d2 > 255.0 ? 255 : (int)d2) : 0;
    }

    private int clamp(float f2) {
        return f2 >= 0.0f ? (f2 > 255.0f ? 255 : (int)f2) : 0;
    }

    /*
     * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
     * Unable to fully structure code
     * Enabled aggressive block sorting
     */
    public final ColorModel coerceData(WritableRaster var1_1, boolean var2_2) {
        if (this.hasAlpha == false) return this;
        if (this.isAlphaPremultiplied == var2_2) {
            return this;
        }
        var3_3 = var1_1.getWidth();
        var4_4 = var1_1.getHeight();
        var5_5 = var1_1.getNumBands() - 1;
        var6_6 = var1_1.getMinX();
        var7_7 = var1_1.getMinY();
        if (var1_1.getTransferType() != this.transferType) {
            throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel6"));
        }
        if (var2_2) {
            switch (this.transferType) {
                case 4: {
                    var9_8 = null;
                    var10_12 = 0;
                    block8: while (true) {
                        if (var10_12 >= var4_4) {
                            return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, var2_2, this.transparency, this.transferType);
                        }
                        var8_16 = var6_6;
                        var11_20 = 0;
                        while (true) {
                            if (var11_20 >= var3_3) {
                                ++var10_12;
                                ++var7_7;
                                continue block8;
                            }
                            var12_24 = (var9_8 = (float[])var1_1.getDataElements(var8_16, var7_7, var9_8))[var5_5];
                            if (var12_24 != 0.0f) {
                                var13_28 = 0;
                                while (true) {
                                    if (var13_28 >= var5_5) {
                                        var1_1.setDataElements(var8_16, var7_7, var9_8);
                                        break;
                                    }
                                    v0 = var13_28++;
                                    var9_8[v0] = var9_8[v0] * var12_24;
                                }
                            }
                            ++var11_20;
                            ++var8_16;
                        }
                        break;
                    }
                }
                case 5: {
                    var9_9 = null;
                    var10_13 = 0;
                    block11: while (true) {
                        if (var10_13 >= var4_4) {
                            return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, var2_2, this.transparency, this.transferType);
                        }
                        var8_17 = var6_6;
                        var11_21 = 0;
                        while (true) {
                            if (var11_21 >= var3_3) {
                                ++var10_13;
                                ++var7_7;
                                continue block11;
                            }
                            var12_25 = (var9_9 = (double[])var1_1.getDataElements(var8_17, var7_7, var9_9))[var5_5];
                            if (var12_25 != 0.0) {
                                var14_30 = 0;
                                while (true) {
                                    if (var14_30 >= var5_5) {
                                        var1_1.setDataElements(var8_17, var7_7, var9_9);
                                        break;
                                    }
                                    v1 = var14_30++;
                                    var9_9[v1] = var9_9[v1] * var12_25;
                                }
                            }
                            ++var11_21;
                            ++var8_17;
                        }
                        break;
                    }
                }
                default: {
                    return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, var2_2, this.transparency, this.transferType);
                }
            }
        } else {
            switch (this.transferType) {
                case 4: {
                    var9_10 = 0;
                    block14: while (var9_10 < var4_4) {
                        var8_18 = var6_6;
                        var10_14 = 0;
                        while (true) {
                            if (var10_14 >= var3_3) {
                                ++var9_10;
                                ++var7_7;
                                continue block14;
                            }
                            var11_22 = null;
                            var12_26 = (var11_22 = (float[])var1_1.getDataElements(var8_18, var7_7, var11_22))[var5_5];
                            if (var12_26 != 0.0f) {
                                var13_29 = 1.0f / var12_26;
                                var14_31 = 0;
                                while (var14_31 < var5_5) {
                                    v2 = var14_31++;
                                    var11_22[v2] = var11_22[v2] * var13_29;
                                }
                            }
                            var1_1.setDataElements(var8_18, var7_7, var11_22);
                            ++var10_14;
                            ++var8_18;
                        }
                    }
                    break;
                }
                case 5: {
                    var9_11 = 0;
                    ** while (var9_11 < var4_4)
                }
lbl-1000:
                // 1 sources

                {
                    var8_19 = var6_6;
                    var10_15 = 0;
                    while (var10_15 < var3_3) {
                        var11_23 = null;
                        var12_27 = (var11_23 = (double[])var1_1.getDataElements(var8_19, var7_7, var11_23))[var5_5];
                        if (var12_27 != 0.0) {
                            var14_32 = 1.0 / var12_27;
                            var16_33 = 0;
                            while (var16_33 < var5_5) {
                                v3 = var16_33++;
                                var11_23[v3] = var11_23[v3] * var14_32;
                            }
                        }
                        var1_1.setDataElements(var8_19, var7_7, var11_23);
                        ++var10_15;
                        ++var8_19;
                    }
                    ++var9_11;
                    ++var7_7;
                    continue;
                }
            }
        }
lbl114:
        // 3 sources

        return new FloatDoubleColorModel(this.colorSpace, this.hasAlpha, var2_2, this.transparency, this.transferType);
    }

    public final SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = new int[this.numComponents];
        int n3 = 0;
        while (n3 < this.numComponents) {
            nArray[n3] = n3;
            ++n3;
        }
        return new ComponentSampleModelJAI(this.transferType, n, n2, this.numComponents, n * this.numComponents, nArray);
    }

    public final WritableRaster createCompatibleWritableRaster(int n, int n2) {
        SampleModel sampleModel = this.createCompatibleSampleModel(n, n2);
        return RasterFactory.createWritableRaster(sampleModel, new Point(0, 0));
    }

    public final int getAlpha(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel4"));
    }

    public final int getAlpha(Object object) {
        if (!this.hasAlpha) {
            return 255;
        }
        if (this.transferType == 4) {
            float[] fArray = (float[])object;
            return (int)(fArray[this.numColorComponents] * 255.0f);
        }
        double[] dArray = (double[])object;
        return (int)(dArray[this.numColorComponents] * 255.0);
    }

    public final int getBlue(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel3"));
    }

    public final int getBlue(Object object) {
        return this.getSample(object, 2);
    }

    public final int[] getComponents(int n, int[] nArray, int n2) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public final int[] getComponents(Object object, int[] nArray, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public final int getDataElement(int[] nArray, int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel9"));
    }

    public final Object getDataElements(int n, Object object) {
        double[] dArray;
        if (this.transferType == 4) {
            float[] fArray;
            if (object == null) {
                fArray = new float[this.numComponents];
            } else {
                if (!(object instanceof float[])) {
                    throw new ClassCastException(JaiI18N.getString("FloatDoubleColorModel7"));
                }
                fArray = (float[])object;
                if (fArray.length < this.numComponents) {
                    throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("FloatDoubleColorModel8"));
                }
            }
            float f2 = 0.003921569f;
            if (this.colorSpace.isCS_sRGB()) {
                int n2 = n >> 24 & 0xFF;
                int n3 = n >> 16 & 0xFF;
                int n4 = n >> 8 & 0xFF;
                int n5 = n & 0xFF;
                float f3 = f2;
                if (this.isAlphaPremultiplied) {
                    f3 *= (float)n2;
                }
                fArray[0] = (float)n3 * f3;
                fArray[1] = (float)n4 * f3;
                fArray[2] = (float)n5 * f3;
                if (this.hasAlpha) {
                    fArray[3] = (float)n2 * f2;
                }
            } else if (this.colorSpaceType == 6) {
                float f4;
                fArray[0] = f4 = (float)(n >> 16 & 0xFF) * (0.299f * f2) + (float)(n >> 8 & 0xFF) * (0.587f * f2) + (float)(n & 0xFF) * (0.114f * f2);
                if (this.hasAlpha) {
                    int n6 = n >> 24 & 0xFF;
                    fArray[1] = (float)n6 * f2;
                }
            } else {
                float[] fArray2 = new float[]{(float)(n >> 16 & 0xFF) * f2, (float)(n >> 8 & 0xFF) * f2, (float)(n & 0xFF) * f2};
                fArray2 = this.colorSpace.fromRGB(fArray2);
                int n7 = 0;
                while (n7 < this.numColorComponents) {
                    fArray[n7] = fArray2[n7];
                    ++n7;
                }
                if (this.hasAlpha) {
                    int n8 = n >> 24 & 0xFF;
                    fArray[this.numColorComponents] = (float)n8 * f2;
                }
            }
            return fArray;
        }
        if (object == null) {
            dArray = new double[this.numComponents];
        } else {
            if (!(object instanceof double[])) {
                throw new ClassCastException(JaiI18N.getString("FloatDoubleColorModel7"));
            }
            dArray = (double[])object;
            if (dArray.length < this.numComponents) {
                throw new ArrayIndexOutOfBoundsException(JaiI18N.getString("FloatDoubleColorModel8"));
            }
        }
        double d2 = 0.00392156862745098;
        if (this.colorSpace.isCS_sRGB()) {
            int n9 = n >> 24 & 0xFF;
            int n10 = n >> 16 & 0xFF;
            int n11 = n >> 8 & 0xFF;
            int n12 = n & 0xFF;
            double d3 = d2;
            if (this.isAlphaPremultiplied) {
                d3 *= (double)n9;
            }
            dArray[0] = (double)n10 * d3;
            dArray[1] = (double)n11 * d3;
            dArray[2] = (double)n12 * d3;
            if (this.hasAlpha) {
                dArray[3] = (double)n9 * d2;
            }
        } else if (this.colorSpaceType == 6) {
            double d4;
            dArray[0] = d4 = (double)(n >> 16 & 0xFF) * (0.299 * d2) + (double)(n >> 8 & 0xFF) * (0.587 * d2) + (double)(n & 0xFF) * (0.114 * d2);
            if (this.hasAlpha) {
                int n13 = n >> 24 & 0xFF;
                dArray[1] = (double)n13 * d2;
            }
        } else {
            float f5 = 0.003921569f;
            float[] fArray = new float[]{(float)(n >> 16 & 0xFF) * f5, (float)(n >> 8 & 0xFF) * f5, (float)(n & 0xFF) * f5};
            fArray = this.colorSpace.fromRGB(fArray);
            int n14 = 0;
            while (n14 < this.numColorComponents) {
                dArray[n14] = fArray[n14];
                ++n14;
            }
            if (this.hasAlpha) {
                int n15 = n >> 24 & 0xFF;
                dArray[this.numColorComponents] = (double)n15 * d2;
            }
        }
        return dArray;
    }

    public final Object getDataElements(int[] nArray, int n, Object object) {
        if (nArray.length - n < this.numComponents) {
            throw new IllegalArgumentException(String.valueOf(this.numComponents) + " " + JaiI18N.getString("FloatDoubleColorModel10"));
        }
        if (this.transferType == 4) {
            float[] fArray = object == null ? new float[nArray.length] : (float[])object;
            int n2 = 0;
            while (n2 < this.numComponents) {
                fArray[n2] = nArray[n + n2];
                ++n2;
            }
            return fArray;
        }
        double[] dArray = object == null ? new double[nArray.length] : (double[])object;
        int n3 = 0;
        while (n3 < this.numComponents) {
            dArray[n3] = nArray[n + n3];
            ++n3;
        }
        return dArray;
    }

    public final int getGreen(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel2"));
    }

    public final int getGreen(Object object) {
        return this.getSample(object, 1);
    }

    public final int getRGB(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel5"));
    }

    public final int getRGB(Object object) {
        int n;
        int n2;
        int n3;
        boolean bl = this.hasAlpha && this.isAlphaPremultiplied;
        int n4 = 255;
        if (this.colorSpace.isCS_sRGB()) {
            if (this.transferType == 4) {
                float[] fArray = (float[])object;
                float f2 = fArray[0];
                float f3 = fArray[1];
                float f4 = fArray[2];
                float f5 = 255.0f;
                if (bl) {
                    float f6 = fArray[3];
                    f5 /= f6;
                    n4 = this.clamp(255.0f * f6);
                }
                n3 = this.clamp(f2 * f5);
                n2 = this.clamp(f3 * f5);
                n = this.clamp(f4 * f5);
            } else {
                double[] dArray = (double[])object;
                double d2 = dArray[0];
                double d3 = dArray[1];
                double d4 = dArray[2];
                double d5 = 255.0;
                if (bl) {
                    double d6 = dArray[3];
                    d5 /= d6;
                    n4 = this.clamp(255.0 * d6);
                }
                n3 = this.clamp(d2 * d5);
                n2 = this.clamp(d3 * d5);
                n = this.clamp(d4 * d5);
            }
        } else if (this.colorSpaceType == 6) {
            if (this.transferType == 4) {
                float[] fArray = (float[])object;
                float f7 = fArray[0];
                if (bl) {
                    float f8 = fArray[1];
                    n2 = n = this.clamp(f7 * 255.0f / f8);
                    n3 = n;
                    n4 = this.clamp(255.0f * f8);
                } else {
                    n2 = n = this.clamp(f7 * 255.0f);
                    n3 = n;
                }
            } else {
                double[] dArray = (double[])object;
                double d7 = dArray[0];
                if (bl) {
                    double d8 = dArray[1];
                    n2 = n = this.clamp(d7 * 255.0 / d8);
                    n3 = n;
                    n4 = this.clamp(255.0 * d8);
                } else {
                    n2 = n = this.clamp(d7 * 255.0);
                    n3 = n;
                }
            }
        } else {
            float[] fArray;
            if (this.transferType == 4) {
                float[] fArray2 = (float[])object;
                if (bl) {
                    float f9 = fArray2[this.numColorComponents];
                    float f10 = 1.0f / f9;
                    fArray = new float[this.numColorComponents];
                    int n5 = 0;
                    while (n5 < this.numColorComponents) {
                        fArray[n5] = fArray2[n5] * f10;
                        ++n5;
                    }
                    n4 = this.clamp(255.0f * f9);
                } else {
                    fArray = fArray2;
                }
            } else {
                double[] dArray = (double[])object;
                fArray = new float[this.numColorComponents];
                if (bl) {
                    double d9 = dArray[this.numColorComponents];
                    double d10 = 1.0 / d9;
                    int n6 = 0;
                    while (n6 < this.numColorComponents) {
                        fArray[n6] = (float)(dArray[n6] * d10);
                        ++n6;
                    }
                    n4 = this.clamp(255.0 * d9);
                } else {
                    int n7 = 0;
                    while (n7 < this.numColorComponents) {
                        fArray[n7] = (float)dArray[n7];
                        ++n7;
                    }
                }
            }
            float[] fArray3 = this.colorSpace.toRGB(fArray);
            n3 = this.clamp(fArray3[0] * 255.0f);
            n2 = this.clamp(fArray3[1] * 255.0f);
            n = this.clamp(fArray3[2] * 255.0f);
        }
        return n4 << 24 | n3 << 16 | n2 << 8 | n;
    }

    public final int getRed(int n) {
        throw new IllegalArgumentException(JaiI18N.getString("FloatDoubleColorModel1"));
    }

    public final int getRed(Object object) {
        return this.getSample(object, 0);
    }

    private int getSample(Object object, int n) {
        boolean bl = this.hasAlpha && this.isAlphaPremultiplied;
        int n2 = this.colorSpaceType;
        boolean bl2 = this.colorSpace.isCS_sRGB();
        if (n2 == 6) {
            n = 0;
            bl2 = true;
        }
        if (bl2) {
            if (this.transferType == 4) {
                float[] fArray = (float[])object;
                float f2 = fArray[n] * 255.0f;
                if (bl) {
                    float f3 = fArray[this.numColorComponents];
                    return this.clamp(f2 / f3);
                }
                return this.clamp(f2);
            }
            double[] dArray = (double[])object;
            double d2 = dArray[n] * 255.0;
            if (bl) {
                double d3 = dArray[this.numColorComponents];
                return this.clamp(d2 / d3);
            }
            return this.clamp(d2);
        }
        if (this.transferType == 4) {
            float[] fArray = (float[])object;
            if (bl) {
                float f4 = fArray[this.numColorComponents];
                float[] fArray2 = new float[this.numColorComponents];
                int n3 = 0;
                while (n3 < this.numColorComponents) {
                    fArray2[n3] = fArray[n3] / f4;
                    ++n3;
                }
                float[] fArray3 = this.colorSpace.toRGB(fArray2);
                return (int)(fArray3[n] * f4 * 255.0f);
            }
            float[] fArray4 = this.colorSpace.toRGB(fArray);
            return (int)(fArray4[n] * 255.0f);
        }
        double[] dArray = (double[])object;
        float[] fArray = new float[this.numColorComponents];
        if (bl) {
            double d4 = dArray[this.numColorComponents];
            int n4 = 0;
            while (n4 < this.numColorComponents) {
                fArray[n4] = (float)(dArray[n4] / d4);
                ++n4;
            }
            float[] fArray5 = this.colorSpace.toRGB(fArray);
            return (int)((double)fArray5[n] * d4 * 255.0);
        }
        int n5 = 0;
        while (n5 < this.numColorComponents) {
            fArray[n5] = (float)dArray[n5];
            ++n5;
        }
        float[] fArray6 = this.colorSpace.toRGB(fArray);
        return (int)(fArray6[n] * 255.0f);
    }

    public final boolean isCompatibleRaster(Raster raster) {
        SampleModel sampleModel = raster.getSampleModel();
        return this.isCompatibleSampleModel(sampleModel);
    }

    public final boolean isCompatibleSampleModel(SampleModel sampleModel) {
        if (sampleModel instanceof ComponentSampleModel) {
            if (sampleModel.getNumBands() != this.getNumComponents()) {
                return false;
            }
            return sampleModel.getDataType() == this.transferType;
        }
        return false;
    }

    public final String toString() {
        return "FloatDoubleColorModel: " + super.toString();
    }
}

