/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;

public abstract class TPrimitiveHash
extends THash {
    protected transient byte[] _states;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public TPrimitiveHash() {
    }

    public TPrimitiveHash(int n) {
        this(n, 0.5f);
    }

    public TPrimitiveHash(int n, float f2) {
        this._loadFactor = f2;
        this.setUp((int)Math.ceil((float)n / f2));
    }

    public Object clone() {
        TPrimitiveHash tPrimitiveHash = (TPrimitiveHash)super.clone();
        tPrimitiveHash._states = (byte[])this._states.clone();
        return tPrimitiveHash;
    }

    protected final int capacity() {
        return this._states.length;
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._states[n] = 2;
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._states = new byte[n2];
        return n2;
    }
}

