/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectProcedure;
import java.io.Serializable;
import java.util.Arrays;

public abstract class TObjectHash
extends THash
implements Serializable,
TObjectHashingStrategy {
    protected transient Object[] _set;
    protected TObjectHashingStrategy _hashingStrategy;
    protected static final Object REMOVED = new Object();
    protected static final Object FREE = new Object();

    public TObjectHash() {
        this._hashingStrategy = this;
    }

    public TObjectHash(TObjectHashingStrategy tObjectHashingStrategy) {
        this._hashingStrategy = tObjectHashingStrategy;
    }

    public TObjectHash(int n) {
        super(n);
        this._hashingStrategy = this;
    }

    public TObjectHash(int n, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n);
        this._hashingStrategy = tObjectHashingStrategy;
    }

    public TObjectHash(int n, float f2) {
        super(n, f2);
        this._hashingStrategy = this;
    }

    public TObjectHash(int n, float f2, TObjectHashingStrategy tObjectHashingStrategy) {
        super(n, f2);
        this._hashingStrategy = tObjectHashingStrategy;
    }

    public Object clone() {
        TObjectHash tObjectHash = (TObjectHash)super.clone();
        tObjectHash._set = (Object[])this._set.clone();
        return tObjectHash;
    }

    protected int capacity() {
        return this._set.length;
    }

    protected void removeAt(int n) {
        super.removeAt(n);
        this._set[n] = REMOVED;
    }

    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new Object[n2];
        Arrays.fill(this._set, FREE);
        return n2;
    }

    public boolean forEach(TObjectProcedure tObjectProcedure) {
        Object[] objectArray = this._set;
        int n = objectArray.length;
        while (n-- > 0) {
            if (objectArray[n] == FREE || objectArray[n] == REMOVED || tObjectProcedure.execute(objectArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean contains(Object object) {
        return this.index(object) >= 0;
    }

    protected int index(Object object) {
        Object[] objectArray = this._set;
        int n = objectArray.length;
        int n2 = this._hashingStrategy.computeHashCode(object) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        Object object2 = objectArray[n3];
        if (!(object2 == FREE || object2 != REMOVED && this._hashingStrategy.equals(object2, object))) {
            int n4 = 1 + n2 % (n - 2);
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while ((object2 = objectArray[n3]) != FREE && (object2 == REMOVED || !this._hashingStrategy.equals(object2, object)));
        }
        return object2 == FREE ? -1 : n3;
    }

    protected int insertionIndex(Object object) {
        Object[] objectArray = this._set;
        int n = objectArray.length;
        int n2 = this._hashingStrategy.computeHashCode(object) & Integer.MAX_VALUE;
        int n3 = n2 % n;
        Object object2 = objectArray[n3];
        if (object2 == FREE) {
            return n3;
        }
        if (this._hashingStrategy.equals(object2, object)) {
            return -n3 - 1;
        }
        int n4 = 1 + n2 % (n - 2);
        if (object2 != REMOVED) {
            do {
                if ((n3 -= n4) >= 0) continue;
                n3 += n;
            } while ((object2 = objectArray[n3]) != FREE && object2 != REMOVED && !this._hashingStrategy.equals(object2, object));
        }
        if (object2 == REMOVED) {
            int n5 = n3;
            while (!(object2 == FREE || object2 != REMOVED && this._hashingStrategy.equals(object2, object))) {
                if ((n3 -= n4) < 0) {
                    n3 += n;
                }
                object2 = objectArray[n3];
            }
            return object2 != FREE && object2 != REMOVED ? -n3 - 1 : n5;
        }
        return object2 != FREE && object2 != REMOVED ? -n3 - 1 : n3;
    }

    public final int computeHashCode(Object object) {
        return object == null ? 0 : object.hashCode();
    }

    public final boolean equals(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    protected final void throwObjectContractViolation(Object object, Object object2) {
        throw new IllegalArgumentException("Equal objects must have equal hashcodes. During rehashing, Trove discovered that the following two objects claim to be equal (as in java.lang.Object.equals()) but their hashCodes (or those calculated by your TObjectHashingStrategy) are not equal.This violates the general contract of java.lang.Object.hashCode().  See bullet point two in that method's documentation. object #1 =" + object + "; object #2 =" + object2);
    }
}

