/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.THash;
import java.util.ConcurrentModificationException;
import java.util.NoSuchElementException;

abstract class TIterator {
    protected final THash _hash;
    protected int _expectedSize;
    protected int _index;

    public TIterator(THash tHash) {
        this._hash = tHash;
        this._expectedSize = this._hash.size();
        this._index = this._hash.capacity();
    }

    public final boolean hasNext() {
        return this.nextIndex() >= 0;
    }

    public final void remove() {
        if (this._expectedSize != this._hash.size()) {
            throw new ConcurrentModificationException();
        }
        this._hash.removeAt(this._index);
        --this._expectedSize;
    }

    protected final void moveToNextIndex() {
        this._index = this.nextIndex();
        if (this._index < 0) {
            throw new NoSuchElementException();
        }
    }

    protected abstract int nextIndex();
}

