/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TIntHash;
import gnu.trove.TIntHashSet$1;
import gnu.trove.TIntHashSet$HashProcedure;
import gnu.trove.TIntHashingStrategy;
import gnu.trove.TIntIterator;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;

public class TIntHashSet
extends TIntHash
implements Serializable {
    static final long serialVersionUID = 1L;

    public TIntHashSet() {
    }

    public TIntHashSet(int n) {
        super(n);
    }

    public TIntHashSet(int n, float f2) {
        super(n, f2);
    }

    public TIntHashSet(int[] nArray) {
        this(nArray.length);
        this.addAll(nArray);
    }

    public TIntHashSet(TIntHashingStrategy tIntHashingStrategy) {
        super(tIntHashingStrategy);
    }

    public TIntHashSet(int n, TIntHashingStrategy tIntHashingStrategy) {
        super(n, tIntHashingStrategy);
    }

    public TIntHashSet(int n, float f2, TIntHashingStrategy tIntHashingStrategy) {
        super(n, f2, tIntHashingStrategy);
    }

    public TIntHashSet(int[] nArray, TIntHashingStrategy tIntHashingStrategy) {
        this(nArray.length, tIntHashingStrategy);
        this.addAll(nArray);
    }

    public TIntIterator iterator() {
        return new TIntIterator(this);
    }

    public boolean add(int n) {
        int n2 = this.insertionIndex(n);
        if (n2 < 0) {
            return false;
        }
        byte by = this._states[n2];
        this._set[n2] = n;
        this._states[n2] = 1;
        this.postInsertHook(by == 0);
        return true;
    }

    protected void rehash(int n) {
        int n2 = this._set.length;
        int[] nArray = this._set;
        byte[] byArray = this._states;
        this._set = new int[n];
        this._states = new byte[n];
        int n3 = n2;
        while (n3-- > 0) {
            if (byArray[n3] != 1) continue;
            int n4 = nArray[n3];
            int n5 = this.insertionIndex(n4);
            this._set[n5] = n4;
            this._states[n5] = 1;
        }
    }

    public int[] toArray() {
        int[] nArray = new int[this.size()];
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = byArray.length;
        int n2 = 0;
        while (n-- > 0) {
            if (byArray[n] != 1) continue;
            nArray[n2++] = nArray2[n];
        }
        return nArray;
    }

    public void clear() {
        super.clear();
        int[] nArray = this._set;
        byte[] byArray = this._states;
        int n = nArray.length;
        while (n-- > 0) {
            nArray[n] = 0;
            byArray[n] = 0;
        }
    }

    public boolean equals(Object object) {
        if (!(object instanceof TIntHashSet)) {
            return false;
        }
        TIntHashSet tIntHashSet = (TIntHashSet)object;
        if (tIntHashSet.size() != this.size()) {
            return false;
        }
        return this.forEach(new TIntHashSet$1(this, tIntHashSet));
    }

    public int hashCode() {
        TIntHashSet$HashProcedure tIntHashSet$HashProcedure = new TIntHashSet$HashProcedure(this, null);
        this.forEach(tIntHashSet$HashProcedure);
        return tIntHashSet$HashProcedure.getHashCode();
    }

    public boolean remove(int n) {
        int n2 = this.index(n);
        if (n2 >= 0) {
            this.removeAt(n2);
            return true;
        }
        return false;
    }

    public boolean containsAll(int[] nArray) {
        int n = nArray.length;
        while (n-- > 0) {
            if (this.contains(nArray[n])) continue;
            return false;
        }
        return true;
    }

    public boolean addAll(int[] nArray) {
        boolean bl = false;
        int n = nArray.length;
        while (n-- > 0) {
            if (!this.add(nArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean removeAll(int[] nArray) {
        boolean bl = false;
        int n = nArray.length;
        while (n-- > 0) {
            if (!this.remove(nArray[n])) continue;
            bl = true;
        }
        return bl;
    }

    public boolean retainAll(int[] nArray) {
        boolean bl = false;
        Arrays.sort(nArray);
        int[] nArray2 = this._set;
        byte[] byArray = this._states;
        int n = nArray2.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || Arrays.binarySearch(nArray, nArray2[n]) >= 0) continue;
            this.remove(nArray2[n]);
            bl = true;
        }
        return bl;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this._size);
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEach(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.setUp(n);
        while (n-- > 0) {
            int n2 = objectInputStream.readInt();
            this.add(n2);
        }
    }
}

