/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.SerializationProcedure;
import gnu.trove.TIntFunction;
import gnu.trove.TIntProcedure;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TIntArrayList
implements Serializable,
Cloneable {
    protected transient int[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 10;

    public TIntArrayList() {
        this(10);
    }

    public TIntArrayList(int n) {
        this._data = new int[n];
        this._pos = 0;
    }

    public TIntArrayList(int[] nArray) {
        this(Math.max(nArray.length, 10));
        this.add(nArray);
    }

    public void ensureCapacity(int n) {
        if (n > this._data.length) {
            int n2 = Math.max(this._data.length << 1, n);
            int[] nArray = new int[n2];
            System.arraycopy(this._data, 0, nArray, 0, this._data.length);
            this._data = nArray;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data.length > this.size()) {
            int[] nArray = new int[this.size()];
            this.toNativeArray(nArray, 0, nArray.length);
            this._data = nArray;
        }
    }

    public void add(int n) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = n;
    }

    public void add(int[] nArray) {
        this.add(nArray, 0, nArray.length);
    }

    public void add(int[] nArray, int n, int n2) {
        this.ensureCapacity(this._pos + n2);
        System.arraycopy(nArray, n, this._data, this._pos, n2);
        this._pos += n2;
    }

    public void insert(int n, int n2) {
        if (n == this._pos) {
            this.add(n2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, n, this._data, n + 1, this._pos - n);
        this._data[n] = n2;
        ++this._pos;
    }

    public void insert(int n, int[] nArray) {
        this.insert(n, nArray, 0, nArray.length);
    }

    public void insert(int n, int[] nArray, int n2, int n3) {
        if (n == this._pos) {
            this.add(nArray, n2, n3);
            return;
        }
        this.ensureCapacity(this._pos + n3);
        System.arraycopy(this._data, n, this._data, n + n3, this._pos - n);
        System.arraycopy(nArray, n2, this._data, n, n3);
        this._pos += n3;
    }

    public int get(int n) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        return this._data[n];
    }

    public int getQuick(int n) {
        return this._data[n];
    }

    public void set(int n, int n2) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        this._data[n] = n2;
    }

    public int getSet(int n, int n2) {
        if (n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        int n3 = this._data[n];
        this._data[n] = n2;
        return n3;
    }

    public void set(int n, int[] nArray) {
        this.set(n, nArray, 0, nArray.length);
    }

    public void set(int n, int[] nArray, int n2, int n3) {
        if (n < 0 || n + n3 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(nArray, n2, this._data, n, n3);
    }

    public void setQuick(int n, int n2) {
        this._data[n] = n2;
    }

    public void clear() {
        this.clear(10);
    }

    public void clear(int n) {
        this._data = new int[n];
        this._pos = 0;
    }

    public void reset() {
        this._pos = 0;
        this.fill(0);
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public int remove(int n) {
        int n2 = this.get(n);
        this.remove(n, 1);
        return n2;
    }

    public void remove(int n, int n2) {
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        if (n == 0) {
            System.arraycopy(this._data, n2, this._data, 0, this._pos - n2);
        } else if (this._pos - n2 != n) {
            System.arraycopy(this._data, n + n2, this._data, n, this._pos - (n + n2));
        }
        this._pos -= n2;
    }

    public void transformValues(TIntFunction tIntFunction) {
        int n = this._pos;
        while (n-- > 0) {
            this._data[n] = tIntFunction.execute(this._data[n]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int n, int n2) {
        if (n == n2) {
            return;
        }
        if (n > n2) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int n3 = n;
        for (int i2 = n2 - 1; n3 < i2; ++n3, --i2) {
            this.swap(n3, i2);
        }
    }

    public void shuffle(Random random) {
        int n = this._pos;
        while (n-- > 1) {
            this.swap(n, random.nextInt(n));
        }
    }

    private final void swap(int n, int n2) {
        int n3 = this._data[n];
        this._data[n] = this._data[n2];
        this._data[n2] = n3;
    }

    public Object clone() {
        TIntArrayList tIntArrayList = null;
        try {
            tIntArrayList = (TIntArrayList)super.clone();
            tIntArrayList._data = (int[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return tIntArrayList;
    }

    public int[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public int[] toNativeArray(int n, int n2) {
        int[] nArray = new int[n2];
        this.toNativeArray(nArray, n, n2);
        return nArray;
    }

    public void toNativeArray(int[] nArray, int n, int n2) {
        if (n2 == 0) {
            return;
        }
        if (n < 0 || n >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(n);
        }
        System.arraycopy(this._data, n, nArray, 0, n2);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof TIntArrayList) {
            TIntArrayList tIntArrayList = (TIntArrayList)object;
            if (tIntArrayList.size() != this.size()) {
                return false;
            }
            int n = this._pos;
            while (n-- > 0) {
                if (this._data[n] == tIntArrayList._data[n]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int n = 0;
        int n2 = this._pos;
        while (n2-- > 0) {
            n += this._data[n2];
        }
        return n;
    }

    public boolean forEach(TIntProcedure tIntProcedure) {
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (tIntProcedure.execute(this._data[i2])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TIntProcedure tIntProcedure) {
        int n = this._pos;
        while (n-- > 0) {
            if (tIntProcedure.execute(this._data[n])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        Arrays.sort(this._data, 0, this._pos);
    }

    public void sort(int n, int n2) {
        Arrays.sort(this._data, n, n2);
    }

    public void fill(int n) {
        Arrays.fill(this._data, 0, this._pos, n);
    }

    public void fill(int n, int n2, int n3) {
        if (n2 > this._pos) {
            this.ensureCapacity(n2);
            this._pos = n2;
        }
        Arrays.fill(this._data, n, n2, n3);
    }

    public int binarySearch(int n) {
        return this.binarySearch(n, 0, this._pos);
    }

    public int binarySearch(int n, int n2, int n3) {
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > this._pos) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
        int n4 = n2;
        int n5 = n3 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >> 1;
            int n7 = this._data[n6];
            if (n7 < n) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public int indexOf(int n) {
        return this.indexOf(0, n);
    }

    public int indexOf(int n, int n2) {
        for (int i2 = n; i2 < this._pos; ++i2) {
            if (this._data[i2] != n2) continue;
            return i2;
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(this._pos, n);
    }

    public int lastIndexOf(int n, int n2) {
        int n3 = n;
        while (n3-- > 0) {
            if (this._data[n3] != n2) continue;
            return n3;
        }
        return -1;
    }

    public boolean contains(int n) {
        return this.lastIndexOf(n) >= 0;
    }

    public TIntArrayList grep(TIntProcedure tIntProcedure) {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (!tIntProcedure.execute(this._data[i2])) continue;
            tIntArrayList.add(this._data[i2]);
        }
        return tIntArrayList;
    }

    public TIntArrayList inverseGrep(TIntProcedure tIntProcedure) {
        TIntArrayList tIntArrayList = new TIntArrayList();
        for (int i2 = 0; i2 < this._pos; ++i2) {
            if (tIntProcedure.execute(this._data[i2])) continue;
            tIntArrayList.add(this._data[i2]);
        }
        return tIntArrayList;
    }

    public int max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        int n = this._data[this._pos - 1];
        int n2 = this._pos - 1;
        while (n2-- > 0) {
            if (this._data[n2] <= n) continue;
            n = this._data[n2];
        }
        return n;
    }

    public int min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        int n = this._data[this._pos - 1];
        int n2 = this._pos - 1;
        while (n2-- > 0) {
            if (this._data[n2] >= n) continue;
            n = this._data[n2];
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        int n = this._pos - 1;
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(this._data[i2]);
            stringBuffer.append(", ");
        }
        if (this.size() > 0) {
            stringBuffer.append(this._data[this._pos - 1]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        SerializationProcedure serializationProcedure = new SerializationProcedure(objectOutputStream);
        if (!this.forEach(serializationProcedure)) {
            throw serializationProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this._data = new int[n];
        while (n-- > 0) {
            int n2 = objectInputStream.readInt();
            this.add(n2);
        }
    }
}

