/*
 * Decompiled with CFR 0.152.
 */
package foxtrot.workers;

import foxtrot.AbstractWorkerThread;
import foxtrot.Task;
import foxtrot.workers.DefaultWorkerThread$Link;

public class DefaultWorkerThread
extends AbstractWorkerThread
implements Runnable {
    private static final boolean debug = false;
    private Thread thread;
    private DefaultWorkerThread$Link current;

    public final void start() {
        if (this.thread != null && this.thread.isAlive()) {
            this.stop();
        }
        this.thread = new Thread((Runnable)this, this.getThreadName());
        this.thread.setDaemon(true);
        this.thread.start();
    }

    protected final String getThreadName() {
        return "Foxtrot Default Worker Thread";
    }

    private void stop() {
        this.thread.interrupt();
    }

    public final boolean isAlive() {
        if (this.thread == null) {
            return false;
        }
        return this.thread.isAlive();
    }

    public final boolean isWorkerThread() {
        return Thread.currentThread() == this.thread;
    }

    public final void postTask(Task task) {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            if (this.hasTasks()) {
                DefaultWorkerThread$Link defaultWorkerThread$Link = this.current;
                while (DefaultWorkerThread$Link.access$000(defaultWorkerThread$Link) != null) {
                    defaultWorkerThread$Link = DefaultWorkerThread$Link.access$000(defaultWorkerThread$Link);
                }
                DefaultWorkerThread$Link.access$002(defaultWorkerThread$Link, new DefaultWorkerThread$Link(task, null));
            } else {
                this.current = new DefaultWorkerThread$Link(task, null);
                this.notifyAll();
            }
        }
    }

    protected final Task takeTask() {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            while (!this.hasTasks()) {
                this.wait();
            }
            Task task = DefaultWorkerThread$Link.access$200(this.current);
            this.current = DefaultWorkerThread$Link.access$000(this.current);
            Task task2 = task;
            return task2;
        }
    }

    private boolean hasTasks() {
        DefaultWorkerThread defaultWorkerThread = this;
        synchronized (defaultWorkerThread) {
            boolean bl = this.current != null;
            return bl;
        }
    }

    protected final boolean isThreadInterrupted() {
        return this.thread.isInterrupted();
    }

    public final void run() {
        while (!this.isThreadInterrupted()) {
            try {
                Task task = this.takeTask();
                this.runTask(task);
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
    }
}

