/*
 * Decompiled with CFR 0.152.
 */
package foxtrot;

import java.security.AccessControlContext;
import java.security.AccessController;

public abstract class Task {
    private Object result;
    private Throwable throwable;
    private boolean completed;
    private AccessControlContext securityContext = AccessController.getContext();

    protected Task() {
    }

    public abstract Object run();

    final synchronized Object getResultOrThrow() {
        Throwable throwable = this.getThrowable();
        if (throwable != null) {
            if (throwable instanceof Exception) {
                throw (Exception)throwable;
            }
            throw (Error)throwable;
        }
        return this.getResult();
    }

    private final synchronized Object getResult() {
        return this.result;
    }

    final synchronized void setResult(Object object) {
        this.result = object;
    }

    final synchronized Throwable getThrowable() {
        return this.throwable;
    }

    final synchronized void setThrowable(Throwable throwable) {
        this.throwable = throwable;
    }

    public final synchronized boolean isCompleted() {
        return this.completed;
    }

    final synchronized void setCompleted(boolean bl) {
        this.completed = bl;
        if (bl) {
            this.notifyAll();
        }
    }

    final synchronized AccessControlContext getSecurityContext() {
        return this.securityContext;
    }

    final synchronized void reset() {
        this.setResult(null);
        this.setThrowable(null);
        this.setCompleted(false);
    }
}

