/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.xchoosers;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateFactory;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.xbench.core.ObjectBindery;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.searchers.GeneSearchList;
import edu.mit.broad.xbench.xchoosers.TemplateCreatorWidgets$GenePhenotype$1;
import edu.mit.broad.xbench.xchoosers.TemplateCreatorWidgets$GenePhenotype$2;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class TemplateCreatorWidgets$GenePhenotype
extends JPanel {
    private GeneSearchList geneSearch;
    private JComboBox cbDataset;
    private Template createdTemplate;

    public TemplateCreatorWidgets$GenePhenotype() {
        this.jbInit();
    }

    private void jbInit() {
        this.geneSearch = new GeneSearchList();
        this.geneSearch.getJList().setVisibleRowCount(50);
        this.geneSearch.getJList().setSelectionMode(0);
        this.setLayout(new BorderLayout(10, 10));
        this.add((Component)this.geneSearch.getComponent(), "Center");
        JPanel jPanel = new JPanel(new BorderLayout());
        JButton jButton = new JButton("Apply to dataset");
        jButton.addActionListener(new TemplateCreatorWidgets$GenePhenotype$1(this));
        jPanel.add((Component)jButton, "East");
        this.cbDataset = new JComboBox();
        this.cbDataset.setBorder(BorderFactory.createTitledBorder("Dataset"));
        GuiHelper.safeSelect(this.cbDataset);
        this.cbDataset.addActionListener(new TemplateCreatorWidgets$GenePhenotype$2(this));
        this.cbDataset.setEditable(false);
        ObjectBindery.bind(this.cbDataset, new Class[]{Dataset.class}, false);
        jPanel.add((Component)this.cbDataset, "Center");
        this.add((Component)jPanel, "South");
    }

    private void createTemplate() {
        try {
            Object e2 = this.geneSearch.getJList().getSelectedValue();
            if (e2 == null) {
                Application.getWindowManager().showMessage("First select a gene, then apply");
                return;
            }
            Object object = this.cbDataset.getSelectedItem();
            if (object == null) {
                Application.getWindowManager().showMessage("No dataset available. First import a dataset and then apply this phenotype");
                return;
            }
            File file = Application.getVdbManager().getDefaultOutputDir();
            Dataset dataset = (Dataset)object;
            String string = e2.toString();
            String string2 = string + "_profile_in_" + dataset.getName() + ".cls";
            File file2 = NamingConventions.createSafeFile(file, string2);
            this.createdTemplate = TemplateFactory.createContinuousTemplate(string, dataset);
            ParserFactory.save(this.createdTemplate, file2);
            Application.getWindowManager().showMessage("Successfully made template: " + this.createdTemplate.getName());
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError("Trouble making template", throwable);
        }
    }

    public final Template getTemplate() {
        if (this.createdTemplate == null) {
            throw new IllegalArgumentException("No template was yet created");
        }
        return this.createdTemplate;
    }

    static final /* synthetic */ void access$100(TemplateCreatorWidgets$GenePhenotype templateCreatorWidgets$GenePhenotype) {
        templateCreatorWidgets$GenePhenotype.createTemplate();
    }

    static final /* synthetic */ JComboBox access$200(TemplateCreatorWidgets$GenePhenotype templateCreatorWidgets$GenePhenotype) {
        return templateCreatorWidgets$GenePhenotype.cbDataset;
    }

    static final /* synthetic */ GeneSearchList access$300(TemplateCreatorWidgets$GenePhenotype templateCreatorWidgets$GenePhenotype) {
        return templateCreatorWidgets$GenePhenotype.geneSearch;
    }
}

