/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.utils.DateUtils;
import edu.mit.broad.xbench.tui.ReportStub;
import java.awt.Color;
import java.awt.Component;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import xtools.api.Tool;
import xtools.api.ToolCategory;

public class ToolSelectorTree$Renderer
extends DefaultTreeCellRenderer {
    private static final Icon ICON_RPT_SMALL = JarResources.getIcon("Rpt15.png");

    @Override
    public final Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
        if (object instanceof DefaultMutableTreeNode) {
            Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
            this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
            this.setFont(GuiHelper.FONT_DEFAULT);
            if (object2 instanceof ToolCategory) {
                this.setFont(GuiHelper.FONT_DEFAULT_BOLD);
                this.setBorder(null);
                this.setText(((ToolCategory)object2).getName());
                this.setToolTipText(((ToolCategory)object2).getDesc());
                this.setIcon(((ToolCategory)object2).getIcon());
            } else if (object2 instanceof Tool) {
                StringTokenizer stringTokenizer = new StringTokenizer(((Tool)object2).getName(), ".");
                String string = null;
                while (stringTokenizer.hasMoreTokens()) {
                    string = stringTokenizer.nextToken();
                }
                this.setText(string);
                this.setIcon(Tool.ICON);
                this.setToolTipText(((Tool)object2).getDesc());
            } else if (object2 instanceof Report) {
                Report report = (Report)object2;
                this.prettyFormat(report, (JLabel)this);
                this.setToolTipText(report.getQuickInfo());
            } else if (object2 instanceof ReportStub) {
                ReportStub reportStub = (ReportStub)object2;
                this.prettyFormat(reportStub, (JLabel)this);
            } else {
                this.setBorder(null);
                this.setText(object.toString());
            }
        } else {
            this.setText("Unknown: " + object);
        }
        return this;
    }

    private final void prettyFormat(ReportStub reportStub, JLabel jLabel) {
        StringBuffer stringBuffer = new StringBuffer("<html><body>");
        stringBuffer.append(reportStub.getName_without_ts());
        stringBuffer.append("<font color=gray>");
        stringBuffer.append('[').append(reportStub.getHourMin()).append(']');
        stringBuffer.append("</font>");
        stringBuffer.append("</body></html>");
        jLabel.setIcon(ICON_RPT_SMALL);
        jLabel.setText(stringBuffer.toString());
        jLabel.setBorder(null);
    }

    private final void prettyFormat(Report report, JLabel jLabel) {
        StringBuffer stringBuffer = new StringBuffer("<html><body>");
        stringBuffer.append(report.getName());
        stringBuffer.append("<font color=gray>");
        stringBuffer.append('[').append(DateUtils.toHourMin(report.getTimestamp())).append("min").append(']');
        stringBuffer.append("</font>");
        stringBuffer.append("</body></html>");
        jLabel.setIcon(ICON_RPT_SMALL);
        jLabel.setText(stringBuffer.toString());
        jLabel.setBorder(null);
    }
}

