/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.utils.DateUtils;
import java.io.File;

public class ReportStub {
    private String fName;
    private long fTimestamp;
    private File fReportFile;
    private Report fReport;
    private String fTsLessName;

    public ReportStub(File file) {
        this.fReportFile = file;
        this.fName = this.fReportFile.getName();
        Object[] objectArray = NamingConventions.parseReportTimestampFromName(this.fName);
        this.fTimestamp = (Long)objectArray[1];
        this.fTsLessName = objectArray[0].toString();
    }

    public final String getName() {
        return this.fName;
    }

    public final String getName_without_ts() {
        return this.fTsLessName;
    }

    public final long getTimestamp() {
        return this.fTimestamp;
    }

    public final File getReportFile() {
        return this.fReportFile;
    }

    public final Report getReport(boolean bl) {
        if (this.fReport == null) {
            this.fReport = ParserFactory.readReport(this.fReportFile, bl);
        }
        return this.fReport;
    }

    public final String getHourMin() {
        return DateUtils.toHourMin(this.fTimestamp) + "min";
    }
}

