/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.tui;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.swing.GradientPanel;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.VerticalFlowLayout;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GFieldPlusChooser;
import edu.mit.broad.xbench.tui.ParamSetDisplay;
import edu.mit.broad.xbench.tui.ParamSetFormDisplay$1;
import edu.mit.broad.xbench.tui.ParamSetFormDisplay$2;
import edu.mit.broad.xbench.tui.ParamSetFormDisplay$3;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.MouseMotionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import org.apache.log4j.Logger;
import xtools.api.param.Param;
import xtools.api.param.ParamSet;
import xtools.api.param.ReportDirParam;
import xtools.api.param.ReportLabelParam;

public class ParamSetFormDisplay
implements ParamSetDisplay {
    private Logger log = XLogger.getLogger(ParamSetFormDisplay.class);
    private ParamSet fParamSet;
    private String fTitle;
    private Icon fIcon;
    private JPanel fBasePanel;
    private boolean fShowBasic;
    private boolean fShowAdvanced;
    private JButton bBasic;
    private JButton bAdvanced;
    private static final Color LIGHT_GREEN = Color.decode("#EAFFEA");
    private static final int DEFAULT_INITIAL_DELAY = ToolTipManager.sharedInstance().getInitialDelay();
    private MouseMotionListener fMouseListener;

    public ParamSetFormDisplay(String string, Icon icon, ParamSet paramSet, MouseMotionListener mouseMotionListener) {
        if (paramSet == null) {
            throw new IllegalArgumentException("Null pset param not allowed");
        }
        this.fTitle = string;
        this.fIcon = icon;
        this.fParamSet = paramSet;
        this.fMouseListener = mouseMotionListener;
        if (paramSet.getNumParams() > 10) {
            this.fShowBasic = false;
            this.fShowAdvanced = false;
        } else {
            this.fShowBasic = true;
            this.fShowAdvanced = true;
        }
        this.jbInit();
    }

    private void jbInit() {
        VerticalFlowLayout verticalFlowLayout = new VerticalFlowLayout();
        verticalFlowLayout.setVgap(0);
        this.fBasePanel = new JPanel(verticalFlowLayout);
        this.fBasePanel.addMouseMotionListener(this.fMouseListener);
        this.bBasic = new JButton();
        this.bBasic.setSize(10, 10);
        this.bAdvanced = new JButton();
        this.bAdvanced.setSize(10, 10);
        this.buildPanel();
        this.bBasic.addActionListener(new ParamSetFormDisplay$1(this));
        this.bAdvanced.addActionListener(new ParamSetFormDisplay$2(this));
    }

    private Param[] _getAllReqd() {
        int n;
        Param[] paramArray = this.fParamSet.getParams(Param.REQUIRED, true);
        Param[] paramArray2 = this.fParamSet.getParams(Param.PSEUDO_REQUIRED, true);
        Param[] paramArray3 = new Param[paramArray.length + paramArray2.length];
        Param param = null;
        int n2 = 0;
        for (n = 0; n < paramArray.length; ++n) {
            if (paramArray[n] instanceof ReportDirParam) {
                param = paramArray[n];
                continue;
            }
            paramArray3[n2++] = paramArray[n];
        }
        for (n = 0; n < paramArray2.length; ++n) {
            paramArray3[n2++] = paramArray2[n];
        }
        if (param != null) {
            paramArray3[n2] = param;
        }
        return paramArray3;
    }

    private Param[] _orderBasic(Param[] paramArray) {
        int n;
        ArrayList<Param> arrayList = new ArrayList<Param>();
        for (n = 0; n < paramArray.length; ++n) {
            if (!(paramArray[n] instanceof ReportLabelParam)) continue;
            arrayList.add(paramArray[n]);
        }
        for (n = 0; n < paramArray.length; ++n) {
            if (paramArray[n] instanceof ReportLabelParam) continue;
            arrayList.add(paramArray[n]);
        }
        return arrayList.toArray(new Param[arrayList.size()]);
    }

    protected final Color getHeaderBackground() {
        return GuiHelper.COLOR_LIGHT_BLUE;
    }

    private void buildPanel() {
        this.fBasePanel.removeAll();
        GradientPanel gradientPanel = new GradientPanel((LayoutManager)new BorderLayout(), this.getHeaderBackground());
        JLabel jLabel = new JLabel(this.fTitle, this.fIcon, 10);
        jLabel.setForeground(Color.white);
        jLabel.setOpaque(false);
        gradientPanel.add((Component)jLabel, "West");
        gradientPanel.setBorder(BorderFactory.createEmptyBorder(3, 4, 3, 1));
        this.fBasePanel.add(gradientPanel);
        this.fBasePanel.add(this.createReqdParamsPanel(this._getAllReqd()));
        Param[] paramArray = this.fParamSet.getParams(Param.BASIC, true);
        paramArray = this._orderBasic(paramArray);
        this.fBasePanel.add(this.createBasicParamsPanel(paramArray));
        this.fBasePanel.add(this.createAdvancedParamsPanel(this.fParamSet.getParams(Param.ADVANCED, true)));
        this.fBasePanel.revalidate();
        this.fBasePanel.repaint();
    }

    private JPanel createReqdParamsPanel(Param[] paramArray) {
        StringBuffer stringBuffer = ParamSetFormDisplay._createColStr();
        StringBuffer stringBuffer2 = ParamSetFormDisplay._createRowStr(paramArray);
        PanelBuilder panelBuilder = ParamSetFormDisplay._createPanelBuilder(stringBuffer, stringBuffer2);
        CellConstraints cellConstraints = new CellConstraints();
        panelBuilder.addSeparator("Required fields", cellConstraints.xyw(1, 1, 4));
        int n = 3;
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            GFieldPlusChooser gFieldPlusChooser = paramArray[i2].getSelectionComponent();
            if (paramArray[i2].isFileBased() && gFieldPlusChooser instanceof GDirFieldPlusChooser) {
                ((GDirFieldPlusChooser)gFieldPlusChooser).getTextField().setBackground(LIGHT_GREEN);
            }
            JLabel jLabel = new JLabel(paramArray[i2].getHtmlLabel_v2());
            ParamSetFormDisplay.enableToolTips(jLabel, paramArray[i2]);
            panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n));
            panelBuilder.add((Component)gFieldPlusChooser.getComponent(), cellConstraints.xy(3, n));
            n += 2;
        }
        return panelBuilder.getPanel();
    }

    private JPanel createBasicParamsPanel(Param[] paramArray) {
        int n;
        StringBuffer stringBuffer = ParamSetFormDisplay._createColStr();
        StringBuffer stringBuffer2 = ParamSetFormDisplay._createRowStr(paramArray);
        PanelBuilder panelBuilder = ParamSetFormDisplay._createPanelBuilder(stringBuffer, stringBuffer2);
        CellConstraints cellConstraints = new CellConstraints();
        if (this.fShowBasic) {
            this.bBasic.setText("Hide");
            n = 3;
        } else {
            this.bBasic.setText("Show");
            n = 3;
        }
        if (paramArray.length == 0) {
            panelBuilder.addSeparator("Basic fields - none available", cellConstraints.xyw(1, 1, n));
            return panelBuilder.getPanel();
        }
        panelBuilder.add((Component)this.bBasic, cellConstraints.xy(5, 1));
        panelBuilder.addSeparator("Basic fields", cellConstraints.xyw(1, 1, n));
        if (this.fShowBasic) {
            int n2 = 3;
            for (int i2 = 0; i2 < paramArray.length; ++i2) {
                GFieldPlusChooser gFieldPlusChooser = paramArray[i2].getSelectionComponent();
                if (paramArray[i2] instanceof ReportLabelParam) {
                    gFieldPlusChooser.getComponent().setBackground(GuiHelper.COLOR_LIGHT_YELLOW);
                }
                JLabel jLabel = new JLabel(paramArray[i2].getHtmlLabel_v2());
                ParamSetFormDisplay.enableToolTips(jLabel, paramArray[i2]);
                panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n2));
                panelBuilder.add((Component)gFieldPlusChooser.getComponent(), cellConstraints.xy(3, n2));
                n2 += 2;
            }
        }
        return panelBuilder.getPanel();
    }

    private static void enableToolTips(JLabel jLabel, Param param) {
        jLabel.setToolTipText(param.getDesc());
        jLabel.addMouseListener(new ParamSetFormDisplay$3());
    }

    private JPanel createAdvancedParamsPanel(Param[] paramArray) {
        int n;
        StringBuffer stringBuffer = ParamSetFormDisplay._createColStr();
        StringBuffer stringBuffer2 = ParamSetFormDisplay._createRowStr(paramArray);
        PanelBuilder panelBuilder = ParamSetFormDisplay._createPanelBuilder(stringBuffer, stringBuffer2);
        CellConstraints cellConstraints = new CellConstraints();
        if (this.fShowAdvanced) {
            this.bAdvanced.setText("Hide");
            n = 3;
        } else {
            this.bAdvanced.setText("Show");
            n = 3;
        }
        if (paramArray.length == 0) {
            panelBuilder.addSeparator("Advanced fields - none available", cellConstraints.xyw(1, 1, n));
            return panelBuilder.getPanel();
        }
        panelBuilder.addSeparator("Advanced fields", cellConstraints.xyw(1, 1, n));
        panelBuilder.add((Component)this.bAdvanced, cellConstraints.xy(5, 1));
        if (this.fShowAdvanced) {
            int n2 = 3;
            for (int i2 = 0; i2 < paramArray.length; ++i2) {
                GFieldPlusChooser gFieldPlusChooser = paramArray[i2].getSelectionComponent();
                JLabel jLabel = new JLabel(paramArray[i2].getHtmlLabel_v2());
                ParamSetFormDisplay.enableToolTips(jLabel, paramArray[i2]);
                panelBuilder.add((Component)jLabel, cellConstraints.xy(1, n2));
                panelBuilder.add((Component)gFieldPlusChooser.getComponent(), cellConstraints.xy(3, n2));
                n2 += 2;
            }
        }
        return panelBuilder.getPanel();
    }

    @Override
    public final void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
    }

    @Override
    public final Component getAsComponent() {
        return this.fBasePanel;
    }

    @Override
    public final void reset() {
        this.log.debug("Resetting params to defaults");
        for (int i2 = 0; i2 < this.fParamSet.getNumParams(); ++i2) {
            Param param = this.fParamSet.getParam(i2);
            Object object = param.getDefault();
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                StringBuffer stringBuffer = new StringBuffer();
                for (int i3 = 0; i3 < objectArray.length; ++i3) {
                    stringBuffer.append(objectArray[i3].toString());
                    if (i3 == objectArray.length - 1) continue;
                    stringBuffer.append(',');
                }
                param.getSelectionComponent().setValue(stringBuffer.toString());
                continue;
            }
            param.getSelectionComponent().setValue(object);
        }
        this.buildPanel();
    }

    @Override
    public final void set(ParamSet paramSet) {
        this.log.debug("Resetting params to new pset: " + paramSet);
        this.buildPanel();
    }

    private static Object _toObj(Object object) {
        if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            StringBuffer stringBuffer = new StringBuffer();
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                stringBuffer.append(objectArray[i2].toString());
                if (i2 == objectArray.length - 1) continue;
                stringBuffer.append(',');
            }
            return stringBuffer.toString();
        }
        return object;
    }

    private static StringBuffer _createColStr() {
        return new StringBuffer("130dlu,      4dlu,        225dlu,   4dlu,  40dlu");
    }

    private static StringBuffer _createRowStr(Param[] paramArray) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("pref, 5dlu,");
        for (int i2 = 0; i2 < paramArray.length; ++i2) {
            stringBuffer.append("pref, 3dlu");
            if (paramArray.length == i2 - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer;
    }

    private static PanelBuilder _createPanelBuilder(StringBuffer stringBuffer, StringBuffer stringBuffer2) {
        FormLayout formLayout = new FormLayout(stringBuffer.toString(), stringBuffer2.toString());
        PanelBuilder panelBuilder = new PanelBuilder(formLayout);
        panelBuilder.setDefaultDialogBorder();
        return panelBuilder;
    }

    static final /* synthetic */ boolean access$002(ParamSetFormDisplay paramSetFormDisplay, boolean bl) {
        paramSetFormDisplay.fShowBasic = bl;
        return paramSetFormDisplay.fShowBasic;
    }

    static final /* synthetic */ boolean access$000(ParamSetFormDisplay paramSetFormDisplay) {
        return paramSetFormDisplay.fShowBasic;
    }

    static final /* synthetic */ void access$100(ParamSetFormDisplay paramSetFormDisplay) {
        paramSetFormDisplay.buildPanel();
    }

    static final /* synthetic */ boolean access$202(ParamSetFormDisplay paramSetFormDisplay, boolean bl) {
        paramSetFormDisplay.fShowAdvanced = bl;
        return paramSetFormDisplay.fShowAdvanced;
    }

    static final /* synthetic */ boolean access$200(ParamSetFormDisplay paramSetFormDisplay) {
        return paramSetFormDisplay.fShowAdvanced;
    }

    static final /* synthetic */ int access$300() {
        return DEFAULT_INITIAL_DELAY;
    }
}

