/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.objmgr;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.io.FileTransferable;
import edu.mit.broad.genome.io.PobTransferable;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GuiHelper$Tree;
import edu.mit.broad.genome.swing.dnd.DragSourceDecorator;
import edu.mit.broad.xbench.actions.misc_actions.CopyFileNamesAction;
import edu.mit.broad.xbench.actions.misc_actions.CopyFilesAction;
import edu.mit.broad.xbench.explorer.objmgr.AbstractObjectTree;
import edu.mit.broad.xbench.explorer.objmgr.ObjectTreePopup;
import edu.mit.broad.xbench.explorer.objmgr.ObjectTreeRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.datatransfer.Transferable;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.border.TitledBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class ObjectTree
extends AbstractObjectTree {
    private static final Logger klog = XLogger.getLogger(ObjectTree.class);

    public ObjectTree() {
        this.setToolTipText("Anything but null");
        this.setModel(ParserFactory.getCache().createTreeModel());
        this.setCellRenderer(new ObjectTreeRenderer());
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, "Double click to open, right click for more options", 0, 2, new Font("Helvetica", 0, 10), Color.GRAY);
        this.setBorder(titledBorder);
        this.addMouseListener(new ObjectTreePopup(this));
        this.getSelectionModel().setSelectionMode(4);
        this.setRootVisible(true);
        this.setShowsRootHandles(true);
        this.expandAll();
        new DragSourceDecorator(this);
        CopyFilesAction copyFilesAction = new CopyFilesAction(this);
        this.addKeyListener(copyFilesAction.createCtrlCKeyListener());
        CopyFileNamesAction copyFileNamesAction = new CopyFileNamesAction(this);
        this.addKeyListener(copyFileNamesAction.createCtrlZKeyListener());
    }

    private void expandAll() {
        try {
            TreePath treePath = this.getPathForRow(0);
            if (treePath == null) {
                return;
            }
            GuiHelper$Tree.expandAll(this, treePath);
        }
        catch (Throwable throwable) {
            klog.warn("develop error -- ignoring", throwable);
        }
    }

    @Override
    public final Transferable getTransferable() {
        PersistentObject[] persistentObjectArray = this.getSelectedPobs();
        if (persistentObjectArray != null) {
            return new PobTransferable(persistentObjectArray);
        }
        return null;
    }

    @Override
    public final Component getDraggableComponent() {
        return this;
    }

    private PersistentObject[] getSelectedPobs() {
        TreePath[] treePathArray = this.getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < treePathArray.length; ++i2) {
            Object object;
            DefaultMutableTreeNode defaultMutableTreeNode;
            Object object2 = treePathArray[i2].getLastPathComponent();
            if (!(object2 instanceof DefaultMutableTreeNode) || (defaultMutableTreeNode = (DefaultMutableTreeNode)object2).getAllowsChildren() || !((object = defaultMutableTreeNode.getUserObject()) instanceof PersistentObject)) continue;
            arrayList.add(object);
        }
        return arrayList.toArray(new PersistentObject[arrayList.size()]);
    }

    @Override
    public final FileTransferable getSelectedFiles() {
        return new FileTransferable(this.getTheSelectedFiles());
    }

    @Override
    public final String getSelectedFileNames() {
        return ((FileTransferable)this.getTransferable()).getFileNames();
    }

    private File[] getTheSelectedFiles() {
        ArrayList<File> arrayList = new ArrayList<File>();
        PersistentObject[] persistentObjectArray = this.getSelectedPobs();
        for (int i2 = 0; i2 < persistentObjectArray.length; ++i2) {
            File file = ParserFactory.getCache().getSourceFile(persistentObjectArray[i2]);
            if (file == null) continue;
            arrayList.add(file);
        }
        return arrayList.toArray(new File[arrayList.size()]);
    }

    @Override
    public final Component getDisplayComponent() {
        return null;
    }

    @Override
    public final void refresh() {
    }
}

