/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.explorer.filemgr;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.parsers.DataFormat;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.explorer.filemgr.XFileChooser;
import edu.mit.broad.xbench.explorer.filemgr.XFileChooserImpl$1;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.apache.log4j.Logger;
import xapps.gsea.GseaAppConf;

public class XFileChooserImpl
extends JFileChooser
implements XFileChooser {
    private Logger log = XLogger.getLogger(XFileChooserImpl.class);

    public XFileChooserImpl(JList jList) {
        this.initHere(null, jList);
    }

    public XFileChooserImpl(JList jList, JList jList2) {
        this.initHere(jList, jList2);
    }

    private void initHere(JList jList, JList jList2) {
        this.setMouseListener(jList2);
        if (jList != null) {
            this.setMouseListener(jList);
        }
        super.setAcceptAllFileFilterUsed(true);
        super.setMultiSelectionEnabled(true);
        super.setFileView(DataFormat.getParsableFileView());
        super.addChoosableFileFilter(GseaAppConf.createGseaFileFilter());
        this.setFileSelectionMode(2);
        Dimension dimension = new Dimension(650, 450);
        super.setPreferredSize(dimension);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setPreferredSize(new Dimension(dimension.width - 250, dimension.height));
        if (jList == null) {
            jPanel.setBorder(BorderFactory.createTitledBorder("Recent folders (double click to list content)"));
            jPanel.add((Component)new JScrollPane(jList2), "Center");
        } else {
            JScrollPane jScrollPane = new JScrollPane(jList2);
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Recent folders (double click to list content)"));
            jPanel.add((Component)jScrollPane, "Center");
            jScrollPane = new JScrollPane(jList);
            jScrollPane.setPreferredSize(new Dimension(dimension.width - 250, 150));
            jScrollPane.setBorder(BorderFactory.createTitledBorder("Application folders"));
            jPanel.add((Component)jScrollPane, "South");
        }
        super.setAccessory(jPanel);
    }

    private void setMouseListener(JList jList) {
        jList.addMouseListener(new XFileChooserImpl$1(this, jList));
    }

    @Override
    public final void setCurrentLocation(File file) {
        if (file.isDirectory()) {
            super.setCurrentDirectory(file);
        } else {
            super.setSelectedFile(file);
        }
    }

    @Override
    public final void setCurrentLocation(String string) {
        this.setCurrentLocation(new File(string));
    }

    @Override
    public final void setApproveButtonText(String string) {
        super.setApproveButtonText(string);
    }

    @Override
    public final boolean showOpenDialog() {
        int n = super.showOpenDialog(Application.getWindowManager().getRootFrame());
        return n == 0;
    }

    @Override
    public final boolean showSaveDialog() {
        int n = super.showSaveDialog(Application.getWindowManager().getRootFrame());
        return n == 0;
    }
}

