/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core.api;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.genome.utils.SystemUtils;
import edu.mit.broad.vdb.sampledb.SampleAnnot;
import edu.mit.broad.xbench.core.api.DescriptedFile;
import edu.mit.broad.xbench.core.api.VdbManager;
import edu.mit.broad.xbench.prefs.XPreferencesFactory;
import java.io.File;
import org.apache.log4j.Logger;

public class VdbManagerImpl
implements VdbManager {
    private String fBuildDate;
    private static final Logger klog = XLogger.getLogger(VdbManagerImpl.class);

    public VdbManagerImpl(String string) {
        this.fBuildDate = string;
    }

    @Override
    public final File getRuntimeHomeDir() {
        return XPreferencesFactory.kAppRuntimeHomeDir;
    }

    @Override
    public final DescriptedFile[] getDescriptedFiles() {
        return new DescriptedFile[]{new DescriptedFile(this.getDefaultOutputDir(), "OUTPUT"), new DescriptedFile(this.getRuntimeHomeDir(), "HOME"), new DescriptedFile(this.getExamplesDir(), "EXAMPLES"), new DescriptedFile(this.getTmpDir(), "TMP")};
    }

    @Override
    public final File getTmpDir() {
        return VdbManagerImpl._mkdir(new File(this.getRuntimeHomeDir(), "tmp"));
    }

    @Override
    public final File getExamplesDir() {
        return VdbManagerImpl._mkdir(new File(this.getRuntimeHomeDir(), "xexamples"));
    }

    @Override
    public final File getTestDataDir() {
        return VdbManagerImpl._mkdir(new File(this.getRuntimeHomeDir(), "test"));
    }

    @Override
    public final File getReportsCacheDir() {
        return VdbManagerImpl._mkdir(new File(this.getRuntimeHomeDir(), "reports_cache_" + this.fBuildDate));
    }

    @Override
    public final File getDatabasesDir() {
        return VdbManagerImpl._mkdir(new File(this._tweakAppRuntimeDir_hack(), "databases"));
    }

    public final File getChip2ChipDir() {
        return VdbManagerImpl._mkdir(new File(this._tweakAppRuntimeDir_hack(), "chip2chip"));
    }

    @Override
    public final File getDefaultOutputDir() {
        File file = SystemUtils.getPwd();
        String string = NamingConventions.createNiceEnglishDate_for_dirs();
        return VdbManagerImpl._mkdir(new File(file, string));
    }

    private static File _mkdir(File file) {
        if (!file.exists()) {
            boolean bl = file.mkdir();
            if (!bl) {
                klog.fatal("Could not make dir: " + file);
            } else {
                klog.info("Made Vdb dir JIT: " + file);
            }
        }
        return file;
    }

    private File _tweakAppRuntimeDir_hack() {
        File file = new File("Y:/vdb/");
        if (file.exists()) {
            return file;
        }
        file = new File("/xchip/projects/vdb/");
        if (file.exists()) {
            return file;
        }
        return this.getRuntimeHomeDir();
    }

    @Override
    public final SampleAnnot getDefaultSampleAnnot() {
        throw new NotImplementedException();
    }

    @Override
    public final GenesOfInterest getDefaultGenesOfInterest() {
        return null;
    }
}

