/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.core;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.Metric;
import edu.mit.broad.genome.alg.Metrics;
import edu.mit.broad.genome.math.Order;
import edu.mit.broad.genome.math.SortMode;
import edu.mit.broad.genome.objects.Dataset;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.objects.HClustDatasetStanford;
import edu.mit.broad.genome.objects.PersistentObject;
import edu.mit.broad.genome.objects.Template;
import edu.mit.broad.genome.objects.TemplateMode;
import edu.mit.broad.genome.objects.esmatrix.db.EnrichmentDb;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.genome.swing.GLabelledItemPanel;
import edu.mit.broad.genome.swing.fields.GColorFieldPlusChooser;
import edu.mit.broad.genome.swing.fields.GDirFieldPlusChooser;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.xbench.RendererFactory2$CommonLookAndDoubleClickListRenderer;
import edu.mit.broad.xbench.RendererFactory2$CommonLookListRenderer;
import edu.mit.broad.xbench.core.ApplicationDialog;
import edu.mit.broad.xbench.core.ObjectBindery$1;
import edu.mit.broad.xbench.core.api.Application;
import edu.mit.broad.xbench.xchoosers.TemplateComboBoxModel;
import java.awt.Color;
import java.io.File;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.apache.log4j.Logger;

public class ObjectBindery {
    private static final Logger klog = XLogger.getLogger(ObjectBindery.class);

    private ObjectBindery() {
    }

    public static final JComboBox createMetricsBox() {
        return new JComboBox<Metric>(Metrics.createAllMetrics());
    }

    public static final JComboBox createSortModeBox() {
        return new JComboBox<SortMode>(SortMode.ALL);
    }

    public static final JComboBox createOrderBox() {
        return new JComboBox<Order>(Order.ALL);
    }

    public static final void bind(JComboBox jComboBox, Class[] classArray, boolean bl) {
        if (jComboBox == null) {
            throw new IllegalArgumentException("param cb cannot be null");
        }
        ComboBoxModel comboBoxModel = ParserFactory.getCache().createBoxModel(classArray, bl);
        jComboBox.setModel(comboBoxModel);
        jComboBox.setRenderer(new RendererFactory2$CommonLookListRenderer());
    }

    public static final void bind(JComboBox jComboBox, Class clazz) {
        if (jComboBox == null) {
            throw new IllegalArgumentException("param cb cannot be null");
        }
        if (clazz == null) {
            throw new IllegalArgumentException("Parameter cl cannot be null");
        }
        DefaultComboBoxModel<Chip> defaultComboBoxModel = clazz == Chip.class ? new DefaultComboBoxModel<Chip>(VdbRuntimeResources.getChips_All_safe()) : ParserFactory.getCache().createBoxModel(clazz);
        jComboBox.setModel(defaultComboBoxModel);
        jComboBox.setRenderer(new RendererFactory2$CommonLookListRenderer());
    }

    public static final void bindTemplate(JComboBox jComboBox, TemplateMode templateMode) {
        if (jComboBox == null) {
            throw new IllegalArgumentException("param cb cannot be null");
        }
        ComboBoxModel comboBoxModel = ParserFactory.getCache().createBoxModel(Template.class);
        TemplateComboBoxModel templateComboBoxModel = new TemplateComboBoxModel(comboBoxModel, templateMode);
        jComboBox.setModel(templateComboBoxModel);
        jComboBox.setRenderer(new RendererFactory2$CommonLookListRenderer());
    }

    public static final void bind(JList jList, Class clazz) {
        if (jList == null) {
            throw new IllegalArgumentException("param jl cannot be null");
        }
        DefaultComboBoxModel<Chip> defaultComboBoxModel = clazz == Chip.class ? new DefaultComboBoxModel<Chip>(VdbRuntimeResources.getChips_All_safe()) : ParserFactory.getCache().createBoxModel(clazz);
        jList.setModel(defaultComboBoxModel);
        if (jList.getModel().getSize() > 0) {
            jList.setSelectedIndex(0);
        }
        jList.setCellRenderer(new RendererFactory2$CommonLookAndDoubleClickListRenderer(jList));
    }

    public static final void bind(JList jList, Class[] classArray) {
        if (jList == null) {
            throw new IllegalArgumentException("param jl cannot be null");
        }
        ComboBoxModel comboBoxModel = ParserFactory.getCache().createBoxModel(classArray, false);
        jList.setModel(comboBoxModel);
        if (jList.getModel().getSize() > 0) {
            jList.setSelectedIndex(0);
        }
        jList.setCellRenderer(new RendererFactory2$CommonLookAndDoubleClickListRenderer(jList));
    }

    public static final ComboBoxModel getModel(Class[] classArray) {
        return ParserFactory.getCache().createBoxModel(classArray, false);
    }

    public static final ComboBoxModel getModel(Class clazz) {
        return ParserFactory.getCache().createBoxModel(clazz);
    }

    public static final ComboBoxModel getHackAuxGeneSetsBoxModel() {
        return ParserFactory.getCache().hackCreateAuxGeneSetsBoxModel();
    }

    public static final Dataset[] showDatasetChooser(boolean bl) {
        Object[] objectArray = ObjectBindery._showChooser(bl, Dataset.class, "Select Dataset");
        if (objectArray != null) {
            Dataset[] datasetArray = new Dataset[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                datasetArray[i2] = (Dataset)objectArray[i2];
            }
            return datasetArray;
        }
        return null;
    }

    public static final Dataset showDatasetChooser() {
        Dataset[] datasetArray = ObjectBindery.showDatasetChooser(false);
        if (datasetArray != null && datasetArray.length > 0) {
            return datasetArray[0];
        }
        return null;
    }

    public static final HClustDatasetStanford[] showHClustDatasetChooser(boolean bl) {
        Object[] objectArray = ObjectBindery._showChooser(bl, HClustDatasetStanford.class, "Select HClust Dataset (cdt)");
        if (objectArray != null) {
            HClustDatasetStanford[] hClustDatasetStanfordArray = new HClustDatasetStanford[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                hClustDatasetStanfordArray[i2] = (HClustDatasetStanford)objectArray[i2];
            }
            return hClustDatasetStanfordArray;
        }
        return null;
    }

    public static final HClustDatasetStanford showHClustDatasetChooser() {
        HClustDatasetStanford[] hClustDatasetStanfordArray = ObjectBindery.showHClustDatasetChooser(false);
        if (hClustDatasetStanfordArray != null && hClustDatasetStanfordArray.length > 0) {
            return hClustDatasetStanfordArray[0];
        }
        return null;
    }

    public static final EnrichmentDb[] showEdbChooser(boolean bl) {
        Object[] objectArray = ObjectBindery._showChooser(bl, EnrichmentDb.class, "Select Enrichment Database");
        if (objectArray != null) {
            EnrichmentDb[] enrichmentDbArray = new EnrichmentDb[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                enrichmentDbArray[i2] = (EnrichmentDb)objectArray[i2];
            }
            return enrichmentDbArray;
        }
        return null;
    }

    public static final EnrichmentDb showEdbChooser() {
        EnrichmentDb[] enrichmentDbArray = ObjectBindery.showEdbChooser(false);
        if (enrichmentDbArray != null && enrichmentDbArray.length > 0) {
            return enrichmentDbArray[0];
        }
        return null;
    }

    public static final Template[] showTemplateChooser(boolean bl) {
        Object[] objectArray = ObjectBindery._showChooser(bl, Template.class, "Select Template");
        if (objectArray != null) {
            Template[] templateArray = new Template[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                templateArray[i2] = (Template)objectArray[i2];
            }
            return templateArray;
        }
        return null;
    }

    public static final Template showTemplateChooser() {
        Template[] templateArray = ObjectBindery.showTemplateChooser(false);
        if (templateArray != null && templateArray.length > 0) {
            return templateArray[0];
        }
        return null;
    }

    public static final FeatureAnnot[] showAnnotationChooser(boolean bl) {
        Object[] objectArray = ObjectBindery._showChooser(bl, FeatureAnnot.class, "Select Annotation");
        if (objectArray != null) {
            FeatureAnnot[] featureAnnotArray = new FeatureAnnot[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                featureAnnotArray[i2] = (FeatureAnnot)objectArray[i2];
            }
            return featureAnnotArray;
        }
        return null;
    }

    public static final FeatureAnnot showAnnotationChooser() {
        FeatureAnnot[] featureAnnotArray = ObjectBindery.showAnnotationChooser(false);
        if (featureAnnotArray != null && featureAnnotArray.length > 0) {
            return featureAnnotArray[0];
        }
        return null;
    }

    public static final GeneSetMatrix[] showGeneSetMatrixChooser(boolean bl) {
        Object[] objectArray = ObjectBindery._showChooser(bl, GeneSetMatrix.class, "Select GeneSetMatrix");
        if (objectArray != null) {
            GeneSetMatrix[] geneSetMatrixArray = new GeneSetMatrix[objectArray.length];
            for (int i2 = 0; i2 < objectArray.length; ++i2) {
                geneSetMatrixArray[i2] = (GeneSetMatrix)objectArray[i2];
            }
            return geneSetMatrixArray;
        }
        return null;
    }

    public static final GeneSetMatrix showGeneSetMatrixChooser() {
        GeneSetMatrix[] geneSetMatrixArray = ObjectBindery.showGeneSetMatrixChooser(false);
        if (geneSetMatrixArray != null && geneSetMatrixArray.length > 0) {
            return geneSetMatrixArray[0];
        }
        return null;
    }

    private static Object[] _showChooser(boolean bl, Class clazz, String string) {
        JList<Object> jList = new JList<Object>();
        jList.setModel(ParserFactory.getCache().createBoxModel(clazz));
        jList.setSelectedIndex(0);
        jList.setCellRenderer(new RendererFactory2$CommonLookListRenderer());
        if (!bl) {
            jList.setSelectionMode(0);
        } else {
            jList.setSelectionMode(2);
        }
        ApplicationDialog applicationDialog = new ApplicationDialog(string, new JScrollPane(jList));
        applicationDialog.enableDoubleClickableJList(jList);
        int n = applicationDialog.show();
        if (n == 2) {
            return null;
        }
        return jList.getSelectedValues();
    }

    public static final void showDatasetSaver(Dataset dataset) {
        ObjectBindery.showObjectSaver(dataset);
    }

    public static final void showObjectSaver(PersistentObject persistentObject) {
        throw new RuntimeException("to do");
    }

    public static final void showFSetSaver(FSet fSet, boolean bl) {
        GLabelledItemPanel gLabelledItemPanel = new GLabelledItemPanel();
        JTextField jTextField = new JTextField(fSet.getName());
        jTextField.setEditable(bl);
        gLabelledItemPanel.addItem("GeneSet Name", jTextField);
        GDirFieldPlusChooser gDirFieldPlusChooser = new GDirFieldPlusChooser();
        gLabelledItemPanel.addItem("In Folder", gDirFieldPlusChooser);
        GColorFieldPlusChooser gColorFieldPlusChooser = new GColorFieldPlusChooser(Color.BLACK);
        gLabelledItemPanel.addItem("Color(optional)", gColorFieldPlusChooser);
        ApplicationDialog applicationDialog = new ApplicationDialog("Save GeneSet ...", gLabelledItemPanel);
        int n = applicationDialog.show();
        if (n == 0) {
            FSet fSet2 = fSet;
            File file = new File(gDirFieldPlusChooser.getFile(), fSet.getName());
            try {
                ParserFactory.save(fSet2, file);
            }
            catch (Throwable throwable) {
                Application.getWindowManager().showError("Could not save GeneSet", throwable);
            }
        }
    }

    public static final void autoSaveObject(PersistentObject persistentObject) {
        try {
            Runnable runnable = ObjectBindery._autoSave(persistentObject);
            Thread thread = new Thread(runnable);
            thread.start();
        }
        catch (Throwable throwable) {
            klog.fatal("Trouble autosaving pob", throwable);
        }
    }

    private static Runnable _autoSave(PersistentObject persistentObject) {
        return new ObjectBindery$1(persistentObject);
    }

    static final /* synthetic */ Logger access$000() {
        return klog;
    }
}

