/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.misc_actions;

import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.ParserFactory;
import edu.mit.broad.xbench.actions.FileObjectAction;
import edu.mit.broad.xbench.core.Widget;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import javax.swing.Icon;

public class GeneSetMatrix2GeneSetAction
extends FileObjectAction {
    private Object fFileOrObject;

    public GeneSetMatrix2GeneSetAction() {
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        this.putValue("ShortDescription", this.getDescription());
    }

    @Override
    public final void setFile(File file) {
        this.fFileOrObject = file;
    }

    @Override
    public final void setObject(Object object) {
        this.fFileOrObject = object;
    }

    @Override
    public final Widget getWidget() {
        Widget widget = null;
        try {
            if (this.fFileOrObject != null) {
                GeneSetMatrix geneSetMatrix;
                if (this.fFileOrObject instanceof File) {
                    geneSetMatrix = (GeneSetMatrix)ParserFactory.read((File)this.fFileOrObject);
                } else if (this.fFileOrObject instanceof GeneSetMatrix) {
                    geneSetMatrix = (GeneSetMatrix)this.fFileOrObject;
                } else {
                    throw new IllegalArgumentException("Only GeneSetMatrix or File Objects allowed. Got: " + this.fFileOrObject);
                }
                GeneSet geneSet = ParserFactory.combineIntoOne(geneSetMatrix);
                File file = new File(Application.getVdbManager().getTmpDir(), geneSet.getName(true));
                ParserFactory.save(geneSet, file);
                Application.getWindowManager().showMessage("Successfully created a GeneSet from the GeneSetMatrix " + geneSetMatrix.getName() + " into: " + file.getPath());
            } else {
                Application.getWindowManager().showMessage("No file or object to work on was specified");
            }
        }
        catch (Throwable throwable) {
            Application.getWindowManager().showError("Error creating a GeneSet from GeneSetMatrix", throwable);
        }
        return widget;
    }

    @Override
    public final String getId() {
        return "GeneSetMatrix2GeneSetAction";
    }

    @Override
    public final String getName() {
        return "=> Convert the GeneSetMatrix into a single GeneSet";
    }

    @Override
    public final Icon getIcon() {
        return null;
    }

    @Override
    public final String getDescription() {
        return "Convert the GeneSetMatrix into a single GeneSet (eliminates duplicates)";
    }
}

