/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions.ext;

import edu.mit.broad.genome.JarResources;
import edu.mit.broad.xbench.actions.ExtAction;
import edu.mit.broad.xbench.core.api.Application;
import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.File;
import java.net.URI;
import javax.swing.Icon;

public class BrowserAction
extends ExtAction {
    private static final String NAME = "Web Browser";
    private static final Icon ICON = JarResources.getIcon("Htm.gif");
    private String fName;
    private String fDesc;
    private Icon fIcon;

    public BrowserAction() {
        this.init(NAME, null, ICON, null);
    }

    public BrowserAction(String string) {
        this(NAME, null, ICON, string);
    }

    public BrowserAction(String string, String string2, Icon icon, String string3) {
        this.init(string, string2, icon, string3);
    }

    public BrowserAction(String string, String string2, Icon icon, File file) {
        String string3 = file.toString();
        this.init(string, string2, icon, string3);
    }

    private void init(String string, String string2, Icon icon, String string3) {
        this.fName = string;
        this.fDesc = string2;
        if (this.fDesc == null) {
            this.fDesc = "Launch a Web Browser in an External Process";
        }
        this.fPath = string3;
        this.fIcon = icon;
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        this.putValue("ShortDescription", this.getDescription());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            if (this.getPath() == null) {
                throw new NullPointerException("null path associated with BrowserAction");
            }
            Desktop.getDesktop().browse(new URI(this.getPath()));
            Application.getFileManager().registerRecentlyOpenedURL(this.getPath());
        }
        catch (Exception exception) {
            Application.getWindowManager().showError("Could not launch browser", exception);
        }
    }

    @Override
    public final String getId() {
        return "BrowserAction";
    }

    @Override
    public final String getName() {
        return this.fName;
    }

    @Override
    public final String getDescription() {
        return this.fDesc;
    }

    @Override
    public final Icon getIcon() {
        return this.fIcon;
    }
}

