/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.xbench.actions;

import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.xbench.actions.FileAction;
import edu.mit.broad.xbench.actions.FilesAction;
import edu.mit.broad.xbench.actions.WidgetAction;
import edu.mit.broad.xbench.core.Widget;
import java.io.File;
import javax.swing.Icon;

public class ProxyFileAction
extends WidgetAction {
    private FileAction fAction;
    private File[] fFiles;

    public ProxyFileAction(FileAction fileAction, File file) {
        if (fileAction == null) {
            throw new IllegalArgumentException("Param action cannot be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Param file cannot be null");
        }
        this.fAction = fileAction;
        file = AuxUtils.getBaseFileFromAuxFile(file);
        this.fFiles = new File[]{file};
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        Object object = this.fAction.getValue("ShortDescription");
        if (object != null) {
            this.putValue("ShortDescription", object);
        }
    }

    public ProxyFileAction(FilesAction filesAction, File[] fileArray) {
        if (filesAction == null) {
            throw new IllegalArgumentException("Param action cannot be null");
        }
        if (fileArray == null) {
            throw new IllegalArgumentException("Param files cannot be null");
        }
        this.fAction = filesAction;
        this.fFiles = fileArray;
        this.putValue("Name", this.getName());
        this.putValue("SmallIcon", this.getIcon());
        Object object = this.fAction.getValue("ShortDescription");
        if (object != null) {
            this.putValue("ShortDescription", object);
        }
    }

    @Override
    public final String getName() {
        return this.fAction.getName();
    }

    @Override
    public final Icon getIcon() {
        return this.fAction.getIcon();
    }

    @Override
    public final String getDescription() {
        return this.fAction.getDescription();
    }

    @Override
    public final Widget getWidget() {
        if (this.fAction instanceof FilesAction) {
            ((FilesAction)this.fAction).setFiles(this.fFiles);
        } else {
            this.fAction.setFile(this.fFiles[0]);
        }
        return this.fAction.getWidget();
    }

    @Override
    public final String getId() {
        return this.fAction.getId();
    }
}

