/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.sampledb;

import edu.mit.broad.vdb.sampledb.Sample;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class State {
    private String fName;
    private Sample[] fSamples;

    public State(String string, Sample[] sampleArray) {
        if (string == null) {
            throw new IllegalArgumentException("Param stateName cannot be null");
        }
        if (sampleArray == null) {
            throw new IllegalArgumentException("Param stateName cannot be null");
        }
        this.fName = string;
        this.fSamples = sampleArray;
    }

    public final String getName() {
        return this.fName;
    }

    public final Sample getSample(int n) {
        return this.fSamples[n];
    }

    public final Sample[] getSamples() {
        List list = this.getSamples_list();
        return list.toArray(new Sample[list.size()]);
    }

    public final String[] getSampleNames() {
        String[] stringArray = new String[this.getNumSamples()];
        for (int i2 = 0; i2 < this.getNumSamples(); ++i2) {
            stringArray[i2] = this.getSample(i2).getName();
        }
        return stringArray;
    }

    public final List getSampleNames_list() {
        return Arrays.asList(this.getSampleNames());
    }

    public final List getSamples_list() {
        ArrayList<Sample> arrayList = new ArrayList<Sample>();
        for (int i2 = 0; i2 < this.fSamples.length; ++i2) {
            arrayList.add(this.fSamples[i2]);
        }
        return arrayList;
    }

    public final int getNumSamples() {
        return this.fSamples.length;
    }
}

