/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.msigdb;

import edu.mit.broad.vdb.msigdb.GeneSetCategory;

public class GeneSetCategoryImpl
implements GeneSetCategory {
    public static GeneSetCategory POSITIONAL = new GeneSetCategoryImpl("c1", "Positional", "Position on the Genome");
    public static GeneSetCategory CURATED = new GeneSetCategoryImpl("c2", "Curated", "Curated gene sets");
    public static GeneSetCategory MOTIF = new GeneSetCategoryImpl("c3", "Motif", "Identified by sequence motif analysis");
    public static GeneSetCategory COMPUTED = new GeneSetCategoryImpl("c4", "Computational", "Identified by computational analysis");
    public static GeneSetCategory GO = new GeneSetCategoryImpl("c5", "Gene Ontology", "Gene Ontology sets");
    public static GeneSetCategory PATHWAY = new GeneSetCategoryImpl("c6", "Oncogenic Signatures", "Oncogenic pathway activation modules");
    public static GeneSetCategory IMMUNE = new GeneSetCategoryImpl("c7", "Immunologic Signatures", "Curated immune system gene sets");
    public static GeneSetCategory HALLMARK = new GeneSetCategoryImpl("H", "Hallmark", "Hallmark gene sets");
    public static GeneSetCategory[] ALL = new GeneSetCategory[]{POSITIONAL, CURATED, MOTIF, COMPUTED, GO, PATHWAY, IMMUNE, HALLMARK};
    private String fCode;
    private String fName;
    private String fDesc;

    public static final GeneSetCategory lookup(String string) {
        for (int i2 = 0; i2 < ALL.length; ++i2) {
            if (!ALL[i2].getCode().equalsIgnoreCase(string)) continue;
            return ALL[i2];
        }
        throw new IllegalArgumentException("No such gene set category for code: " + string);
    }

    private GeneSetCategoryImpl(String string, String string2, String string3) {
        this.fCode = string;
        this.fName = string2;
        this.fDesc = string3;
    }

    @Override
    public final String getCode() {
        return this.fCode;
    }

    @Override
    public final String getName() {
        return this.fName;
    }

    @Override
    public final String getDesc() {
        return this.fDesc;
    }

    public final boolean equals(Object object) {
        GeneSetCategory geneSetCategory;
        return object instanceof GeneSetCategory && (geneSetCategory = (GeneSetCategory)object).getCode().equals(this.fName);
    }
}

