/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.meg;

import edu.mit.broad.genome.Version;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.vdb.Vdb;
import edu.mit.broad.vdb.meg.Gene;
import edu.mit.broad.vdb.meg.Gene$Helper;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class GeneDb
extends AbstractObject
implements Vdb {
    private String fSourcePath;
    private Version fVersion;
    private Gene[] fGenes;
    private Map fGeneSymbolHugoMap;

    public GeneDb(String string, Version version, Gene[] geneArray) {
        this.init(string, version, geneArray);
    }

    public GeneDb(File file, Version version, Gene[] geneArray) {
        this.init(file.getPath(), version, geneArray);
    }

    @Override
    public final String getQuickInfo() {
        return null;
    }

    private void init(String string, Version version, Gene[] geneArray) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter source cannot be null");
        }
        if (version == null) {
            throw new IllegalArgumentException("Parameter version cannot be null");
        }
        if (geneArray == null) {
            throw new IllegalArgumentException("Parameter hugos cannot be null");
        }
        super.initialize(string);
        HashSet<String> hashSet = new HashSet<String>();
        HashSet<String> hashSet2 = new HashSet<String>();
        for (int i2 = 0; i2 < geneArray.length; ++i2) {
            if (hashSet.contains(geneArray[i2].getSymbol())) {
                hashSet2.add(geneArray[i2].getSymbol());
            }
            hashSet.add(geneArray[i2].getSymbol());
        }
        if (!hashSet2.isEmpty()) {
            throw new IllegalArgumentException("There were Duplicate HUGO records: " + hashSet2.size() + "\n" + hashSet2);
        }
        this.fVersion = version;
        this.fSourcePath = string;
        this.fGenes = geneArray;
    }

    public final void printfInfo() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("# of unique hugo records: ").append(this.fGenes.length);
        System.out.println(stringBuffer.toString());
    }

    @Override
    public final String getSourcePath() {
        return this.fSourcePath;
    }

    public final Gene[] getHugos() {
        return this.fGenes;
    }

    public final Gene getHugo(int n) {
        return this.fGenes[n];
    }

    @Override
    public final int getNumRecords() {
        return this.fGenes.length;
    }

    @Override
    public final Version getVersion() {
        return this.fVersion;
    }

    public final Map createGeneSymbolHugoMap() {
        this.initGeneSymbolMap();
        return new HashMap(this.fGeneSymbolHugoMap);
    }

    private void initGeneSymbolMap() {
        if (this.fGeneSymbolHugoMap == null) {
            this.fGeneSymbolHugoMap = new HashMap();
            for (int i2 = 0; i2 < this.fGenes.length; ++i2) {
                this.fGeneSymbolHugoMap.put(this.fGenes[i2].getSymbol(), this.fGenes[i2]);
            }
        }
    }

    public final boolean isSymbol(String string) {
        this.initGeneSymbolMap();
        return this.fGeneSymbolHugoMap.containsKey(string);
    }

    public final Gene getHugo(String string) {
        this.initGeneSymbolMap();
        Object v = this.fGeneSymbolHugoMap.get(string);
        if (v != null) {
            return (Gene)v;
        }
        return null;
    }

    public final Map createGeneSymbolAccessionMap() {
        HashMap hashMap = new HashMap();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            Set set;
            Gene gene = this.getHugo(i2);
            if (gene.getSymbol() == null || (set = gene.getSeqAccessions()) == null || set.isEmpty()) continue;
            Object object = hashMap.get(gene.getSymbol());
            if (object == null) {
                object = new HashSet();
            }
            ((Set)object).addAll(set);
            hashMap.put(gene.getSymbol(), object);
        }
        return hashMap;
    }

    public final Set getSymbols() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < this.getNumRecords(); ++i2) {
            Gene gene = this.getHugo(i2);
            if (Gene$Helper.isNull(gene)) continue;
            hashSet.add(this.getHugo(i2).getSymbol());
        }
        return hashSet;
    }
}

