/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.meg;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.genome.Printf$Full;
import edu.mit.broad.genome.Version;
import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.StringDataframe;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.StringDataframeParser;
import edu.mit.broad.genome.utils.FileUtils;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.chip.SimpleProbe2;
import edu.mit.broad.vdb.meg.AliasDb;
import edu.mit.broad.vdb.meg.Gene;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class AliasDbImpl
extends AbstractObject
implements AliasDb {
    private File fFile_opt;
    private Chip fChip_opt;
    private Map fSymbolAliasesMap;
    private Map fAliasSymbolMap;

    public AliasDbImpl(File file, Chip chip) {
        super.initialize(AliasDbImpl._name(file, chip));
        this.fFile_opt = file;
        this.fChip_opt = chip;
    }

    @Override
    public final String getQuickInfo() {
        return null;
    }

    @Override
    public final boolean isAlias(String string) {
        String string2 = this.getSymbol(string);
        return string2 != null;
    }

    @Override
    public final String getSymbol(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param alias cannot be null");
        }
        this._initAliasSymbolMap();
        Object v = this.fAliasSymbolMap.get(string);
        if (v != null) {
            return v.toString();
        }
        v = this.fAliasSymbolMap.get(string.toUpperCase());
        if (v != null) {
            return v.toString();
        }
        return null;
    }

    @Override
    public final Gene getHugo(String string) {
        if (this.fChip_opt == null) {
            throw new NotImplementedException("Only works for in mem gene symbol chip");
        }
        String string2 = this.getSymbol(string);
        return this.fChip_opt.getHugo(string2);
    }

    @Override
    public final Probe[] getAliasesAsProbes() {
        this._initAliasSymbolMap();
        Probe[] probeArray = new Probe[this.fAliasSymbolMap.size()];
        int n = 0;
        Iterator iterator = this.fAliasSymbolMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = this.fAliasSymbolMap.get(string).toString();
            probeArray[n++] = new SimpleProbe2(string, string2, VdbRuntimeResources.getChip_Gene_Symbol());
        }
        return probeArray;
    }

    @Override
    public final Map getSymbolAliasesMap() {
        this._initSymbolAliasesMap();
        return Collections.unmodifiableMap(this.fSymbolAliasesMap);
    }

    @Override
    public final Set getAliases(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param symbol_in cannot be null");
        }
        this._initSymbolAliasesMap();
        Object v = this.fSymbolAliasesMap.get(string);
        if (v != null) {
            return (Set)v;
        }
        v = this.fSymbolAliasesMap.get(string.toUpperCase());
        if (v != null) {
            return (Set)v;
        }
        return null;
    }

    @Override
    public final String[] getAliases_array(String string) {
        Set set = this.getAliases(string);
        if (set != null) {
            return set.toArray(new String[set.size()]);
        }
        return null;
    }

    @Override
    public final int getNumRecords() {
        throw new NotImplementedException();
    }

    @Override
    public final String getSourcePath() {
        if (this.fFile_opt != null) {
            return this.fFile_opt.getPath();
        }
        return this.fChip_opt.getSourcePath();
    }

    @Override
    public final Version getVersion() {
        return new Version(1);
    }

    private static String _name(File file, Chip chip) {
        if (chip != null && file != null) {
            throw new IllegalArgumentException("Both file: " + file + " and chip cannot be specified: " + chip);
        }
        if (file != null) {
            return file.getName();
        }
        if (chip != null) {
            return chip.getName();
        }
        throw new IllegalArgumentException("Both file and chip cannot be null");
    }

    public static final void save(Map map, File file) {
        StringBuffer stringBuffer = new StringBuffer();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            string = NamingConventions.symbolize(string);
            Set set = (Set)map.get(string);
            stringBuffer.append(string).append('\t').append(Printf$Full.toString(set)).append('\n');
        }
        FileUtils.write(stringBuffer.toString(), file);
    }

    private void _initSymbolAliasesMap() {
        if (this.fSymbolAliasesMap != null) {
            return;
        }
        HashMap<String, Set> hashMap = new HashMap<String, Set>();
        if (this.fFile_opt != null) {
            StringDataframe stringDataframe = new StringDataframeParser().parseSdf(this.fFile_opt);
            for (int i2 = 0; i2 < stringDataframe.getNumRow(); ++i2) {
                String string = stringDataframe.getRowName(i2);
                string = NamingConventions.symbolize(string);
                Set set = ParseUtils.string2stringsSet(stringDataframe.getElement(i2, 0), "\u001c", false);
                HashSet<String> hashSet = new HashSet<String>();
                for (Object e2 : set) {
                    hashSet.add(e2.toString().toUpperCase());
                }
                hashMap.put(string.toUpperCase(), hashSet);
            }
        } else {
            Probe[] probeArray = this.fChip_opt.getProbes();
            for (int i3 = 0; i3 < probeArray.length; ++i3) {
                Gene gene = probeArray[i3].getGene();
                if (gene == null || gene == Gene.NULL_GENE || gene.getAliases() == null || gene.getAliases().isEmpty()) continue;
                String string = gene.getSymbol();
                hashMap.put(string, gene.getAliases());
            }
        }
        this.log.info("# of symbols with aliases: " + hashMap.size());
        this.fSymbolAliasesMap = hashMap;
    }

    private void _initAliasSymbolMap() {
        if (this.fAliasSymbolMap != null) {
            return;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        HashSet<String> hashSet = new HashSet<String>();
        if (this.fFile_opt != null) {
            StringDataframe stringDataframe = new StringDataframeParser().parseSdf(this.fFile_opt);
            for (int i2 = 0; i2 < stringDataframe.getNumRow(); ++i2) {
                String string = NamingConventions.symbolize(stringDataframe.getRowName(i2));
                String[] stringArray = ParseUtils.string2strings(stringDataframe.getElement(i2, 0), "\u001c", false);
                HashSet<String> hashSet2 = new HashSet<String>();
                for (int i3 = 0; i3 < stringArray.length; ++i3) {
                    hashSet2.add(stringArray[i3].toUpperCase());
                }
                String[] stringArray2 = hashSet2.toArray(new String[hashSet2.size()]);
                for (int i4 = 0; i4 < stringArray2.length; ++i4) {
                    if (hashMap.containsKey(stringArray2[i4])) {
                        hashSet.add(stringArray2[i4]);
                        continue;
                    }
                    hashMap.put(stringArray2[i4], string);
                }
            }
        } else {
            Probe[] probeArray = this.fChip_opt.getProbes();
            for (int i5 = 0; i5 < probeArray.length; ++i5) {
                Gene gene = probeArray[i5].getGene();
                if (gene == null || gene == Gene.NULL_GENE || gene.getAliases() == null || gene.getAliases().isEmpty()) continue;
                String string = gene.getSymbol();
                String[] stringArray = gene.getAliasesArray();
                for (int i6 = 0; i6 < stringArray.length; ++i6) {
                    String string2 = stringArray[i6].toUpperCase();
                    if (hashMap.containsKey(string2)) {
                        hashSet.add(string2);
                        continue;
                    }
                    hashMap.put(string2, string);
                }
            }
        }
        if (!hashSet.isEmpty()) {
            this.log.warn("There are duplicate entry for accessions: " + hashSet.size() + " ignoring them ..." + " total #: " + hashMap.size());
        }
        this.log.info("# of aliases: " + hashMap.size());
        this.fAliasSymbolMap = hashMap;
    }
}

