/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.objects.DefaultGeneSetMatrix;
import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapper;
import edu.mit.broad.vdb.map.Chip2ChipMapperSlim;
import edu.mit.broad.vdb.map.MGeneSetMatrix;
import edu.mit.broad.vdb.map.MappingDbType;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.log4j.Logger;

public class MapUtils {
    private static final Logger klog = XLogger.getLogger(MapUtils.class);
    private static final char DELIM = '.';
    private static final String DELIMS = ".";

    public static final GeneSetMatrix createCombinedGeneSetMatrix(String string, MGeneSetMatrix[] mGeneSetMatrixArray) {
        if (mGeneSetMatrixArray == null) {
            throw new IllegalArgumentException("Param mgms cannot be null");
        }
        if (mGeneSetMatrixArray.length == 0) {
            throw new IllegalArgumentException("No mapped sets provided: " + mGeneSetMatrixArray.length);
        }
        Set[] setArray = new Set[mGeneSetMatrixArray[0].getNumMappedSets()];
        String[] stringArray = new String[setArray.length];
        for (int i2 = 0; i2 < mGeneSetMatrixArray.length; ++i2) {
            MGeneSetMatrix mGeneSetMatrix = mGeneSetMatrixArray[i2];
            for (int i3 = 0; i3 < setArray.length; ++i3) {
                GeneSet geneSet = mGeneSetMatrix.getMappedGeneSet(i3).getMappedGeneSet(true);
                if (setArray[i3] == null) {
                    setArray[i3] = new HashSet();
                }
                setArray[i3].addAll(geneSet.getMembersS());
                if (i2 != 0) continue;
                stringArray[i3] = geneSet.getName();
            }
        }
        GeneSet[] geneSetArray = new GeneSet[setArray.length];
        for (int i4 = 0; i4 < setArray.length; ++i4) {
            geneSetArray[i4] = new FSet(AuxUtils.getAuxNameOnlyNoHash(stringArray[i4]), setArray[i4]);
        }
        return new DefaultGeneSetMatrix(string, geneSetArray);
    }

    public static final String createId(String string, String string2) {
        return string + '.' + string2;
    }

    public static final String createId(Chip chip, Chip chip2) {
        return MapUtils.createId(chip.getName(), chip2.getName());
    }

    public static final String createId(String string, String string2, MappingDbType mappingDbType) {
        return MapUtils.createId(string, string2, mappingDbType.getName());
    }

    public static final String createId(String string, String string2, String string3) {
        return string + '.' + string2 + '.' + string3;
    }

    public static final String createId(Chip chip, Chip chip2, MappingDbType mappingDbType) {
        return MapUtils.createId(chip.getName(), chip2.getName(), mappingDbType);
    }

    public static final boolean equals(Chip chip, Chip chip2, MappingDbType mappingDbType, String string, String string2, String string3) {
        return chip.getName().equals(string) && chip2.getName().equals(string2) && mappingDbType.equals(string3);
    }

    public static final boolean equals(Chip chip, Chip chip2, MappingDbType mappingDbType, Chip chip3, Chip chip4, String string) {
        return MapUtils.equals(chip, chip2, mappingDbType, chip3.getName(), chip4.getName(), string);
    }

    public static final boolean equals(Chip chip, Chip chip2, Chip chip3, Chip chip4) {
        return chip.getName().equals(chip3.getName()) && chip2.getName().equals(chip4.getName());
    }

    public static final boolean equals(Chip chip, Chip chip2, String string, String string2) {
        return chip.getName().equals(string) && chip2.getName().equals(string2);
    }

    public static final void saveMappedChip2(Chip2ChipMapperSlim chip2ChipMapperSlim, File file, boolean bl, boolean bl2) {
        Closeable closeable;
        File file2;
        if (bl) {
            file2 = new File(file.getPath() + ".ser");
            closeable = new ObjectOutputStream(new FileOutputStream(file2));
            ((ObjectOutputStream)closeable).writeObject(chip2ChipMapperSlim);
            ((ObjectOutputStream)closeable).close();
        }
        if (bl2) {
            file2 = new File(file.getPath() + ".map");
            closeable = new PrintWriter(new FileOutputStream(file2));
            String[] stringArray = chip2ChipMapperSlim.getSourceProbes();
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                StringBuffer stringBuffer = new StringBuffer(stringArray[i2]).append('\t');
                Set set = chip2ChipMapperSlim.map(stringArray[i2]);
                Iterator iterator = set.iterator();
                while (iterator.hasNext()) {
                    Object e2 = iterator.next();
                    stringBuffer.append(e2.toString());
                    if (!iterator.hasNext()) continue;
                    stringBuffer.append(',');
                }
                stringBuffer.append('\n');
                ((PrintWriter)closeable).print(stringBuffer.toString());
            }
            ((PrintWriter)closeable).close();
        }
    }

    public static final void saveMappedChip(Chip2ChipMapper chip2ChipMapper, File file) {
        File file2 = new File(file.getPath() + ".map");
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file2));
        String[] stringArray = chip2ChipMapper.getSourceProbes();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            StringBuffer stringBuffer = new StringBuffer(stringArray[i2]).append('\t');
            Set set = chip2ChipMapper.map(stringArray[i2]);
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object e2 = iterator.next();
                stringBuffer.append(e2.toString());
                if (!iterator.hasNext()) continue;
                stringBuffer.append(',');
            }
            stringBuffer.append('\n');
            printWriter.print(stringBuffer.toString());
        }
        printWriter.close();
    }

    public static final void printf(Chip2ChipMapper chip2ChipMapper) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Info for mc: ").append(chip2ChipMapper.getName()).append('\n');
        stringBuffer.append("# of source probes: ").append(chip2ChipMapper.getNumSourceProbes()).append('\n');
        klog.info(stringBuffer.toString());
    }
}

