/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.objects.FSet;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.parsers.AuxUtils;
import edu.mit.broad.vdb.VdbRuntimeResources;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.MGeneSet;
import edu.mit.broad.vdb.map.Mapper;
import edu.mit.broad.vdb.map.MappingDbType;
import edu.mit.broad.vdb.map.MappingEtiology;
import edu.mit.broad.vdb.map.MutableMappingEtiology;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

class MGeneSetImpl
implements MGeneSet {
    private GeneSet mappedGeneSet;
    private MutableMappingEtiology met;

    protected MGeneSetImpl(GeneSet geneSet, boolean bl, String string, String string2, MappingDbType mappingDbType, Mapper mapper) {
        if (geneSet == null) {
            throw new IllegalArgumentException("Param sourceGeneSet cannot be null");
        }
        if (string == null) {
            throw new IllegalArgumentException("Param sourceChipName cannot be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("Param targetChipName cannot be null");
        }
        if (mappingDbType == null) {
            throw new IllegalArgumentException("Param dbType cannot be null");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("Param mapper cannot be null");
        }
        HashSet<Set> hashSet = new HashSet<Set>();
        if (bl) {
            this.met = new MutableMappingEtiology(AuxUtils.getAuxNameOnlyNoHash(geneSet.getName()), string, string2, mappingDbType);
        }
        Chip chip = null;
        for (int i2 = 0; i2 < geneSet.getNumMembers(); ++i2) {
            String string3 = geneSet.getMember(i2);
            Set set = mapper.map(string3);
            if (set != null) {
                if (set instanceof String) {
                    hashSet.add(set);
                } else if (set instanceof Set) {
                    hashSet.addAll(set);
                } else {
                    throw new IllegalStateException("Unnown mapped object: " + set + " " + set.getClass());
                }
            }
            if (!bl) continue;
            try {
                if (chip == null) {
                    chip = VdbRuntimeResources.getChip(string);
                }
                this.met.add(string3, (Object)set, chip.isProbe(string3));
                continue;
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        this.mappedGeneSet = new FSet(geneSet.getName(), Collections.unmodifiableSet(hashSet));
        if (bl) {
            this.met.setImmutable();
        }
    }

    @Override
    public final GeneSet getMappedGeneSet(boolean bl) {
        return this.mappedGeneSet;
    }

    @Override
    public final MappingEtiology getEtiology() {
        return this.met;
    }
}

