/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.map;

import edu.mit.broad.genome.objects.AbstractObject;
import edu.mit.broad.genome.objects.GeneSet;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.map.Chip2ChipMapper;
import edu.mit.broad.vdb.map.MGeneSet;
import edu.mit.broad.vdb.map.MGeneSetImpl;
import edu.mit.broad.vdb.map.MGeneSetMatrix;
import edu.mit.broad.vdb.map.MGeneSetMatrixImpl;
import edu.mit.broad.vdb.map.MapUtils;
import edu.mit.broad.vdb.map.MappingDbType;
import edu.mit.broad.vdb.map.MappingDbTypes;
import java.util.HashSet;
import java.util.Set;

public class Chip2ChipMapperSymbol
extends AbstractObject
implements Chip2ChipMapper {
    private Chip fSourceChip;
    private Chip fTargetChip;

    public Chip2ChipMapperSymbol(Chip chip, Chip chip2) {
        if (chip == null) {
            throw new IllegalArgumentException("Param sourceChip cannot be null");
        }
        if (chip2 == null) {
            throw new IllegalArgumentException("Param targetChip cannot be null");
        }
        System.out.println("##### source: " + chip.getName() + " target: " + chip2.getName());
        this.fSourceChip = chip;
        this.fTargetChip = chip2;
        super.initialize(MapUtils.createId(this.fSourceChip, this.fTargetChip, this.getMappingDbType()));
    }

    @Override
    public final String getQuickInfo() {
        return null;
    }

    @Override
    public final String getChipsId() {
        return MapUtils.createId(this.fSourceChip, this.fTargetChip);
    }

    @Override
    public final int getNumSourceProbes() {
        try {
            return this.fSourceChip.getNumProbes();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public final MappingDbType getMappingDbType() {
        return MappingDbTypes.GENE_SYMBOL;
    }

    @Override
    public final Chip getSourceChip() {
        return this.fSourceChip;
    }

    @Override
    public final Chip getTargetChip() {
        return this.fTargetChip;
    }

    @Override
    public final String[] getSourceProbes() {
        try {
            return this.fSourceChip.getProbeNamesArr();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    @Override
    public final boolean equals(Chip chip, Chip chip2, MappingDbType mappingDbType) {
        return MapUtils.equals(chip, chip2, mappingDbType, this.fSourceChip, this.fTargetChip, MappingDbTypes.GENE_SYMBOL.getName());
    }

    @Override
    public final boolean equals(Chip chip, Chip chip2) {
        return MapUtils.equals(chip, chip2, this.fSourceChip, this.fTargetChip);
    }

    @Override
    public final Set map(String string) {
        String string2;
        HashSet<String> hashSet = new HashSet<String>();
        if (this.fTargetChip.isProbe(string)) {
            hashSet.add(string);
        }
        if ((string2 = this.fSourceChip.getSymbol(string, Chip.OMIT_NULLS)) != null) {
            Set set = this.fTargetChip.getProbeNames(string2);
            hashSet.addAll(set);
        }
        return hashSet;
    }

    @Override
    public final MGeneSet map(GeneSet geneSet, boolean bl) {
        return new MGeneSetImpl(geneSet, bl, this.fSourceChip.getName(), this.fTargetChip.getName(), MappingDbTypes.GENE_SYMBOL, this);
    }

    @Override
    public final MGeneSetMatrix map(GeneSetMatrix geneSetMatrix, boolean bl) {
        return new MGeneSetMatrixImpl(geneSetMatrix, bl, this.fSourceChip.getName(), this.fTargetChip.getName(), MappingDbTypes.GENE_SYMBOL, this);
    }
}

