/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb.chip;

import edu.mit.broad.genome.NamingConventions;
import edu.mit.broad.genome.NotImplementedException;
import edu.mit.broad.vdb.chip.Probe;
import edu.mit.broad.vdb.meg.Gene;
import edu.mit.broad.vdb.meg.Gene$Helper;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SimpleProbe3
implements Probe,
Gene {
    private String fSymbol;
    private String fTitle;
    private Set fAliases;
    private static final Set EMPTY_SET = Collections.unmodifiableSet(new HashSet());

    public SimpleProbe3(String string, String string2, Set set) {
        if (string == null) {
            throw new IllegalArgumentException("Parameter symbol cannot be null");
        }
        this.fTitle = NamingConventions.titleize(string2);
        this.fSymbol = string.toUpperCase();
        this.fAliases = set;
    }

    @Override
    public final Gene cloneDeep() {
        return new SimpleProbe3(this.getSymbol(), this.getTitle(), this.getAliases());
    }

    @Override
    public final Probe cloneDeepProbe() {
        return (Probe)((Object)this.cloneDeep());
    }

    @Override
    public final String getSymbol() {
        return this.fSymbol;
    }

    @Override
    public final String getTitle() {
        return this.fTitle;
    }

    @Override
    public final String getCyto() {
        return null;
    }

    @Override
    public final String getTitle_truncated() {
        return Gene$Helper.getTitle_truncated(this.fTitle);
    }

    @Override
    public final Set getAliases() {
        if (this.fAliases == null) {
            return EMPTY_SET;
        }
        return Collections.unmodifiableSet(this.fAliases);
    }

    public final void removeAnyAliasesThatMatch(Set set) {
        if (this.fAliases != null && !this.fAliases.isEmpty()) {
            this.fAliases.removeAll(set);
            this.fAliases = Collections.unmodifiableSet(this.fAliases);
        }
    }

    @Override
    public final String[] getAliasesArray() {
        Set set = this.getAliases();
        return set.toArray(new String[set.size()]);
    }

    @Override
    public final Set getSeqAccessions() {
        return EMPTY_SET;
    }

    @Override
    public final boolean containsAlias(String string) {
        return this.getAliases().contains(string);
    }

    public final String toString() {
        return this.getSymbol();
    }

    public final int hashCode() {
        return this.getSymbol().hashCode();
    }

    @Override
    public final String getName() {
        return this.getSymbol();
    }

    public final boolean equals(Object object) {
        if (object instanceof Probe) {
            String string = ((Probe)object).getName();
            return string.equals(this.getName());
        }
        if (object instanceof Gene) {
            String string = ((Gene)object).getSymbol();
            return string.equals(this.getSymbol());
        }
        return false;
    }

    @Override
    public final Gene getGene() {
        return this;
    }

    @Override
    public final boolean containsSeqAccession(String string) {
        throw new NotImplementedException();
    }
}

