/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb;

import edu.mit.broad.genome.Errors;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.alg.ComparatorFactory$ChipNameComparator;
import edu.mit.broad.genome.objects.FeatureAnnot;
import edu.mit.broad.genome.objects.GenesOfInterest;
import edu.mit.broad.genome.parsers.EntrezGeneDbParser;
import edu.mit.broad.genome.parsers.HugoDbParser;
import edu.mit.broad.genome.parsers.ParseUtils;
import edu.mit.broad.genome.parsers.UnigeneParser;
import edu.mit.broad.vdb.Organism;
import edu.mit.broad.vdb.VdbRuntimeResources$1;
import edu.mit.broad.vdb.VdbRuntimeResources$2;
import edu.mit.broad.vdb.chip.Chip;
import edu.mit.broad.vdb.chip.ChipHelper;
import edu.mit.broad.vdb.chip.EntrezWebChip;
import edu.mit.broad.vdb.chip.FeatureAnnotChipImpl;
import edu.mit.broad.vdb.chip.FileInMemoryChip;
import edu.mit.broad.vdb.map.Chip2ChipMapperSymbol;
import edu.mit.broad.vdb.meg.AliasDb;
import edu.mit.broad.vdb.meg.AliasDbImpl;
import edu.mit.broad.vdb.meg.EntrezGeneDb;
import edu.mit.broad.vdb.meg.GeneDb;
import edu.mit.broad.vdb.meg.Unigene;
import edu.mit.broad.xbench.core.api.Application;
import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;
import org.genepattern.uiutil.FTPList;
import xapps.gsea.GseaWebResources;

public class VdbRuntimeResources {
    private static final Logger klog = XLogger.getLogger(VdbRuntimeResources.class);
    static Set affy_prefixes_hack = new HashSet();
    private static EntrezGeneDb kEntrezGeneDb;
    private static Unigene kUnigene;
    private static GeneDb kGeneDb;
    private static AliasDb kAliasDb;
    private static WeakHashMap kChipNameChipFileObject;
    private static EntrezWebChip kEntrezWebChip;
    private static Chip kAffy_combo_chip;
    private static Map kGeoNameAffyNameMap;
    private static String FTP_ANNOTATION_BASE;
    private static String fChipLocBase;
    private static Set kChipNameErrors;
    private static List kValidChipPlatformNames_tt;

    public static final String entrezGeneId2GeneSymbol(String string, boolean bl) {
        return VdbRuntimeResources.getEntrezGeneDb(bl).getSymbol(string);
    }

    public static final Set entrezGeneId2GeneSymbol(Set set, boolean bl) {
        return VdbRuntimeResources.getEntrezGeneDb(bl).getSymbols(set);
    }

    public static final String entrezGeneId2GeneSymbol_one_or_null(Set set, boolean bl) {
        Set set2 = VdbRuntimeResources.entrezGeneId2GeneSymbol(set, bl);
        if (set2 == null || set2.isEmpty()) {
            return null;
        }
        return set2.toArray(new String[set2.size()])[0];
    }

    public static final EntrezGeneDb getEntrezGeneDb(boolean bl) {
        if (kEntrezGeneDb == null) {
            EntrezGeneDbParser entrezGeneDbParser = new EntrezGeneDbParser();
            File file = new File(Application.getVdbManager().getDatabasesDir(), "gene_info");
            kEntrezGeneDb = entrezGeneDbParser.parseEntrezDb(file, bl);
        }
        return kEntrezGeneDb;
    }

    public static final String[] getPossibleTxtFileNames(String string) {
        if (string.endsWith(".CEL") || string.endsWith(".cel")) {
            string = string.substring(0, string.length() - 4);
        }
        return new String[]{string, string + ".TXT", string + ".TXT.gz", string + ".TXT.bz2", string + ".txt", string + ".txt.gz", string + ".txt.bz2"};
    }

    public static final String[] getPossibleCelFileNames(String string) {
        return new String[]{string, string + ".CEL", string + ".CEL.gz", string + ".CEL.bz2", string + ".cel", string + ".cel.gz", string + ".cel.bz2"};
    }

    public static final File[] getCelFiles(String[] stringArray) {
        Errors errors = new Errors();
        File[] fileArray = new File[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            try {
                fileArray[i2] = VdbRuntimeResources.getCelFile(stringArray[i2], true);
                continue;
            }
            catch (Exception exception) {
                errors.add(exception);
            }
        }
        errors.barfIfNotEmpty();
        return fileArray;
    }

    public static final File getCelFile(String string, boolean bl) {
        String[] stringArray = VdbRuntimeResources.getPossibleCelFileNames(string);
        File[] fileArray = new File[]{VdbRuntimeResources.getXChipCelFileDir()};
        return VdbRuntimeResources.getFile(stringArray, fileArray, string, bl);
    }

    public static final File getFile(String[] stringArray, File[] fileArray, String string, boolean bl) {
        int n;
        if (string == null) {
            throw new IllegalArgumentException("Param celFileOrSampleName_or_path cannot be null");
        }
        for (n = 0; n < stringArray.length; ++n) {
            File file = new File(stringArray[n]);
            if (!file.exists()) continue;
            return file;
        }
        for (n = 0; n < fileArray.length; ++n) {
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                File file = new File(fileArray[n], stringArray[i2]);
                if (!file.exists()) continue;
                return file;
            }
        }
        if (bl) {
            throw new RuntimeException("Cannot find file for: " + string);
        }
        return null;
    }

    public static final File getXChipCelFileDir() {
        return new File("/xchip/data01/Affy/Genechip/RawCelFiles");
    }

    public static final File getXChipTxtFileDir() {
        return new File("/xchip/data03/Affy/Genechip/TxtFiles");
    }

    public static final Unigene getUnigene(boolean bl) {
        Unigene unigene;
        if (kUnigene == null) {
            unigene = new UnigeneParser().parseUnigene(new File(Application.getVdbManager().getDatabasesDir(), "Hs.data.txt"), true);
            if (bl) {
                kUnigene = unigene;
            }
        } else {
            unigene = kUnigene;
        }
        return unigene;
    }

    public static final GeneDb getHugoDb(boolean bl) {
        GeneDb geneDb;
        if (kGeneDb == null) {
            geneDb = new HugoDbParser().parseHugoDb(new File(Application.getVdbManager().getDatabasesDir(), "Hs.Hugo.txt"));
            if (bl) {
                kGeneDb = geneDb;
            }
        } else {
            geneDb = kGeneDb;
        }
        return geneDb;
    }

    public static final AliasDb getAliasDb() {
        if (kAliasDb == null) {
            kAliasDb = new AliasDbImpl(null, VdbRuntimeResources.getChip_Gene_Symbol());
        }
        return kAliasDb;
    }

    private static final FilenameFilter createArrayAnnotationFnf() {
        return new VdbRuntimeResources$1();
    }

    public static final boolean isValidChipPlatform(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param chipName cannot be null");
        }
        List<String> list = Arrays.asList(VdbRuntimeResources.getChipNames_All());
        boolean bl = list.contains(string);
        if (!bl) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().toString();
                if (!string2.equalsIgnoreCase(string)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public static final FeatureAnnot getFeatureAnnot_Gene_Symbol() {
        return new FeatureAnnotChipImpl(VdbRuntimeResources.getChip_Gene_Symbol(), VdbRuntimeResources.getDefaultGenesOfInterest());
    }

    public static final GenesOfInterest getDefaultGenesOfInterest() {
        return Application.getVdbManager().getDefaultGenesOfInterest();
    }

    public static final Chip getChip_Seq_Accession() {
        return VdbRuntimeResources.getChip("SEQ_ACCESSION");
    }

    public static final Chip getChip_Stanford_Source() {
        return VdbRuntimeResources.getChip("STANFORD_SOURCE_ACCESSIONS");
    }

    public static final EntrezWebChip getChip_EntrezWeb() {
        if (kEntrezWebChip == null) {
            Chip chip = ChipHelper.createComboChip(new Chip[]{VdbRuntimeResources.getChip_Seq_Accession(), VdbRuntimeResources.getChip_Stanford_Source()});
            kEntrezWebChip = new EntrezWebChip(chip);
        }
        return kEntrezWebChip;
    }

    public static final Chip getChip_Gene_Symbol() {
        return VdbRuntimeResources.getChip("GENE_SYMBOL");
    }

    public static final boolean isChipSeqAccession(Chip chip) {
        return chip != null && VdbRuntimeResources.isChipSeqAccession(chip.getName());
    }

    public static final boolean isChipGeneSymbol(Chip chip) {
        return chip != null && VdbRuntimeResources.isChipGeneSymbol(chip.getName());
    }

    public static final boolean isChipGeneSymbol(String string) {
        string = VdbRuntimeResources._nameOrPath2Name(string).toUpperCase();
        return string.startsWith("GENE_SYMBOL");
    }

    public static final boolean isChipSeqAccession(String string) {
        string = VdbRuntimeResources._nameOrPath2Name(string).toUpperCase();
        return string.startsWith("SEQ_ACCESSION");
    }

    public static final Chip2ChipMapperSymbol getGeneSymbolMapper(Chip chip, boolean bl) {
        if (bl) {
            return new Chip2ChipMapperSymbol(chip, VdbRuntimeResources.getChip_Gene_Symbol());
        }
        return new Chip2ChipMapperSymbol(VdbRuntimeResources.getChip_Gene_Symbol(), chip);
    }

    public static final boolean isChipAffy_hacky(String string) {
        string = VdbRuntimeResources._nameOrPath2Name(string);
        string = string.toUpperCase();
        Iterator iterator = affy_prefixes_hack.iterator();
        while (iterator.hasNext()) {
            String string2 = iterator.next().toString().toUpperCase();
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }

    public static final Chip getChip_Affy() {
        try {
            if (kAffy_combo_chip == null) {
                kAffy_combo_chip = ChipHelper.createComboChip(VdbRuntimeResources.getChips_Affy());
                kAffy_combo_chip.cloneShallow("AFFYMETRIX");
            }
            return kAffy_combo_chip;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static final Chip[] getChips_Affy() {
        try {
            String[] stringArray = ParseUtils.slurpIntoArray(JarResources.toURL("AffyChipNames.txt"), true);
            return VdbRuntimeResources.getChips(stringArray);
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    public static final Chip[] getChips_Affy(Organism organism) {
        Chip[] chipArray = VdbRuntimeResources.getChips_Affy();
        String string = organism.getValue().toString().substring(0, 1).toUpperCase();
        ArrayList<Chip> arrayList = new ArrayList<Chip>();
        for (int i2 = 0; i2 < chipArray.length; ++i2) {
            if (!chipArray[i2].getName().toUpperCase().startsWith(string)) continue;
            arrayList.add(chipArray[i2]);
        }
        return arrayList.toArray(new Chip[arrayList.size()]);
    }

    public static final Chip getChip_All_Affy_combo(Organism organism) {
        return ChipHelper.createComboChip(VdbRuntimeResources.getChips_Affy(organism));
    }

    public static final Chip getChip_combo(String[] stringArray) {
        Chip[] chipArray = new Chip[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            chipArray[i2] = VdbRuntimeResources.getChip(stringArray[i2]);
        }
        return ChipHelper.createComboChip(chipArray);
    }

    public static final Chip[] getChips(String[] stringArray) {
        Chip[] chipArray = new Chip[stringArray.length];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            chipArray[i2] = VdbRuntimeResources.getChip(stringArray[i2]);
        }
        return chipArray;
    }

    public static final String geo2affy_chip_convert(String string) {
        if (string != null && string.startsWith("GPL")) {
            try {
                URL uRL;
                if (kGeoNameAffyNameMap == null) {
                    uRL = JarResources.toURL("GEO2AffyChipNames_mapping.txt");
                    kGeoNameAffyNameMap = ParseUtils.readKeyVal(uRL, false, false, false);
                }
                if (kGeoNameAffyNameMap != null && (uRL = kGeoNameAffyNameMap.get(string)) != null) {
                    return ((Object)uRL).toString();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return string;
    }

    public static final Chip getChip(String string) {
        if (string == null) {
            throw new IllegalArgumentException("Param chipNameOrPath cannot be null");
        }
        File file = new File(string = string.trim());
        if (file.exists() && file.isFile() && file.getName().endsWith(".chip")) {
            return new FileInMemoryChip(file.getName(), file.getPath());
        }
        if (string.toUpperCase().startsWith("AFFY")) {
            return VdbRuntimeResources.getChip_Affy();
        }
        Object object = kChipNameChipFileObject.get(string);
        if (object == null) {
            String string2 = VdbRuntimeResources.getChipFile_source(string);
            object = new FileInMemoryChip(string, string2);
            kChipNameChipFileObject.put(string, object);
        }
        return (Chip)object;
    }

    private static String _nameOrPath2Name(String string) {
        if (string.startsWith("ftp.")) {
            return string.substring("gseaftp.broadinstitute.org://pub/gsea/annotations/".length());
        }
        if (string.startsWith("ftp:")) {
            return string.substring(FTP_ANNOTATION_BASE.length());
        }
        if (string.startsWith("gseaftp.")) {
            return string.substring("gseaftp.broadinstitute.org://pub/gsea/annotations/".length());
        }
        if (string.startsWith("ftp:")) {
            return string.substring(FTP_ANNOTATION_BASE.length());
        }
        return new File(string).getName();
    }

    public static final void setChipPathBase(String string) {
        fChipLocBase = string;
    }

    public static final String getChipFile_source(String string) {
        String string2;
        if (string == null) {
            throw new IllegalArgumentException("Param chipNameOrPath cannot be null");
        }
        if (string.startsWith("ftp")) {
            if (string.startsWith("ftp.")) {
                string = "ftp://" + string;
            }
            return string;
        }
        if (string.startsWith("gseaftp")) {
            if (string.startsWith("gseaftp.")) {
                string = "ftp://" + string;
            }
            return string;
        }
        if ((string = string.replace('-', '_')).equalsIgnoreCase("GeneSymbol")) {
            string = "GENE_SYMBOL";
        }
        if (string.equalsIgnoreCase("SeqAccession")) {
            string = "SEQ_ACCESSION";
        }
        if (!(string2 = fChipLocBase + string).endsWith(".chip")) {
            string2 = string2 + ".chip";
        }
        return string2;
    }

    public static final String[] getChipNames_All() {
        if (kValidChipPlatformNames_tt == null) {
            FTPList fTPList = new FTPList(GseaWebResources.getGseaFTPServer(), GseaWebResources.getGseaFTPServerUserName(), GseaWebResources.getGseaFTPServerPassword(), GseaWebResources.getGseaFTPServerChipDir());
            fTPList.quit();
            kValidChipPlatformNames_tt = Arrays.asList(fTPList.getFileNames());
        }
        return kValidChipPlatformNames_tt.toArray(new String[kValidChipPlatformNames_tt.size()]);
    }

    public static final Chip[] getChips_All_safe() {
        try {
            return VdbRuntimeResources.getChips_All();
        }
        catch (Throwable throwable) {
            klog.error(throwable);
            return new Chip[0];
        }
    }

    public static final Chip[] getChips_All() {
        String[] stringArray = VdbRuntimeResources.getChipNames_All();
        ArrayList<Chip> arrayList = new ArrayList<Chip>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            String string = stringArray[i2];
            if (kChipNameErrors.contains(string)) continue;
            try {
                Chip chip = VdbRuntimeResources.getChip(stringArray[i2]);
                arrayList.add(chip);
                continue;
            }
            catch (Throwable throwable) {
                kChipNameErrors.add(string);
                throwable.printStackTrace();
            }
        }
        Collections.sort(arrayList, new ComparatorFactory$ChipNameComparator());
        return arrayList.toArray(new Chip[arrayList.size()]);
    }

    private static final String removeExtension(String string) {
        if (string.indexOf(35) != -1) {
            return string;
        }
        if (string.endsWith(".")) {
            return string.substring(0, string.length() - 1);
        }
        int n = string.lastIndexOf(46);
        if (-1 == n) {
            return string;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        if (string3.length() <= 4) {
            return string2;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string3, "_");
        stringTokenizer.nextToken();
        StringBuffer stringBuffer = new StringBuffer("_");
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (!stringTokenizer.hasMoreElements()) continue;
            stringBuffer.append("_");
        }
        if (stringBuffer.length() != 1) {
            return string2 + stringBuffer;
        }
        return string2;
    }

    private static final FilenameFilter createChip2ChipMapFnf() {
        return new VdbRuntimeResources$2();
    }

    static final /* synthetic */ Logger access$000() {
        return klog;
    }

    static {
        affy_prefixes_hack.add("HG");
        affy_prefixes_hack.add("HC");
        affy_prefixes_hack.add("HU");
        affy_prefixes_hack.add("Hu");
        affy_prefixes_hack.add("MG");
        affy_prefixes_hack.add("MOE");
        affy_prefixes_hack.add("Mu");
        affy_prefixes_hack.add("Mouse");
        kChipNameChipFileObject = new WeakHashMap();
        fChipLocBase = FTP_ANNOTATION_BASE = "ftp://gseaftp.broadinstitute.org/pub/gsea/annotations/";
        kChipNameErrors = new HashSet();
        kValidChipPlatformNames_tt = null;
    }
}

