/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.vdb;

import edu.mit.broad.genome.NotImplementedException;
import java.util.HashSet;
import java.util.Set;

public class Organism {
    public static final Organism GENERIC = new Organism("Generic", -999, null);
    public static final Organism XSPECIES = new Organism("Human,Mouse,Rat,Dog", -999, null);
    public static final Organism CHIMPANZEE = new Organism("Chimpanzee", -999, null);
    public static final Organism PIG = new Organism("Pig", -999, null);
    public static final Organism RHESUS = new Organism("Rhesus", -999, null);
    public static final Organism HUMAN = new Organism("Homo sapiens", 9606, "Hs");
    public static final Organism ZEBRA_FISH = new Organism("Zebra Fish", 7955, "Dr");
    public static final Organism HUMAN_en = new Organism("Human", 9606, "Hs");
    public static final Organism MOUSE = new Organism("Mus musculus", 10090, "Mm");
    public static final Organism MOUSE_en = new Organism("Mouse", 10090, "Mm");
    public static final Organism DROSOPHILLA = new Organism("Drosophilla", 7227, "Dm");
    public static final Organism RAT = new Organism("Rattus norvegicus", 10116, "Rn");
    public static final Organism RAT_EN = new Organism("Rat", 10116, "Rn");
    public static final Organism YEAST = new Organism("Saccharomyces cerevisiae", 4932, "Sc");
    public static final Organism ARABIDOPSIS = new Organism("Arabidopsis thaliana", 3702, "At");
    public static final Organism ECOLI = new Organism("Escherichia coli", 562, "Ec");
    public static final Organism CELEGANS = new Organism("Caenorhabditis elegans", 6239, "Ce");
    public static final Organism MALARIA = new Organism("Plasmodium falciparum", 5833, "Pf");
    public static final Organism DANIO = new Organism("Danio rerio", 5811, "Dr");
    public static final Organism MAC = new Organism("Macaca mulatta", 5891, "Mi");
    public static final Organism[] ALL_TAGS = new Organism[]{HUMAN, MOUSE, RAT, YEAST, DROSOPHILLA, XSPECIES};
    public static final Organism[] ALL_TAGS_en = new Organism[]{GENERIC, ZEBRA_FISH, PIG, CHIMPANZEE, HUMAN, HUMAN_en, MOUSE, MOUSE_en, RAT, RAT_EN, YEAST, DROSOPHILLA, XSPECIES, RHESUS, DANIO, MAC};
    private String fValue;
    private int fTaxonID;
    private String fUnigeneCode;

    public static final Set getTaxIds(Organism[] organismArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < organismArray.length; ++i2) {
            hashSet.add("" + organismArray[i2].getTaxonID());
        }
        return hashSet;
    }

    public static final Set getUnigeneCodes(Organism[] organismArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < organismArray.length; ++i2) {
            hashSet.add("" + organismArray[i2].getUnigeneCode());
        }
        return hashSet;
    }

    public static final String[] getNames(Organism[] organismArray) {
        String[] stringArray = new String[organismArray.length];
        for (int i2 = 0; i2 < organismArray.length; ++i2) {
            stringArray[i2] = organismArray[i2].getName();
        }
        return stringArray;
    }

    private Organism(String string, int n, String string2) {
        this.fValue = string;
        this.fTaxonID = n;
        this.fUnigeneCode = string2;
    }

    public Organism(Organism organism) {
        this.fValue = organism.fValue;
    }

    public final Object getValue() {
        return this.fValue;
    }

    public final String toString() {
        return this.fValue;
    }

    public final String toFormattedString() {
        return this.fValue;
    }

    public final String getName() {
        return this.fValue;
    }

    public final String getUnigeneCode() {
        if (this.fUnigeneCode == null) {
            throw new IllegalStateException("No known unigene code for organism: " + this.fUnigeneCode);
        }
        return this.fUnigeneCode;
    }

    public final int getTaxonID() {
        if (this.fTaxonID == -999) {
            throw new NotImplementedException(this.getName());
        }
        return this.fTaxonID;
    }

    public final boolean isHuman() {
        return this.fTaxonID == 9606;
    }

    public final boolean isGeneric() {
        return this.getName().equalsIgnoreCase("Generic");
    }

    public final boolean isMouse() {
        return this.fTaxonID == 10090;
    }

    public final boolean equals(String string) {
        if (string == null) {
            return false;
        }
        return this.fValue.equalsIgnoreCase(string);
    }

    public final boolean equals(Organism organism) {
        if (organism == null) {
            return false;
        }
        return this.equals(organism.fValue);
    }

    public static final Organism parseOrganism(String string) {
        if (string == null) {
            throw new NullPointerException("Param fromvalue cannot be null");
        }
        string = string.trim();
        for (int i2 = 0; i2 < ALL_TAGS_en.length; ++i2) {
            if (!string.equalsIgnoreCase(ALL_TAGS_en[i2].toFormattedString())) continue;
            return ALL_TAGS_en[i2];
        }
        throw new IllegalArgumentException("Cannot parse Organism from: " + string);
    }
}

