/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import com.jidesoft.grid.SortableTable;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.reports.api.Report;
import edu.mit.broad.genome.swing.GuiHelper;
import edu.mit.broad.genome.swing.SCLayout;
import edu.mit.broad.genome.viewers.AbstractViewer;
import edu.mit.broad.genome.viewers.ReportViewer$1;
import edu.mit.broad.genome.viewers.ReportViewer$Model;
import edu.mit.broad.xbench.core.JObjectsList;
import edu.mit.broad.xbench.tui.SingleToolLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Date;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class ReportViewer
extends AbstractViewer {
    public static final String NAME = "ReportViewer";
    public static final Icon ICON = JarResources.getIcon("past_analysis16.gif");
    private final Report fReport;
    private ReportViewer fInstance = this;
    private final Properties fParams;
    private static final String[] COL_HEADERS = new String[]{"Parameter name", "Parameter value"};

    public ReportViewer(Report report) {
        super(NAME, ICON, report);
        this.fReport = report;
        this.fParams = this.fReport.getParametersUsed();
        this.jbInit();
    }

    private void jbInit() {
        SCLayout sCLayout = new SCLayout(3);
        sCLayout.setRowScale(0, 0.1);
        sCLayout.setRowScale(1, 0.45);
        sCLayout.setRowScale(2, 0.45);
        this.setLayout(sCLayout);
        Date date = new Date(this.fReport.getTimestamp());
        StringBuffer stringBuffer = new StringBuffer("<html><body><b><f bold>Report: </b><font color=blue>").append(this.fReport.getName()).append("</font><br>");
        stringBuffer.append("<b>Date  : </b><font color=blue>").append(date.toString());
        stringBuffer.append("</font></body></html>");
        JLabel jLabel = new JLabel(stringBuffer.toString());
        this.add(jLabel);
        this.add(this.createParamPanel(this.fReport.getName()));
        JObjectsList jObjectsList = new JObjectsList(this.fReport.getFilesProduced());
        jObjectsList.setBorder(GuiHelper.createTitledBorderForComponent("Files produced as part of this analysis (double-click to view)"));
        this.add(new JScrollPane(jObjectsList));
        this.revalidate();
    }

    private JPanel createParamPanel(String string) {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        SortableTable sortableTable = new SortableTable(new ReportViewer$Model(this, null));
        sortableTable.setColumnSelectionAllowed(true);
        sortableTable.setRowSelectionAllowed(true);
        sortableTable.getTableHeader().setReorderingAllowed(false);
        ReportViewer.setColumnSize(75, 0, sortableTable, false);
        jPanel.add((Component)new JScrollPane(sortableTable), "Center");
        JPanel jPanel2 = new JPanel();
        JCheckBox jCheckBox = new JCheckBox("Load data", true);
        jCheckBox.setToolTipText("Follow files specified in params and load their data");
        jPanel2.add(jCheckBox);
        JButton jButton = new JButton("Show in ToolRunner", SingleToolLauncher.ICON);
        jButton.addActionListener(new ReportViewer$1(this, string, jCheckBox));
        jPanel2.add(jButton);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    @Override
    public final JMenuBar getJMenuBar() {
        return EMPTY_MENU_BAR;
    }

    static final /* synthetic */ Report access$100(ReportViewer reportViewer) {
        return reportViewer.fReport;
    }

    static final /* synthetic */ Properties access$200(ReportViewer reportViewer) {
        return reportViewer.fParams;
    }

    static final /* synthetic */ ReportViewer access$300(ReportViewer reportViewer) {
        return reportViewer.fInstance;
    }

    static final /* synthetic */ String[] access$400() {
        return COL_HEADERS;
    }
}

