/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.viewers;

import com.jidesoft.grid.SortableTable;
import edu.mit.broad.genome.JarResources;
import edu.mit.broad.genome.models.GeneSetMatrixModel2;
import edu.mit.broad.genome.objects.GeneSetMatrix;
import edu.mit.broad.genome.swing.PointLayout;
import edu.mit.broad.genome.viewers.AbstractViewer;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;

public class GeneSetMatrixViewer2
extends AbstractViewer {
    public static final String NAME = "GeneSetMatrixViewer2";
    public static final Icon ICON = JarResources.getIcon("Gmx.png");
    private final GeneSetMatrix fGmx;

    public GeneSetMatrixViewer2(GeneSetMatrix geneSetMatrix) {
        super(NAME, ICON, geneSetMatrix);
        this.fGmx = geneSetMatrix;
        this.init();
    }

    private void init() {
        GeneSetMatrixModel2 geneSetMatrixModel2 = new GeneSetMatrixModel2(this.fGmx);
        SortableTable sortableTable = GeneSetMatrixViewer2.createTable(geneSetMatrixModel2, true, true);
        ((JTable)sortableTable).setAutoResizeMode(0);
        this.setLayout(new PointLayout());
        JTabbedPane jTabbedPane = new JTabbedPane(3);
        JScrollPane jScrollPane = GeneSetMatrixViewer2.createExcelScrollPane(sortableTable, this.fGmx);
        jTabbedPane.addTab("Data", jScrollPane);
        jTabbedPane.addTab("Info", this.getGeneSetMatrixInfo(this.fGmx));
        this.add(jTabbedPane);
    }

    private JComponent getGeneSetMatrixInfo(GeneSetMatrix geneSetMatrix) {
        StringBuffer stringBuffer = new StringBuffer("Name: ").append(geneSetMatrix.getName()).append('\n');
        stringBuffer.append("Number of sets: ").append(geneSetMatrix.getNumGeneSets()).append('\n');
        stringBuffer.append("Total number of unique features: ").append(geneSetMatrix.getAllMemberNamesOnlyOnceS().size()).append('\n');
        String string = geneSetMatrix.getComment();
        if (string != null && string.length() > 0) {
            stringBuffer.append("\nComments\n");
            stringBuffer.append(geneSetMatrix.getComment());
        }
        stringBuffer.append("\nGene Set Names\n");
        for (int i2 = 0; i2 < geneSetMatrix.getNumGeneSets(); ++i2) {
            stringBuffer.append(geneSetMatrix.getGeneSet(i2).getName()).append('\t').append(geneSetMatrix.getGeneSet(i2).getNumMembers()).append('\n');
        }
        JTextArea jTextArea = new JTextArea(stringBuffer.toString());
        return new JScrollPane(jTextArea);
    }
}

