/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.XLogger;
import java.io.File;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeMap;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import org.apache.log4j.Logger;

public class SystemUtils {
    private static final Logger klog = XLogger.getLogger(SystemUtils.class);
    private static Boolean kIsLinuxOrUnix;

    public static final void dump() {
        klog.info(SystemUtils.asString());
    }

    public static final boolean isLinuxOrUnix() {
        if (kIsLinuxOrUnix == null) {
            String string = System.getProperty("os.name");
            kIsLinuxOrUnix = (string = string.toLowerCase()).indexOf("unix") != -1 || string.indexOf("linux") != -1 || string.equalsIgnoreCase("OSF1") ? Boolean.TRUE : Boolean.FALSE;
        }
        return kIsLinuxOrUnix;
    }

    public static final boolean isMac() {
        String string = System.getProperty("os.name").toLowerCase();
        return string.startsWith("mac os x");
    }

    public static final boolean getProperty_b(String string, boolean bl) {
        String string2 = SystemUtils.getProperty(string, bl);
        try {
            return Boolean.valueOf(string2);
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    public static final String getProperty(String string, boolean bl) {
        if (bl) {
            return System.getProperty(string);
        }
        String string2 = System.getProperty(string);
        if (string2 == null || string2.length() == 0) {
            string2 = System.getProperty(string.toLowerCase());
        }
        if (string2 == null || string2.length() == 0) {
            string2 = System.getProperty(string.toUpperCase());
        }
        return string2;
    }

    public static final String asString() {
        StringBuffer stringBuffer = new StringBuffer();
        Properties properties = System.getProperties();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            String string = iterator.next().toString();
            String string2 = properties.getProperty(string);
            stringBuffer.append(string).append('=').append((Object)string2).append('\n');
        }
        return stringBuffer.toString();
    }

    public static final TableModel asTableModel() {
        Object object;
        Object object2;
        Properties properties = System.getProperties();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        Iterator<Object> iterator = properties.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next().toString();
            object = properties.getProperty((String)object2);
            treeMap.put((String)object2, (String)object);
        }
        iterator = treeMap.keySet().iterator();
        object2 = new DefaultTableModel(0, 2);
        while (iterator.hasNext()) {
            object = iterator.next();
            Object v = treeMap.get(object);
            ((DefaultTableModel)object2).addRow(new Object[]{object, v});
        }
        ((DefaultTableModel)object2).setColumnIdentifiers(new String[]{"Name", "Value"});
        return object2;
    }

    public static final String getUserName() {
        return System.getProperty("user.name");
    }

    public static final File getUserHome() {
        return new File(System.getProperty("user.home"));
    }

    public static final boolean endsWith(File file, String string) {
        return file.getName().endsWith(string) || file.getName().endsWith(string + "/") || file.getName().endsWith(string + "\\");
    }

    public static final String getUserHomePath() {
        return System.getProperty("user.home");
    }

    public static final String getJavaPath() {
        return SystemUtils.getJavaHome() + File.separator + "bin" + File.separator + "java";
    }

    public static final String getJavaHome() {
        return System.getProperty("java.home").trim();
    }

    public static final String getClassPath() {
        return System.getProperty("java.class.path").trim();
    }

    public static final File getPwd() {
        return new File(System.getProperty("user.dir"));
    }

    public static final File getTmpDir() {
        return new File(System.getProperty("java.io.tmpdir"));
    }

    public static final String getJnlpHeapMaxSize() {
        String string = SystemUtils.getJnlpHeapValue();
        if (string == null) {
            return null;
        }
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            if (stringTokenizer.countTokens() == 2) {
                stringTokenizer.nextToken();
                return stringTokenizer.nextToken();
            }
        }
        catch (Throwable throwable) {
            klog.debug(throwable);
        }
        return null;
    }

    public static final String getJnlpHeapValue() {
        return System.getProperty("jnlpx.heapsize");
    }

    public static final boolean isHeadless() {
        return SystemUtils.isPropertyTrue("java.awt.headless");
    }

    public static final boolean isPropertyTrue(String string) {
        String string2 = SystemUtils.getProperty(string, false);
        return Boolean.valueOf(string2);
    }

    public static final boolean isPropertyDefined(String string) {
        String string2 = SystemUtils.getProperty(string, false);
        return string2 != null && string2.trim().length() != 0;
    }

    public static final File getFile(String string) {
        String string2 = System.getProperty(string);
        return new File(string2);
    }
}

