/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.utils.WordEntry;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;

public class Strings {
    public static final String SAFE_NAME_CHARACTERS = "^[a-zA-Z\\_.\\-0-9]+$";
    private static final String EOL = System.getProperty("line.separator");
    private static final int EOL_LENGTH = EOL.length();
    private static final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    protected Strings() {
    }

    public static final boolean equals(char c2, char c3, boolean bl) {
        if (bl) {
            return Character.toUpperCase(c2) == Character.toUpperCase(c3) || Character.toLowerCase(c2) == Character.toLowerCase(c3);
        }
        return c2 == c3;
    }

    public static final boolean equals(String string, String string2, boolean bl) {
        if (bl) {
            return string.equalsIgnoreCase(string2);
        }
        return string.equals(string2);
    }

    public static final int compare(String string, String string2) {
        return string.compareTo(string2);
    }

    public static final boolean startsWith(String string, String string2, boolean bl) {
        return string.regionMatches(bl, 0, string2, 0, string2.length());
    }

    public static final boolean startsWith(String string, String string2) {
        return string.startsWith(string2);
    }

    public static final boolean startsWith(String string, String string2, int n) {
        return string.startsWith(string2, n);
    }

    public static final boolean startsWith(String string, String string2, int n, boolean bl) {
        return string.regionMatches(bl, n, string2, 0, string2.length());
    }

    public static final boolean endsWith(String string, String string2, boolean bl) {
        int n = string.length() - string2.length();
        return string.regionMatches(bl, n, string2, 0, string2.length());
    }

    public static final boolean endsWith(String string, String string2) {
        return string.endsWith(string2);
    }

    public static final int indexOf(String string, String string2, int n) {
        return string.indexOf(string2, n);
    }

    public static final int indexOf(String string, String string2, int n, boolean bl) {
        if (bl) {
            int n2 = string.length();
            int n3 = string2.length();
            int n4 = n3 - 1;
            int n5 = n2 - n3;
            if (n3 == 0 || n > n5) {
                return -1;
            }
            char c2 = string2.charAt(0);
            for (int i2 = n < 0 ? 0 : n; i2 < n5; ++i2) {
                if (!Strings.equals(string.charAt(i2), c2, bl) || !string.regionMatches(bl, i2 + 1, string2, 1, n4)) continue;
                return i2;
            }
            return -1;
        }
        return string.indexOf(string2, n);
    }

    public static final int indexOf(String string, String string2, boolean bl) {
        return Strings.indexOf(string, string2, 0, bl);
    }

    public static final int indexOf(String string, String string2) {
        return string.indexOf(string2);
    }

    public static final int indexOf(String string, char c2) {
        return string.indexOf(c2);
    }

    public static final int indexOf(String string, char c2, int n, boolean bl) {
        if (bl) {
            int n2 = string.length();
            if (n < 0) {
                n = 0;
            }
            if (n >= n2) {
                return -1;
            }
            for (int i2 = n; i2 < n2; ++i2) {
                if (!Strings.equals(string.charAt(i2), c2, bl)) continue;
                return i2;
            }
            return -1;
        }
        return string.indexOf(c2, n);
    }

    public static final int indexOf(String string, char c2, boolean bl) {
        return Strings.indexOf(string, c2, 0, bl);
    }

    public static final int indexOf(String string, char c2, int n) {
        return string.indexOf(c2, n);
    }

    public static final int indexOfAnyOf(String string, String string2, int n) {
        int n2;
        int n3 = string2.length();
        int n4 = n2 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string2.charAt(i2);
            int n5 = string.indexOf(c2, n);
            if (n5 < 0 || n5 >= n4) continue;
            n4 = n5;
        }
        return n4 < n2 ? n4 : -1;
    }

    public static final int indexOfAnyOf(String string, String string2, int n, boolean bl) {
        int n2;
        int n3 = string2.length();
        int n4 = n2 = string.length();
        for (int i2 = 0; i2 < n3; ++i2) {
            char c2 = string2.charAt(i2);
            int n5 = Strings.indexOf(string, c2, n, bl);
            if (n5 < 0 || n5 >= n4) continue;
            n4 = n5;
        }
        return n4 < n2 ? n4 : -1;
    }

    public static final int indexOfAnyOf(String string, String string2, boolean bl) {
        return Strings.indexOfAnyOf(string, string2, 0, bl);
    }

    public static final int indexOfAnyOf(String string, String string2) {
        return Strings.indexOfAnyOf(string, string2, 0);
    }

    public static final int indexOfAnyBut(String string, String string2, int n, boolean bl) {
        int n2 = string.length();
        int n3 = -1;
        for (int i2 = n; i2 < n2; ++i2) {
            char c2 = string.charAt(i2);
            if (Strings.indexOf(string2, c2, bl) >= 0) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    public static final int indexOfAnyBut(String string, String string2, boolean bl) {
        return Strings.indexOfAnyBut(string, string2, 0, bl);
    }

    public static final int indexOfAnyBut(String string, String string2, int n) {
        return Strings.indexOfAnyBut(string, string2, n, false);
    }

    public static final int indexOfAnyBut(String string, String string2) {
        return Strings.indexOfAnyBut(string, string2, 0, false);
    }

    public static final int occurrencesOf(String string, String string2, int n, boolean bl) {
        int n2 = string2.length();
        int n3 = 0;
        if (n > string.length() - n2) {
            return 0;
        }
        if (n2 > 0) {
            int n4;
            while ((n4 = Strings.indexOf(string, string2, n, bl)) >= 0) {
                ++n3;
                n = n4 + n2;
            }
        }
        return n3;
    }

    public static final int occurrencesOf(String string, String string2, boolean bl) {
        return Strings.occurrencesOf(string, string2, 0, bl);
    }

    public static final int occurrencesOf(String string, String string2, int n) {
        return Strings.occurrencesOf(string, string2, n, false);
    }

    public static final int occurrencesOf(String string, String string2) {
        return Strings.occurrencesOf(string, string2, 0, false);
    }

    public static final int lastIndexOf(String string, String string2, int n, boolean bl) {
        if (bl) {
            int n2 = string.length();
            int n3 = string2.length();
            int n4 = n3 - 1;
            int n5 = n2 - n3;
            if (n3 == 0 || n < 0) {
                return -1;
            }
            char c2 = string2.charAt(0);
            for (int i2 = n >= n5 ? n5 : n; i2 >= 0; --i2) {
                if (!Strings.equals(string.charAt(i2), c2, bl) || !string.regionMatches(bl, i2 + 1, string2, 1, n4)) continue;
                return i2;
            }
            return -1;
        }
        return string.lastIndexOf(string2, n);
    }

    public static final int lastIndexOf(String string, String string2, boolean bl) {
        return Strings.lastIndexOf(string, string2, Integer.MAX_VALUE, bl);
    }

    public static final int lastIndexOf(String string, String string2, int n) {
        return string.lastIndexOf(string2, n);
    }

    public static final int lastIndexOf(String string, String string2) {
        return string.lastIndexOf(string2);
    }

    public static final int lastIndexOf(String string, char c2, int n, boolean bl) {
        if (bl) {
            int n2 = string.length();
            if (n < 0) {
                return -1;
            }
            if (n >= n2) {
                n = n2 - 1;
            }
            for (int i2 = n; i2 >= 0; --i2) {
                if (!Strings.equals(string.charAt(i2), c2, bl)) continue;
                return i2;
            }
            return -1;
        }
        return string.lastIndexOf(c2, n);
    }

    public static final int lastIndexOf(String string, char c2, int n) {
        return string.lastIndexOf(c2, n);
    }

    public static final int lastIndexOf(String string, char c2) {
        return string.lastIndexOf(c2);
    }

    public static final int lastIndexOfAnyBut(String string, String string2, int n, boolean bl) {
        int n2 = string.length() - 1;
        int n3 = -1;
        for (int i2 = n = n < n2 ? n : n2; i2 >= 0; --i2) {
            char c2 = string.charAt(i2);
            if (Strings.indexOf(string2, c2, bl) >= 0) continue;
            n3 = i2;
            break;
        }
        return n3;
    }

    public static final int lastIndexOfAnyBut(String string, String string2, int n) {
        return Strings.lastIndexOfAnyBut(string, string2, n, false);
    }

    public static final int lastIndexOfAnyBut(String string, String string2) {
        return Strings.lastIndexOfAnyBut(string, string2, Integer.MAX_VALUE, false);
    }

    public static final int lastIndexOfAnyOf(String string, String string2, int n, boolean bl) {
        int n2 = string2.length();
        int n3 = string.length();
        int n4 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            char c2 = string2.charAt(i2);
            int n5 = Strings.lastIndexOf(string, c2, n, bl);
            if (n5 < 0 || n5 <= n4) continue;
            n4 = n5;
        }
        return n4;
    }

    public static final int lastIndexOfAnyOf(String string, String string2, int n) {
        return Strings.lastIndexOfAnyOf(string, string2, n, false);
    }

    public static final int lastIndexOfAnyOf(String string, String string2) {
        return Strings.lastIndexOfAnyOf(string, string2, Integer.MAX_VALUE, false);
    }

    public static final String stripLeading(String string, String string2, boolean bl) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && Strings.indexOf(string2, string.charAt(n), bl) >= 0; ++n) {
        }
        return string.substring(n);
    }

    public static final String stripLeading(String string, String string2) {
        return Strings.stripLeading(string, string2, false);
    }

    public static final String stripLeading(String string, char c2, boolean bl) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && Strings.equals(string.charAt(n), c2, bl); ++n) {
        }
        return string.substring(n);
    }

    public static final String stripLeading(String string, char c2) {
        return Strings.stripLeading(string, c2, false);
    }

    public static final String stripLeadingBlanks(String string) {
        int n;
        int n2 = string.length();
        for (n = 0; n < n2 && Character.isWhitespace(string.charAt(n)); ++n) {
        }
        return string.substring(n);
    }

    public static final String stripTrailing(String string, String string2, boolean bl) {
        int n;
        for (n = string.length() - 1; n >= 0 && Strings.indexOf(string2, string.charAt(n), bl) >= 0; --n) {
        }
        return string.substring(0, n + 1);
    }

    public static final String stripTrailing(String string, String string2) {
        return Strings.stripTrailing(string, string2, false);
    }

    public static final String stripTrailing(String string, char c2, boolean bl) {
        int n;
        for (n = string.length() - 1; n >= 0 && Strings.equals(string.charAt(n), c2, bl); --n) {
        }
        return string.substring(0, n + 1);
    }

    public static final String stripTrailing(String string, char c2) {
        return Strings.stripTrailing(string, c2, false);
    }

    public static final String stripTrailingBlanks(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && Character.isWhitespace(string.charAt(n)); --n) {
        }
        return string.substring(0, n + 1);
    }

    public static final String strip(String string, String string2, boolean bl) {
        String string3 = Strings.stripLeading(string, string2, bl);
        return Strings.stripTrailing(string3, string2, bl);
    }

    public static final String strip(String string, String string2) {
        return Strings.strip(string, string2, false);
    }

    public static final String strip(String string, char c2, boolean bl) {
        String string2 = Strings.stripLeading(string, c2, bl);
        return Strings.stripTrailing(string2, c2, bl);
    }

    public static final String strip(String string, char c2) {
        return Strings.strip(string, c2, false);
    }

    public static final String stripBlanks(String string) {
        return string.trim();
    }

    public static final String center(String string, int n, char c2) {
        int n2 = string.length();
        if (n < 1) {
            return "";
        }
        char[] cArray = new char[n];
        for (int i2 = 0; i2 < n; ++i2) {
            cArray[i2] = c2;
        }
        if (n > n2) {
            int n3 = (n - n2) / 2;
            string.getChars(0, n2, cArray, n3);
        } else {
            int n4 = (n2 - n) / 2;
            string.getChars(n4, n4 + n, cArray, 0);
        }
        return new String(cArray);
    }

    public static final String center(String string, int n) {
        return Strings.center(string, n, ' ');
    }

    public static final String change(String string, String string2, String string3, int n, int n2, boolean bl) {
        int n3;
        int n4;
        int n5 = string2.length();
        int n6 = string3.length();
        int n7 = n4 = string.length();
        int n8 = 0;
        if (n5 == 0 || n >= n4) {
            return string;
        }
        if (n < 0) {
            n = 0;
        }
        int n9 = n;
        if (n6 > n5) {
            int n10 = Strings.occurrencesOf(string, string2, n, bl);
            n7 = n4 + n10 * (n6 - n5);
        }
        char[] cArray = new char[n7];
        string.getChars(0, n, cArray, 0);
        int n11 = n;
        while ((n3 = Strings.indexOf(string, string2, n9, bl)) >= 0 && n8++ < n2) {
            string.getChars(n9, n3, cArray, n11);
            string3.getChars(0, n6, cArray, n11 += n3 - n9);
            n9 = n3 + n5;
            n11 += n6;
        }
        string.getChars(n9, n4, cArray, n11);
        return new String(cArray, 0, n11 - n9 + n4);
    }

    public static final String change(String string, String string2, String string3, int n, boolean bl) {
        return Strings.change(string, string2, string3, n, Integer.MAX_VALUE, bl);
    }

    public static final String change(String string, String string2, String string3, int n, int n2) {
        return Strings.change(string, string2, string3, n, n2, false);
    }

    public static final String change(String string, String string2, String string3, int n) {
        return Strings.change(string, string2, string3, n, Integer.MAX_VALUE);
    }

    public static final String change(String string, String string2, String string3, boolean bl) {
        return Strings.change(string, string2, string3, 0, Integer.MAX_VALUE, bl);
    }

    public static final String change(String string, String string2, String string3) {
        return Strings.change(string, string2, string3, 0, Integer.MAX_VALUE, false);
    }

    public static final String change(String string, char c2, char c3, int n, int n2, boolean bl) {
        int n3;
        int n4 = string.length();
        int n5 = 0;
        if (n >= n4) {
            return string;
        }
        if (n < 0) {
            n = 0;
        }
        int n6 = n;
        char[] cArray = new char[n4];
        string.getChars(0, n, cArray, 0);
        int n7 = n;
        while ((n3 = Strings.indexOf(string, c2, n6, bl)) >= 0 && n5++ < n2) {
            string.getChars(n6, n3, cArray, n6);
            cArray[n3] = c3;
            n6 = n3 + 1;
        }
        string.getChars(n6, n4, cArray, n6);
        return new String(cArray, 0, n4);
    }

    public static final String change(String string, char c2, char c3, int n, int n2) {
        return Strings.change(string, c2, c3, n, n2, false);
    }

    public static final String change(String string, char c2, char c3, int n, boolean bl) {
        return Strings.change(string, c2, c3, n, Integer.MAX_VALUE, bl);
    }

    public static final String change(String string, char c2, char c3, int n) {
        return Strings.change(string, c2, c3, n, Integer.MAX_VALUE, false);
    }

    public static final String change(String string, char c2, char c3) {
        return string.replace(c2, c3);
    }

    public static final String copies(String string, int n) {
        int n2 = string.length();
        if (n < 1) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(n2 * n);
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static final String insert(String string, String string2, int n, char c2) {
        int n2;
        int n3 = string.length();
        int n4 = string2.length();
        if (n < 0) {
            return "";
        }
        int n5 = n > n3 ? n4 + n : n3 + n4;
        int n6 = n2 = n > n3 ? n3 : n;
        char[] cArray = new char[n5];
        string.getChars(0, n2, cArray, 0);
        while (n2 < n) {
            cArray[n2++] = c2;
        }
        string2.getChars(0, n4, cArray, n2);
        string.getChars(n6, n3, cArray, n2 + n4);
        return new String(cArray);
    }

    public static final String insert(String string, String string2, int n) {
        return Strings.insert(string, string2, n, ' ');
    }

    public static final String leftJustify(String string, int n, char c2) {
        int n2;
        int n3 = string.length();
        int n4 = n2 = n < n3 ? n : n3;
        if (n < 1) {
            return "";
        }
        char[] cArray = new char[n];
        string.getChars(0, n2, cArray, 0);
        while (n2 < n) {
            cArray[n2++] = c2;
        }
        return new String(cArray);
    }

    public static final String leftJustify(String string, int n) {
        return Strings.leftJustify(string, n, ' ');
    }

    public static final String rightJustify(String string, int n, char c2) {
        int n2 = string.length();
        if (n < 1) {
            return "";
        }
        char[] cArray = new char[n];
        if (n > n2) {
            int n3 = n - n2;
            string.getChars(0, n2, cArray, n3);
            while (n3 > 0) {
                cArray[--n3] = c2;
            }
        } else {
            int n4 = n2 - n;
            string.getChars(n4, n2, cArray, 0);
        }
        return new String(cArray);
    }

    public static final String rightJustify(String string, int n) {
        return Strings.rightJustify(string, n, ' ');
    }

    public static final String toLowerCase(String string) {
        return string.toLowerCase();
    }

    public static final String toLowerCase(String string, Locale locale) {
        return string.toLowerCase(locale);
    }

    public static final String toUpperCase(String string) {
        return string.toUpperCase();
    }

    public static final String toUpperCase(String string, Locale locale) {
        return string.toUpperCase(locale);
    }

    public static final String toTitleCase(String string) {
        int n = string.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        for (int i2 = 0; i2 < n; ++i2) {
            Character.toTitleCase(cArray[i2]);
        }
        return new String(cArray);
    }

    public static final String overlayWith(String string, String string2, int n, char c2) {
        int n2 = string.length();
        int n3 = string2.length();
        if (n < 0) {
            return "";
        }
        int n4 = n + n3;
        int n5 = n >= n2 ? n2 : n;
        int n6 = n4 < n2 ? n2 : n4;
        char[] cArray = new char[n6];
        string.getChars(0, n5, cArray, 0);
        for (int i2 = n2; i2 < n; ++i2) {
            cArray[i2] = c2;
        }
        string2.getChars(0, n3, cArray, n);
        if (n4 < n2) {
            string.getChars(n4, n2, cArray, n4);
        }
        return new String(cArray);
    }

    public static final String overlayWith(String string, String string2, int n) {
        return Strings.overlayWith(string, string2, n, ' ');
    }

    public static final String remove(String string, int n, int n2) {
        int n3 = string.length();
        if (n >= n3 || n < 0 || n2 < 1) {
            return string;
        }
        if (n > n3 - n2) {
            n2 = n3 - n;
        }
        int n4 = n3 - n2;
        char[] cArray = new char[n4];
        string.getChars(0, n, cArray, 0);
        string.getChars(n + n2, n3, cArray, n);
        return new String(cArray);
    }

    public static final String substring(String string, int n, int n2, char c2) {
        int n3 = string.length();
        if (n < 0 || n >= n3) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n2 > n3 - n) {
            char[] cArray = new char[n2];
            string.getChars(n, n3, cArray, 0);
            for (int i2 = n3 - n; i2 < n2; ++i2) {
                cArray[i2] = c2;
            }
            return new String(cArray);
        }
        return string.substring(n, n + n2);
    }

    public static final String substring(String string, int n, int n2) {
        return Strings.substring(string, n, n2, ' ');
    }

    public static final String substring(String string, int n) {
        return string.substring(n);
    }

    public static final String reverse(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.reverse();
        return stringBuffer.toString();
    }

    public static final String translate(String string, String string2, String string3, char c2, boolean bl) {
        int n = string.length();
        int n2 = string3.length();
        char[] cArray = new char[n];
        string.getChars(0, n, cArray, 0);
        int n3 = 0;
        while ((n3 = Strings.indexOfAnyOf(string, string2, n3, bl)) >= 0) {
            int n4 = Strings.indexOf(string2, cArray[n3], bl);
            cArray[n3] = n4 >= n2 ? c2 : string3.charAt(n4);
            ++n3;
        }
        return new String(cArray);
    }

    public static final String translate(String string, String string2, String string3, char c2) {
        return Strings.translate(string, string2, string3, c2, false);
    }

    public static final String translate(String string, String string2, String string3, boolean bl) {
        return Strings.translate(string, string2, string3, ' ', bl);
    }

    public static final String translate(String string, String string2, String string3) {
        return Strings.translate(string, string2, string3, ' ');
    }

    public static final String xRange(char c2, char c3) {
        if (c2 <= c3) {
            int n = c3 - c2 + 1;
            char[] cArray = new char[n];
            for (int i2 = 0; i2 < n; ++i2) {
                cArray[i2] = (char)(c2 + i2);
            }
            return new String(cArray);
        }
        return "";
    }

    public static final boolean contains(String string, String string2, boolean bl) {
        return Strings.indexOf(string, string2, bl) >= 0;
    }

    public static final boolean contains(String string, String string2) {
        return string.indexOf(string2) >= 0;
    }

    public static final boolean isAbbreviationOf(String string, String string2, int n, boolean bl) {
        int n2 = string.length();
        if (n > n2 || n < 0) {
            return false;
        }
        if (n == 0) {
            n = n2;
        }
        return string.regionMatches(bl, 0, string2, 0, n);
    }

    public static final boolean isAbbreviationOf(String string, String string2, int n) {
        return Strings.isAbbreviationOf(string, string2, n, false);
    }

    public static final boolean isAbbreviationOf(String string, String string2, boolean bl) {
        return string.regionMatches(bl, 0, string2, 0, string.length());
    }

    public static final boolean isLike(String string, String string2, int n, char c2, char c3, boolean bl) {
        int n2 = string.length();
        int n3 = string2.length();
        if (n3 == 0) {
            return false;
        }
        char c4 = ' ';
        int n4 = n;
        int n5 = 0;
        int n6 = -1;
        int n7 = 0;
        while (n5 <= n3 && n4 <= n2) {
            if (n5 < n3) {
                c4 = string2.charAt(n5);
                if (c4 == c2) {
                    n6 = n5++;
                    n7 = n4;
                    continue;
                }
                if (n4 < n2) {
                    if (c4 == c3 || Strings.equals(string.charAt(n4), string2.charAt(n5), bl)) {
                        ++n5;
                        ++n4;
                        continue;
                    }
                    if (n6 < 0) {
                        return false;
                    }
                    n5 = n6;
                    n4 = ++n7;
                    continue;
                }
                return false;
            }
            if (c4 == c2) {
                return true;
            }
            if (n4 < n2 && n6 >= 0) {
                n5 = n6 + 1;
                n4 = ++n7;
                continue;
            }
            return n4 >= n2;
        }
        return true;
    }

    public static final boolean isLike(String string, String string2, int n, boolean bl) {
        return Strings.isLike(string, string2, n, '*', '?', bl);
    }

    public static final boolean isLike(String string, String string2, int n) {
        return Strings.isLike(string, string2, n, '*', '?', false);
    }

    public static final boolean isLike(String string, String string2) {
        return Strings.isLike(string, string2, 0, '*', '?', false);
    }

    public static final int indexOfWord(String string, int n) {
        int n2 = string.length();
        if (n < 0) {
            return -1;
        }
        ++n;
        int n3 = 0;
        while (n3 < n2) {
            while (n3 < n2 && Character.isWhitespace(string.charAt(n3))) {
                ++n3;
            }
            if (n3 >= n2) continue;
            if (--n == 0) break;
            ++n3;
            while (n3 < n2 && !Character.isWhitespace(string.charAt(n3))) {
                ++n3;
            }
            ++n3;
        }
        if (n > 0) {
            n3 = -1;
        }
        return n3;
    }

    public static final int indexOfPhrase(String string, String string2, int n, boolean bl) {
        WordEntry wordEntry = Strings.wordEntryOfPhrase(string, string2, n, bl);
        if (wordEntry == null) {
            return -1;
        }
        return wordEntry.start;
    }

    public static final int indexOfPhrase(String string, String string2, int n) {
        return Strings.indexOfPhrase(string, string2, n, false);
    }

    public static final int numWords(String string) {
        int n = string.length();
        int n2 = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            while (i2 < n && Character.isWhitespace(string.charAt(i2))) {
                ++i2;
            }
            if (i2++ < n) {
                ++n2;
            }
            while (i2 < n && !Character.isWhitespace(string.charAt(i2))) {
                ++i2;
            }
        }
        return n2;
    }

    public static final String removeWords(String string, int n, int n2) {
        if (n < 0 || n2 <= 0) {
            return string;
        }
        int n3 = Strings.indexOfWord(string, n);
        if (n3 >= 0) {
            int n4 = Strings.indexOfWord(string.substring(n3), n2);
            if (n4 >= 0) {
                return Strings.remove(string, n3, n4);
            }
            return string.substring(0, n3);
        }
        return string;
    }

    public static final String wordSpace(String string, int n) {
        Object object;
        int n2;
        int n3 = string.length();
        if (n < 0) {
            return string;
        }
        Vector vector = Strings.buildWordList(string, n3);
        int n4 = vector.size();
        if (n4 == 0) {
            return "";
        }
        int n5 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            object = (WordEntry)vector.elementAt(n2);
            n5 += ((WordEntry)object).len;
        }
        object = new char[n5 + (n4 - 1) * n];
        int n6 = 0;
        for (n2 = 0; n2 < n4; ++n2) {
            WordEntry wordEntry = (WordEntry)vector.elementAt(n2);
            string.getChars(wordEntry.start, wordEntry.start + wordEntry.len, (char[])object, n6);
            n6 += wordEntry.len;
            if (n2 >= n4 - 1) continue;
            for (int i2 = 0; i2 < n; ++i2) {
                object[n6++] = 32;
            }
        }
        return new String((char[])object);
    }

    public static final String word(String string, int n) {
        int n2 = string.length();
        if (n < 0) {
            return "";
        }
        int n3 = Strings.indexOfWord(string, n);
        if (n3 >= 0) {
            int n4;
            for (n4 = n3; n4 < n2 && !Character.isWhitespace(string.charAt(n4)); ++n4) {
            }
            return string.substring(n3, n4);
        }
        return "";
    }

    public static final int wordIndexOfPhrase(String string, String string2, int n, boolean bl) {
        WordEntry wordEntry = Strings.wordEntryOfPhrase(string, string2, n, bl);
        if (wordEntry == null) {
            return -1;
        }
        return wordEntry.wordNum;
    }

    public static final int wordIndexOfPhrase(String string, String string2, int n) {
        return Strings.wordIndexOfPhrase(string, string2, n, false);
    }

    public static final String subWords(String string, int n, int n2) {
        int n3 = string.length();
        if (n < 0 || n2 <= 0) {
            return "";
        }
        int n4 = Strings.indexOfWord(string, n);
        if (n4 >= 0) {
            int n5 = Strings.indexOfWord(string.substring(n4), n2 - 1);
            if (n5 >= 0) {
                int n6;
                for (n6 = n4 + n5; n6 < n3 && !Character.isWhitespace(string.charAt(n6)); ++n6) {
                }
                return string.substring(n4, n6);
            }
            return Strings.stripTrailingBlanks(string.substring(n4));
        }
        return "";
    }

    public static final String[] split(String string) {
        return Strings.split(string, Integer.MAX_VALUE);
    }

    public static final String[] split(String string, int n) {
        String[] stringArray = new String[Math.min(n, Strings.numWords(string))];
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringArray[i2] = Strings.subWords(string, i2, 1);
        }
        return stringArray;
    }

    public static final boolean toBoolean(String string) {
        return Boolean.valueOf(string);
    }

    public static final byte toByte(String string) {
        return Byte.valueOf(string);
    }

    public static final byte toByte(String string, int n) {
        return Byte.valueOf(string, n);
    }

    public static final short toShort(String string, int n) {
        return Short.valueOf(string, n);
    }

    public static final short toShort(String string) {
        return Short.valueOf(string);
    }

    public static final int toInt(String string) {
        return Integer.valueOf(string);
    }

    public static final int toInt(String string, int n) {
        return Integer.valueOf(string, n);
    }

    public static final long toLong(String string) {
        return Long.valueOf(string);
    }

    public static final long toLong(String string, int n) {
        return Long.valueOf(string, n);
    }

    public static final float toFloat(String string) {
        return Float.valueOf(string).floatValue();
    }

    public static final double toDouble(String string) {
        return Double.valueOf(string);
    }

    public static final boolean isDigit(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isIdentifierIgnorable(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isIdentifierIgnorable(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isISOControl(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isISOControl(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isJavaIdentifier(String string) {
        int n = string.length();
        if (n == 0 || !Character.isJavaIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < n; ++i2) {
            if (Character.isJavaIdentifierPart(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isLetter(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isLetter(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isLetterOrDigit(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isLetterOrDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isLowerCase(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isLowerCase(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isSpaceChar(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isSpaceChar(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isTitleCase(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isTitleCase(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isUnicodeIdentifier(String string) {
        int n = string.length();
        if (n == 0 || !Character.isUnicodeIdentifierStart(string.charAt(0))) {
            return false;
        }
        for (int i2 = 1; i2 < n; ++i2) {
            if (Character.isUnicodeIdentifierPart(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isUpperCase(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isUpperCase(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final boolean isWhitespace(String string) {
        int n = string.length();
        for (int i2 = 0; i2 < n; ++i2) {
            if (Character.isWhitespace(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    private static Vector buildWordList(String string, int n) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        Vector<WordEntry> vector = new Vector<WordEntry>();
        int n5 = 0;
        while (n5 < n) {
            while (n5 < n && Character.isWhitespace(string.charAt(n5))) {
                ++n5;
            }
            n2 = n5++;
            if (n5 >= n) continue;
            while (n5 < n && !Character.isWhitespace(string.charAt(n5))) {
                ++n5;
            }
            n3 = n5++;
            WordEntry wordEntry = new WordEntry(n2, n3 - n2, n4++);
            vector.addElement(wordEntry);
        }
        return vector;
    }

    private static WordEntry wordEntryOfPhrase(String string, String string2, int n, boolean bl) {
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0 || n3 == 0) {
            return null;
        }
        if (n < 0) {
            n = 0;
        }
        Vector vector = Strings.buildWordList(string, n2);
        Vector vector2 = Strings.buildWordList(string2, n3);
        int n4 = vector.size();
        int n5 = vector2.size();
        int n6 = n;
        int n7 = 0;
        int n8 = n;
        int n9 = -1;
        while (n6 < n4 && n7 < n5) {
            WordEntry wordEntry = (WordEntry)vector.elementAt(n6);
            WordEntry wordEntry2 = (WordEntry)vector2.elementAt(n7);
            if (string.regionMatches(bl, wordEntry.start, string2, wordEntry2.start, wordEntry2.len)) {
                ++n6;
                ++n7;
                continue;
            }
            n6 = ++n8;
            n7 = 0;
        }
        if (n7 == n5) {
            return (WordEntry)vector.elementAt(n8);
        }
        return null;
    }

    public final String concat(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer.append(list.get(i2).toString());
        }
        return stringBuffer.toString();
    }

    public static final String getPackageAsPath(String string) {
        return string.replace('.', File.separator.charAt(0)) + File.separator;
    }

    public static final String removeUnderScores(String string) {
        String string2 = null;
        StringBuffer stringBuffer = new StringBuffer();
        string2 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "_");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = (String)stringTokenizer.nextElement();
            stringBuffer.append(Strings.firstLetterCaps(string3));
        }
        return stringBuffer.toString();
    }

    public static final String removeAndHump(String string) {
        return Strings.removeAndHump(string, "_");
    }

    public static final String removeAndHump(String string, String string2) {
        String string3 = null;
        StringBuffer stringBuffer = new StringBuffer();
        string3 = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string3, string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = (String)stringTokenizer.nextElement();
            stringBuffer.append(Strings.capitalizeFirstLetter(string4));
        }
        return stringBuffer.toString();
    }

    public static final String firstLetterCaps(String string) {
        String string2 = string.substring(0, 1).toUpperCase();
        String string3 = string.substring(1).toLowerCase();
        return string2 + string3;
    }

    public static final String capitalizeFirstLetter(String string) {
        String string2 = string.substring(0, 1).toUpperCase();
        String string3 = string.substring(1);
        return string2 + string3;
    }

    public static final String sentenceCase(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreElements()) {
            stringBuffer.append(Strings.capitalizeFirstLetter(stringTokenizer.nextToken())).append(' ');
        }
        String string2 = stringBuffer.toString();
        string2 = string2.trim();
        return string2;
    }

    public static final StringBuffer sentenceCase(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(stringBuffer.toString(), " ");
        int n = stringTokenizer.countTokens();
        for (int i2 = 0; i2 < n; ++i2) {
            stringBuffer2.append(Strings.capitalizeFirstLetter(stringTokenizer.nextToken()));
            if (i2 == n - 1) continue;
            stringBuffer2.append(' ');
        }
        return stringBuffer2;
    }

    public static final String[] split(String string, String string2) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static final String chop(String string, int n) {
        return Strings.chop(string, n, EOL);
    }

    public static final String chop(String string, int n, String string2) {
        char[] cArray = string.toCharArray();
        int n2 = cArray.length;
        if (string2.length() == 2) {
            char c2 = string2.charAt(0);
            char c3 = string2.charAt(1);
            while (n > 0) {
                n2 = cArray[n2 - 1] == c3 && cArray[n2 - 2] == c2 ? (n2 -= 2) : --n2;
                --n;
            }
        } else {
            n2 -= n;
        }
        return new String(cArray, 0, n2);
    }

    public static final StringBuffer stringSubstitution(String string, Hashtable hashtable) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        block3: while (n < string.length()) {
            char c2 = string.charAt(n);
            switch (c2) {
                case '$': {
                    String string2;
                    StringBuffer stringBuffer2 = new StringBuffer();
                    ++n;
                    while (n < string.length() && ((c2 = string.charAt(n)) == '_' || Character.isLetterOrDigit(c2))) {
                        stringBuffer2.append(c2);
                        ++n;
                    }
                    if (stringBuffer2.length() <= 0 || (string2 = (String)hashtable.get(stringBuffer2.toString())) == null) continue block3;
                    stringBuffer.append(string2);
                    break;
                }
                default: {
                    stringBuffer.append(c2);
                    ++n;
                }
            }
        }
        return stringBuffer;
    }

    public static final String fileContentsToString(String string) {
        String string2 = "";
        File file = new File(string);
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                char[] cArray = new char[(int)file.length()];
                fileReader.read(cArray);
                string2 = new String(cArray);
            }
            catch (Exception exception) {
                System.out.println(exception);
                exception.printStackTrace();
            }
        }
        return string2;
    }

    public static final String collapseNewlines(String string) {
        if (string == null) {
            return string;
        }
        if (string.length() == 0) {
            return string;
        }
        char c2 = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == '\n' && c2 == '\n') continue;
            stringBuffer.append(c3);
            c2 = c3;
        }
        return stringBuffer.toString();
    }

    public static final String collapseSpaces(String string) {
        char c2 = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c3 = string.charAt(i2);
            if (c3 == ' ' && c2 == ' ') continue;
            stringBuffer.append(c3);
            c2 = c3;
        }
        return stringBuffer.toString();
    }

    public static final String sub(String string, String string2, String string3) {
        int n = 0;
        if ((n = string.indexOf(string2, n)) >= 0) {
            char[] cArray = string.toCharArray();
            char[] cArray2 = string3.toCharArray();
            int n2 = string2.length();
            StringBuffer stringBuffer = new StringBuffer(cArray.length);
            stringBuffer.append(cArray, 0, n).append(cArray2);
            int n3 = n += n2;
            while ((n = string.indexOf(string2, n)) > 0) {
                stringBuffer.append(cArray, n3, n - n3).append(cArray2);
                n3 = n += n2;
            }
            stringBuffer.append(cArray, n3, cArray.length - n3);
            return stringBuffer.toString();
        }
        return string;
    }

    public static final String stackTrace(Throwable throwable) {
        String string = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            throwable.printStackTrace(new PrintWriter(byteArrayOutputStream, true));
            string = byteArrayOutputStream.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string;
    }

    public static final String normalizePath(String string) {
        int n;
        String string2 = string;
        if (string2.indexOf(92) >= 0) {
            string2 = string2.replace('\\', '/');
        }
        if (!string2.startsWith("/")) {
            string2 = "/" + string2;
        }
        while ((n = string2.indexOf("//")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 1);
        }
        while ((n = string2.indexOf("%20")) >= 0) {
            string2 = string2.substring(0, n) + " " + string2.substring(n + 3);
        }
        while ((n = string2.indexOf("/./")) >= 0) {
            string2 = string2.substring(0, n) + string2.substring(n + 2);
        }
        while ((n = string2.indexOf("/../")) >= 0) {
            if (n == 0) {
                return null;
            }
            int n2 = string2.lastIndexOf(47, n - 1);
            string2 = string2.substring(0, n2) + string2.substring(n + 3);
        }
        return string2;
    }

    public final String select(boolean bl, String string, String string2) {
        if (bl) {
            return string;
        }
        return string2;
    }

    public final boolean allEmpty(List list) {
        int n = list.size();
        for (int i2 = 0; i2 < n; ++i2) {
            if (list.get(i2) == null || list.get(i2).toString().length() <= 0) continue;
            return false;
        }
        return true;
    }

    public static final String prepad(String string, int n) {
        return Strings.prepad(string, n, ' ');
    }

    public static final String prepad(String string, int n, char c2) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(c2);
        }
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static final String postpad(String string, int n) {
        return Strings.postpad(string, n, ' ');
    }

    public static final String postpad(String string, int n, char c2) {
        int n2 = n - string.length();
        if (n2 <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(string);
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuffer.append(c2);
        }
        return stringBuffer.toString();
    }

    public static final String[] split2(String string, String string2) {
        int n;
        int n2;
        int n3 = string.length();
        if (string2 == null || (n2 = string2.length()) == 0) {
            return new String[]{string};
        }
        int n4 = 0;
        int n5 = 0;
        while ((n = string.indexOf(string2, n5)) != -1) {
            ++n4;
            n5 = n + n2;
        }
        String[] stringArray = new String[++n4];
        n4 = 0;
        n5 = 0;
        while ((n = string.indexOf(string2, n5)) != -1) {
            stringArray[n4] = string.substring(n5, n);
            ++n4;
            n5 = n + n2;
        }
        n = n3;
        stringArray[n4] = string.substring(n5, n);
        return stringArray;
    }

    public static final String replace(String string, String string2, String string3) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6 = string.length();
        if (string2 == null || (n5 = string2.length()) == 0) {
            return string;
        }
        if (string3 == null) {
            string3 = "";
        }
        if (n5 == (n4 = string3.length())) {
            n3 = n6;
        } else {
            int n7;
            n2 = 0;
            n = 0;
            while ((n7 = string.indexOf(string2, n)) != -1) {
                ++n2;
                n = n7 + n5;
            }
            if (n2 == 0) {
                return string;
            }
            n3 = n6 - n2 * (n4 - n5);
        }
        n2 = 0;
        n = string.indexOf(string2, n2);
        if (n == -1) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        while (n != -1) {
            stringBuffer.append(string.substring(n2, n));
            stringBuffer.append(string3);
            n2 = n + n5;
            n = string.indexOf(string2, n2);
        }
        n = n6;
        stringBuffer.append(string.substring(n2, n));
        return stringBuffer.toString();
    }

    public static final String escapeHTML(String string) {
        int n;
        int n2;
        int n3 = n2 = string.length();
        block12: for (int i2 = 0; i2 < n2; ++i2) {
            n = string.charAt(i2);
            switch (n) {
                case 34: 
                case 39: {
                    n3 += 5;
                    continue block12;
                }
                case 38: {
                    n3 += 4;
                    continue block12;
                }
                case 60: 
                case 62: {
                    n3 += 3;
                }
            }
        }
        if (n2 == n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        block13: for (n = 0; n < n2; ++n) {
            char c2 = string.charAt(n);
            switch (c2) {
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block13;
                }
                case '\'': {
                    stringBuffer.append("&apos;");
                    continue block13;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block13;
                }
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block13;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block13;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String escapeSQL(String string) {
        int n;
        int n2;
        int n3 = n2 = string.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            n = string.charAt(i2);
            switch (n) {
                case 34: 
                case 39: 
                case 48: 
                case 92: {
                    ++n3;
                }
            }
        }
        if (n2 == n3) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n3);
        block10: for (n = 0; n < n2; ++n) {
            char c2 = string.charAt(n);
            switch (c2) {
                case '\\': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\"': {
                    stringBuffer.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    stringBuffer.append("\\'");
                    continue block10;
                }
                case '0': {
                    stringBuffer.append("\\0");
                    continue block10;
                }
                default: {
                    stringBuffer.append(c2);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static final String toHexString(byte[] byArray) {
        int n = 0;
        char[] cArray = new char[byArray.length * 2];
        for (int i2 = 0; i2 < byArray.length; ++i2) {
            cArray[n++] = toHex[byArray[i2] >> 4 & 0xF];
            cArray[n++] = toHex[byArray[i2] & 0xF];
        }
        return new String(cArray);
    }

    public static final String wrap(int n, String string) {
        if (string == null || string.length() < n) {
            return string;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
            if (stringBuffer.length() - n2 > n) {
                stringBuffer.append('\n');
                n2 = stringBuffer.length();
                continue;
            }
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    public static final String justify(String string, int n) {
        String string2;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\t \f\n", true);
        StringBuffer stringBuffer = new StringBuffer(500);
        int n2 = 0;
        boolean bl = false;
        boolean bl2 = true;
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            if (string2.equals("\n")) {
                if (n == 0) continue;
                if (bl) {
                    stringBuffer.append('\n');
                    stringBuffer.append('\n');
                    n2 = 0;
                    bl2 = true;
                    bl = false;
                    continue;
                }
                bl = true;
                continue;
            }
            if (string2.equals(" ") || string2.equals("\t") || string2.equals("\f")) {
                bl = false;
                continue;
            }
            bl = false;
            int n3 = string2.length();
            if (!bl2) {
                ++n3;
            }
            if (n2 + n3 > n) {
                stringBuffer.append('\n');
                bl2 = true;
                n2 = 0;
            }
            if (!bl2) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string2);
            n2 += n3;
            bl2 = false;
        }
        string2 = stringBuffer.toString();
        stringBuffer = null;
        return string2;
    }

    public static final boolean isAlphaNumeric(String string) {
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (Character.isLetterOrDigit(string.charAt(i2))) continue;
            return false;
        }
        return true;
    }

    public static final String join(String[] stringArray, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(string);
            }
            stringBuffer.append(stringArray[i2]);
        }
        return stringBuffer.toString();
    }

    public static final boolean hasNonAlphaNumericCharacters(String string) {
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (Character.isLetterOrDigit(cArray[i2])) continue;
            return true;
        }
        return false;
    }

    public static final boolean hasNonAlphaNumericCharacters(String string, char[] cArray) {
        char[] cArray2 = string.toCharArray();
        for (int i2 = 0; i2 < cArray2.length; ++i2) {
            if (Strings.isIgnore(cArray2[i2], cArray) || Character.isLetterOrDigit(cArray2[i2])) continue;
            return true;
        }
        return false;
    }

    public static final String stripNonAlphaNumericCharacters(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (!Character.isLetterOrDigit(cArray[i2])) continue;
            stringBuffer.append(cArray[i2]);
        }
        return stringBuffer.toString();
    }

    public static final String stripNonAlphaNumericCharacters(String string, char[] cArray) {
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray2 = string.toCharArray();
        for (int i2 = 0; i2 < cArray2.length; ++i2) {
            if (Strings.isIgnore(cArray2[i2], cArray) || !Character.isLetterOrDigit(cArray2[i2])) continue;
            stringBuffer.append(cArray2[i2]);
        }
        return stringBuffer.toString();
    }

    public static final boolean isAscii(char c2) {
        return (c2 & 0xFF80) == 0;
    }

    public static final boolean isExtendedAscii(char c2) {
        return (c2 & 0xFF00) == 0;
    }

    private static boolean isIgnore(char c2, char[] cArray) {
        for (int i2 = 0; i2 < cArray.length; ++i2) {
            if (c2 != cArray[i2]) continue;
            return true;
        }
        return false;
    }

    public static final int findNumCommon(String[] stringArray, String[] stringArray2) {
        int n;
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (n = 0; n < stringArray.length; ++n) {
            hashSet.add(stringArray[n]);
        }
        n = 0;
        for (int i2 = 0; i2 < stringArray2.length; ++i2) {
            if (!hashSet.contains(stringArray2[i2])) continue;
            ++n;
        }
        return n;
    }
}

