/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import Acme.JPM.Encoders.GifEncoder;
import com.sun.media.jai.codec.PNGEncodeParam$RGB;
import edu.mit.broad.genome.XLogger;
import edu.mit.broad.genome.swing.image.NamedImage;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import javax.media.jai.JAI;
import org.apache.log4j.Logger;

public class ImageUtils {
    private static final Logger klog = XLogger.getLogger(ImageUtils.class);

    private ImageUtils() {
    }

    public static final BufferedImage createHeadlessNaImage() {
        BufferedImage bufferedImage = new BufferedImage(50, 50, 1);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.WHITE);
        graphics.fillRect(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
        graphics.setColor(Color.BLACK);
        graphics.drawString("Images NA in Headless mode", 2, 10);
        graphics.dispose();
        return bufferedImage;
    }

    public static final Image toImage(BufferedImage bufferedImage) {
        AffineTransformOp affineTransformOp = new AffineTransformOp(new AffineTransform(), 2);
        BufferedImageFilter bufferedImageFilter = new BufferedImageFilter(affineTransformOp);
        FilteredImageSource filteredImageSource = new FilteredImageSource(bufferedImage.getSource(), bufferedImageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public static final Image toImage2(BufferedImage bufferedImage) {
        return Toolkit.getDefaultToolkit().createImage(bufferedImage.getSource());
    }

    public static final BufferedImage toBufferedImage(Image image, ImageObserver imageObserver) {
        int n = image.getWidth(imageObserver);
        int n2 = image.getHeight(imageObserver);
        BufferedImage bufferedImage = new BufferedImage(n, n2, 3);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, imageObserver);
        return bufferedImage;
    }

    public static final BufferedImage copy(BufferedImage bufferedImage) {
        return bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
    }

    public static final BufferedImage createThumbnail(float f2, Image image) {
        double d2 = (double)f2 / (double)image.getHeight(null);
        if (image.getWidth(null) > image.getHeight(null)) {
            d2 = (double)f2 / (double)image.getWidth(null);
        }
        int n = (int)(d2 * (double)image.getWidth(null));
        int n2 = (int)(d2 * (double)image.getHeight(null));
        BufferedImage bufferedImage = new BufferedImage(n, n2, 1);
        AffineTransform affineTransform = new AffineTransform();
        if (d2 < 1.0) {
            affineTransform.scale(d2, d2);
        }
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, affineTransform, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static final void savePng(BufferedImage bufferedImage, File file) {
        JAI.create("filestore", (RenderedImage)bufferedImage, (Object)file.getPath(), (Object)"png", (Object)new PNGEncodeParam$RGB());
    }

    public static final void saveGif(Image image, File file) {
        FileOutputStream fileOutputStream = new FileOutputStream(file.getPath());
        GifEncoder gifEncoder = new GifEncoder(image, (OutputStream)fileOutputStream);
        gifEncoder.encode();
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static final BufferedImage appendVertically(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = Math.max(bufferedImage.getWidth(), bufferedImage2.getWidth());
        int n2 = bufferedImage.getHeight() + bufferedImage2.getHeight();
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        graphics2D.drawImage(bufferedImage2, null, 0, bufferedImage.getHeight());
        graphics2D.dispose();
        return bufferedImage3;
    }

    public static final BufferedImage appendHorizontally(BufferedImage bufferedImage, BufferedImage bufferedImage2) {
        int n = bufferedImage.getWidth() + bufferedImage2.getWidth();
        int n2 = Math.max(bufferedImage.getHeight(), bufferedImage2.getHeight());
        BufferedImage bufferedImage3 = new BufferedImage(n, n2, 1);
        Graphics2D graphics2D = bufferedImage3.createGraphics();
        graphics2D.drawImage(bufferedImage, null, 0, 0);
        graphics2D.drawImage(bufferedImage2, null, bufferedImage.getWidth(), 0);
        graphics2D.dispose();
        return bufferedImage3;
    }

    public static final BufferedImage appendHorizontally(NamedImage[] namedImageArray) {
        BufferedImage[] bufferedImageArray = new BufferedImage[namedImageArray.length];
        for (int i2 = 0; i2 < bufferedImageArray.length; ++i2) {
            bufferedImageArray[i2] = (BufferedImage)namedImageArray[i2].getImage();
        }
        return ImageUtils.appendHorizontally(bufferedImageArray);
    }

    public static final BufferedImage appendHorizontally(BufferedImage[] bufferedImageArray) {
        if (bufferedImageArray == null) {
            throw new IllegalArgumentException("Param bifs cannot be null");
        }
        if (bufferedImageArray.length == 0) {
            throw new IllegalArgumentException("Cannot make appended image as there are no input images: " + bufferedImageArray.length);
        }
        int n = ImageUtils.findMaxHeight(bufferedImageArray);
        int n2 = ImageUtils.getTotalWidth(bufferedImageArray);
        klog.info("Total width: " + n2 + " maxheight: " + n);
        BufferedImage bufferedImage = new BufferedImage(n2, n, 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        int n3 = 0;
        for (int i2 = 0; i2 < bufferedImageArray.length; ++i2) {
            int n4 = bufferedImageArray[i2].getWidth();
            klog.debug(" Width: " + n4 + " height: " + bufferedImageArray[i2].getHeight());
            graphics2D.drawImage(bufferedImageArray[i2], null, n3, 0);
            n3 += n4;
        }
        graphics2D.dispose();
        return bufferedImage;
    }

    public static final int findMaxHeight(BufferedImage[] bufferedImageArray) {
        if (bufferedImageArray == null) {
            throw new IllegalArgumentException("Param bifs cannot be null");
        }
        int n = 0;
        for (int i2 = 0; i2 < bufferedImageArray.length; ++i2) {
            if (bufferedImageArray[i2] == null) {
                throw new IllegalArgumentException("bif cannot be null at: " + i2);
            }
            if (bufferedImageArray[i2].getHeight() <= n) continue;
            n = bufferedImageArray[i2].getHeight();
        }
        return n;
    }

    public static final int findMaxWidth(BufferedImage[] bufferedImageArray) {
        if (bufferedImageArray == null) {
            throw new IllegalArgumentException("Param bifs cannot be null");
        }
        int n = 0;
        for (int i2 = 0; i2 < bufferedImageArray.length; ++i2) {
            if (bufferedImageArray[i2].getWidth() <= n) continue;
            n = bufferedImageArray[i2].getWidth();
        }
        return n;
    }

    public static final int getTotalWidth(BufferedImage[] bufferedImageArray) {
        if (bufferedImageArray == null) {
            throw new IllegalArgumentException("Param bifs cannot be null");
        }
        int n = 0;
        for (int i2 = 0; i2 < bufferedImageArray.length; ++i2) {
            n += bufferedImageArray[i2].getWidth();
        }
        return n;
    }

    public static final int getTotalHeight(BufferedImage[] bufferedImageArray) {
        if (bufferedImageArray == null) {
            throw new IllegalArgumentException("Param bifs cannot be null");
        }
        int n = 0;
        for (int i2 = 0; i2 < bufferedImageArray.length; ++i2) {
            n += bufferedImageArray[i2].getHeight();
        }
        return n;
    }
}

