/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.utils.MonthConstants;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateUtils
implements MonthConstants {
    private final SimpleDateFormat fmt;
    private static final Calendar CALENDAR = Calendar.getInstance();
    public static final int HYPHENDED_DIGITS = 1;

    public DateUtils(String string) {
        this.fmt = new SimpleDateFormat(this.constructPattern(string));
        this.fmt.setTimeZone(TimeZone.getDefault());
    }

    public static final String toDayMonYear(long l2) {
        Date date = new Date(l2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("EEE, MMM d, ''yy");
        return simpleDateFormat.format(date);
    }

    public static final String toHourMin(long l2) {
        Date date = new Date(l2);
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("K a m");
        return simpleDateFormat.format(date);
    }

    public final Date parse(String string) {
        return this.fmt.parse(string);
    }

    public final synchronized String format(Calendar calendar) {
        return this.format(calendar.getTime());
    }

    public final synchronized String format() {
        return this.format(new Date());
    }

    public final synchronized String format(Date date) {
        return this.fmt.format(date);
    }

    private String constructPattern(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        block30: for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!bl) {
                switch (c2) {
                    case '\t': 
                    case ' ': 
                    case '(': 
                    case ')': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case ';': {
                        stringBuffer.append(c2);
                        bl = false;
                        continue block30;
                    }
                    case '%': {
                        if (bl) {
                            stringBuffer.append(c2);
                            bl = false;
                            continue block30;
                        }
                        bl = true;
                        continue block30;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown format character :" + c2);
                    }
                }
            }
            switch (c2) {
                case 'a': {
                    stringBuffer.append("EE");
                    break;
                }
                case 'A': {
                    stringBuffer.append("EEEE");
                    break;
                }
                case 'b': {
                    stringBuffer.append("MMM");
                    break;
                }
                case 'B': {
                    stringBuffer.append("MMMM");
                    break;
                }
                case 'd': {
                    stringBuffer.append("dd");
                    break;
                }
                case 'e': {
                    stringBuffer.append('d');
                    break;
                }
                case 'H': {
                    stringBuffer.append("HH");
                    break;
                }
                case 'I': {
                    stringBuffer.append("hh");
                    break;
                }
                case 'j': {
                    stringBuffer.append("DDD");
                    break;
                }
                case 'm': {
                    stringBuffer.append("MM");
                    break;
                }
                case 'M': {
                    stringBuffer.append("mm");
                    break;
                }
                case 'N': {
                    stringBuffer.append('G');
                    break;
                }
                case 'p': {
                    stringBuffer.append('a');
                    break;
                }
                case 'r': {
                    stringBuffer.append(this.constructPattern("%I:%M:%S %p"));
                    break;
                }
                case 'R': {
                    stringBuffer.append(this.constructPattern("%H:%M"));
                    break;
                }
                case 'S': {
                    stringBuffer.append("ss");
                    break;
                }
                case 't': {
                    stringBuffer.append('\t');
                    break;
                }
                case 'T': {
                    stringBuffer.append(this.constructPattern("%H:%M:%S"));
                    break;
                }
                case 'u': {
                    stringBuffer.append("EE");
                    break;
                }
                case 'U': {
                    stringBuffer.append("ww");
                    break;
                }
                case 's': {
                    stringBuffer.append("SSS");
                    break;
                }
                case 'y': {
                    stringBuffer.append("yy");
                    break;
                }
                case 'Y': {
                    stringBuffer.append("yyyy");
                    break;
                }
                case 'Z': {
                    stringBuffer.append("zzzz");
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown escape sequence: %" + c2);
                }
            }
            bl = false;
        }
        return stringBuffer.toString();
    }

    public static final String getDateString(int n) {
        if (n == 1) {
            return DateUtils.hyphened_digits();
        }
        throw new IllegalArgumentException("Invalid format type " + n);
    }

    public static final String getDate() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = gregorianCalendar.getTime();
        DateFormat dateFormat = DateFormat.getDateInstance();
        return dateFormat.format(date);
    }

    public static final synchronized Date createDate(int n, int n2, int n3) {
        CALENDAR.set(n, n2 - 1, n3);
        return CALENDAR.getTime();
    }

    public static final synchronized Date createDate(int n, int n2, int n3, int n4, int n5) {
        CALENDAR.set(n, n2, n3, n4, n5);
        return CALENDAR.getTime();
    }

    private static synchronized String hyphened_digits() {
        Calendar calendar = Calendar.getInstance();
        String string = (calendar.get(1) + "").substring(2);
        String string2 = calendar.get(2) + 1 + "";
        String string3 = calendar.get(5) + "";
        String string4 = calendar.get(10) + "";
        String string5 = calendar.get(12) + "";
        int n = calendar.get(9);
        String string6 = n == 0 ? "AM" : "PM";
        if (string2.length() == 1) {
            string2 = "0" + string2;
        }
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if (string4.length() == 1) {
            string4 = "0" + string4;
        }
        if (string5.length() == 1) {
            string5 = "0" + string5;
        }
        return string + "-" + string2 + "-" + string3 + "_" + string4 + "-" + string5 + "-" + string6;
    }
}

