/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.broad.genome.utils;

import edu.mit.broad.genome.XLogger;
import gnu.trove.TFloatArrayList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.log4j.Logger;

public class ArrayUtils {
    private static final Logger klog = XLogger.getLogger(ArrayUtils.class);

    private ArrayUtils() {
    }

    public static final String[] subtract(List list, String[] stringArray) {
        ArrayList arrayList = new ArrayList(list);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.remove(stringArray[i2]);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static final List toList(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            arrayList.add(stringArray[i2]);
        }
        return arrayList;
    }

    public static final Set toSet(String[] stringArray) {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            hashSet.add(stringArray[i2]);
        }
        return hashSet;
    }

    public static final int[] complement(int[] nArray, int n) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            if (nArray[i2] < 0) {
                throw new IllegalArgumentException("Exclude array has negative element value: " + nArray[i2] + " at: " + i2);
            }
            if (nArray[i2] >= n) {
                throw new IllegalArgumentException("Exclude array has element of value: " + nArray[i2] + " that is  >= max: " + n + " at pos: " + i2);
            }
            arrayList.add(new Integer(nArray[i2]));
        }
        int[] nArray2 = new int[n - nArray.length];
        int n2 = 0;
        for (int i3 = 0; i3 < n; ++i3) {
            if (arrayList.contains(new Integer(i3))) continue;
            nArray2[n2++] = i3;
        }
        return nArray2;
    }

    public static final String[] removeElement(int n, String[] stringArray) {
        if (n >= stringArray.length) {
            throw new IllegalArgumentException("Index for removal: " + n + " is greater than array len: " + stringArray.length);
        }
        String[] stringArray2 = new String[stringArray.length - 1];
        int n2 = 0;
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            if (i2 == n) continue;
            stringArray2[n2++] = stringArray[i2];
        }
        return stringArray2;
    }

    public static final int[] rangeAsElements(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Max: " + n2 + " less than min: " + n);
        }
        int[] nArray = new int[n2 - n + 1];
        int n3 = n;
        for (int i2 = 0; i2 < n2 - n + 1; ++i2) {
            nArray[i2] = n3++;
        }
        return nArray;
    }

    public static final Vector rangeAsUtilVector(int n, int n2) {
        if (n2 < n) {
            throw new IllegalArgumentException("Max: " + n2 + " less than min: " + n);
        }
        Vector<Integer> vector = new Vector<Integer>(n2 - n + 1);
        int n3 = n;
        for (int i2 = 0; i2 < n2 - n + 1; ++i2) {
            vector.add(new Integer(n3++));
        }
        return vector;
    }

    public static final int[] complementRangeAsElements(int n, int n2, int n3) {
        if (n2 < n) {
            throw new IllegalArgumentException("Max: " + n2 + " less than min: " + n);
        }
        int[] nArray = new int[n3 - (n2 - n + 1)];
        int n4 = 0;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (i2 >= n && i2 <= n2) continue;
            nArray[n4++] = i2;
        }
        return nArray;
    }

    public static final float[] unique(float[] fArray) {
        TFloatArrayList tFloatArrayList = new TFloatArrayList();
        float[] fArray2 = new float[fArray.length];
        System.arraycopy(fArray, 0, fArray2, 0, fArray.length);
        Arrays.sort(fArray2);
        float f2 = fArray2[0];
        tFloatArrayList.add(f2);
        for (int i2 = 1; i2 < fArray.length; ++i2) {
            if (fArray2[i2] == f2) continue;
            tFloatArrayList.add(fArray2[i2]);
            f2 = fArray2[i2];
        }
        klog.debug("# of non-uniq elements: " + fArray.length + " # of uniq elements: " + tFloatArrayList.size());
        return tFloatArrayList.toNativeArray();
    }

    public static final int[] sub(int n, int[] nArray) {
        if (n > nArray.length) {
            n = nArray.length;
        }
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, n);
        return nArray2;
    }

    public static final int[] sub(int n, int n2, int[] nArray) {
        int n3;
        int[] nArray2 = new int[n + n2];
        int n4 = 0;
        for (n3 = 0; n3 < n; ++n3) {
            nArray2[n4++] = nArray[n3];
        }
        for (n3 = nArray.length - n2; n3 < nArray.length; ++n3) {
            nArray2[n4++] = nArray[n3];
        }
        return nArray2;
    }

    public static final List expand(List list, String string) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            StringTokenizer stringTokenizer = new StringTokenizer((String)list.get(i2), string);
            while (stringTokenizer.hasMoreElements()) {
                arrayList.add(stringTokenizer.nextElement());
            }
        }
        return arrayList;
    }

    public static final int[] fill(int n, int n2, int n3) {
        int n4 = 0;
        for (int i2 = n; i2 <= n2; i2 += n3) {
            ++n4;
        }
        int[] nArray = new int[n4];
        n4 = 0;
        for (int i3 = n; i3 <= n2; i3 += n3) {
            nArray[n4++] = i3;
        }
        return nArray;
    }
}

